/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.pdk.dom4j;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.common.ConversationContext;
import com.cognos.pogo.pdk.dom4j.Dom4jBase;
import com.cognos.pogo.pdk.dom4j.Dom4jEnvelope;
import org.dom4j.Element;

public class Dom4jConversationContext
extends Dom4jBase
implements ConversationContext {
    private final BIBusEnvelope envelope;

    public Dom4jConversationContext(BIBusEnvelope envelope) {
        this.envelope = envelope;
    }

    private Element getMandatoryConversationContext() {
        return this.envelope.getConversationContext();
    }

    private Element getOptionalConversationContext() {
        Element tracking = this.envelope.getBIBusHeader().element(Dom4jEnvelope.BUS_TRACKING.getName());
        return tracking != null ? tracking.element("conversationContext") : null;
    }

    private String getOptionalElementText(String elementName) {
        Element conversationContext = this.getOptionalConversationContext();
        return conversationContext != null ? conversationContext.elementText(elementName) : null;
    }

    @Override
    public int getAffinityStrength() {
        String strength = this.getOptionalElementText("affinityStrength");
        return Dom4jConversationContext.parseInt("affinityStrength", strength, -1);
    }

    @Override
    public String getId() {
        return this.getOptionalElementText("id");
    }

    @Override
    public String getNodeId() {
        return this.getOptionalElementText("nodeID");
    }

    @Override
    public int getProcessId() {
        String processId = this.getOptionalElementText("processID");
        return Dom4jConversationContext.parseInt("processID", processId, -1);
    }

    @Override
    public String getStatus() {
        return this.getOptionalElementText("status");
    }

    @Override
    public void setAffinityStrength(int affinityStrength) {
        this.setElementText("affinityStrength", BIBusEnvelope.XSD_INT, String.valueOf(affinityStrength));
    }

    @Override
    public void setId(String id) {
        this.setElementText("id", BIBusEnvelope.XSD_STRING, id);
    }

    @Override
    public void setNodeId(String nodeId) {
        this.setElementText("nodeID", BIBusEnvelope.XSD_STRING, nodeId);
    }

    @Override
    public void setProcessId(int processId) {
        this.setElementText("processID", BIBusEnvelope.XSD_INT, String.valueOf(processId));
    }

    @Override
    public void setStatus(String status) {
        this.setElementText("status", BIBusEnvelope.XSD_STRING, status);
    }

    @Override
    public void clear() {
        this.clear(this.getMandatoryConversationContext());
    }

    private void setElementText(String name, String type, String value) {
        Dom4jConversationContext.setChildElementText(this.getMandatoryConversationContext(), name, type, value);
    }

    @Override
    public String asXML() {
        Element conversationContext = this.getOptionalConversationContext();
        return conversationContext != null ? conversationContext.asXML() : null;
    }

    @Override
    public boolean isEmpty() {
        Element conversationContext = this.getOptionalConversationContext();
        return conversationContext == null || conversationContext.elements().isEmpty();
    }

    @Override
    public boolean isPresent() {
        return this.getOptionalConversationContext() != null;
    }
}

