/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.pdk.dom4j;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.common.CookieVars;
import com.cognos.pogo.util.DomUtils;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;

public class Dom4jCookieVars
implements CookieVars {
    private final BIBusEnvelope envelope;

    public Dom4jCookieVars(BIBusEnvelope envelope) {
        this.envelope = envelope;
    }

    @Override
    public String getValue(String name) {
        return this.envelope.getCookieValue(name);
    }

    @Override
    public void setValue(String name, String value) {
        this.envelope.setCookie(name, value);
    }

    @Override
    public int size() {
        return this.isPresent() ? this.envelope.getCookieVars().elements().size() : 0;
    }

    @Override
    public String asXML() {
        return this.envelope.getCookieVars().asXML();
    }

    @Override
    public boolean isEmpty() {
        return !this.isPresent() || this.envelope.getCookieVars().elements().isEmpty();
    }

    @Override
    public boolean isPresent() {
        Element hdrElement = this.envelope.getBIBusHeader().element(BIBusEnvelope.BUS_HDR_SESSION);
        return hdrElement != null && hdrElement.element(BIBusEnvelope.BUS_COOKIE_VARS) != null;
    }

    @Override
    public void clear() {
        Element element = this.envelope.getCookieVars();
        if (element != null) {
            element.detach();
        }
    }

    @Override
    public Set<String> getNames() {
        if (this.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> names = new HashSet<String>(this.size());
        this.copyCookieNames(names);
        return names;
    }

    private void copyCookieNames(Set<String> names) {
        for (Element cookie : this.envelope.getCookieVars().elements()) {
            this.copyCookieName(names, cookie);
        }
    }

    private void copyCookieName(Set<String> names, Element next) {
        String cookieName = next.elementText("name");
        if (StringUtils.isNotEmpty((String)cookieName)) {
            names.add(cookieName);
        }
    }

    @Override
    public void remove(String name) {
        DomUtils.removeNameValuePair(this.envelope.getCookieVars(), name);
    }
}

