/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.pdk.dom4j;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.SOAPException;
import com.cognos.pogo.pdk.common.BodyHandler;
import com.cognos.pogo.pdk.stax.StaxEnvelope;
import com.cognos.pogo.pdk.stax.StaxEnvelopeFactory;
import com.cognos.pogo.util.PogoLogger;
import java.io.InputStream;
import java.io.Reader;
import org.dom4j.Document;
import org.dom4j.Element;

public class Dom4jEnvelope
extends BIBusEnvelope {
    private static PogoLogger log = PogoLogger.getLogger();

    public Dom4jEnvelope() {
    }

    public Dom4jEnvelope(Reader reader) throws SOAPException {
        super(reader);
    }

    public Dom4jEnvelope(InputStream stream) throws SOAPException {
        super(stream);
    }

    public Dom4jEnvelope(Element headerElement, Element bodyElement) {
        super(headerElement, bodyElement);
    }

    public Dom4jEnvelope(Document document) {
        super(document);
    }

    @Override
    public StaxEnvelope toStax(BodyHandler bodyHandler) throws Exception {
        log.info("Converting dom4j envelope to STAX (using getAsString(standard))");
        return StaxEnvelopeFactory.createStaxEnvelope(this.getAsString(STANDARD_FORMAT), bodyHandler);
    }

    @Override
    public BIBusEnvelope toStax(BodyHandler bodyHandler, InputStream stream) throws Exception {
        if (stream == null) {
            return this.toStax(bodyHandler);
        }
        log.info("Converting dom4j envelope to STAX (using input stream)");
        return StaxEnvelopeFactory.createStaxEnvelope(stream, bodyHandler);
    }

    @Override
    public BIBusEnvelope newBIBusEnvelope() {
        return new Dom4jEnvelope();
    }
}

