/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.pdk.dom4j;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.SOAPException;
import com.cognos.pogo.pdk.common.BodyFault;
import com.cognos.pogo.pdk.common.BodyHandler;
import com.cognos.pogo.pdk.common.CompatibleEnvelopeFactory;
import com.cognos.pogo.pdk.common.Envelope;
import com.cognos.pogo.pdk.dom4j.Dom4jEnvelope;
import com.cognos.pogo.pdk.dom4j.Dom4jSoapFaultException;
import com.cognos.pogo.util.PogoLogger;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import org.dom4j.Document;

public class Dom4jEnvelopeFactory
extends CompatibleEnvelopeFactory {
    private static final PogoLogger log = PogoLogger.getLogger();

    @Override
    public Dom4jEnvelope createEnvelope(BodyHandler bodyHandler) {
        return Dom4jEnvelopeFactory.createDom4jEnvelope();
    }

    @Override
    public Dom4jEnvelope createEnvelope(Reader reader, BodyHandler bodyHandler) throws Exception {
        return Dom4jEnvelopeFactory.createDom4jEnvelope(reader);
    }

    @Override
    public BIBusEnvelope createEnvelope(InputStream stream, BodyHandler bodyHandler) throws Exception {
        if (this.isLocal(stream)) {
            log.debug("Trying to reuse envelope from local response stream");
            return (BIBusEnvelope)this.getLocalResponseEnvelope(stream).toDom4j(stream);
        }
        return Dom4jEnvelopeFactory.createDom4jEnvelope(stream);
    }

    @Override
    public Dom4jEnvelope createEnvelope(String xml, BodyHandler bodyHandler) throws Exception {
        return Dom4jEnvelopeFactory.createDom4jEnvelope(xml);
    }

    public static Dom4jEnvelope createDom4jEnvelope() {
        log.debug("Creating empty Dom4jEnvelope");
        return new Dom4jEnvelope();
    }

    public static Dom4jEnvelope createDom4jEnvelope(Reader reader) throws SOAPException {
        log.debug("Creating Dom4jEnvelope for Reader");
        return new Dom4jEnvelope(reader);
    }

    public static Dom4jEnvelope createDom4jEnvelope(InputStream stream) throws SOAPException {
        log.debug("Creating Dom4jEnvelope for InputStream");
        return new Dom4jEnvelope(stream);
    }

    public static Dom4jEnvelope createDom4jEnvelope(String xml) throws SOAPException {
        log.debug("Creating Dom4jEnvelope for XML string");
        return new Dom4jEnvelope(new StringReader(xml));
    }

    public static Dom4jEnvelope createDom4jEnvelope(Document document) {
        return new Dom4jEnvelope(document);
    }

    @Override
    public boolean isCompatibleWith(Envelope envelope) {
        return this.isDom4jEnvelope(envelope) || this.isBIBusEnvelopeFinal(envelope);
    }

    private boolean isDom4jEnvelope(Envelope envelope) {
        return envelope instanceof Dom4jEnvelope;
    }

    private boolean isBIBusEnvelopeFinal(Envelope envelope) {
        return envelope.getClass() == BIBusEnvelope.class;
    }

    @Override
    public Dom4jSoapFaultException createSoapFaultException(BodyFault bodyFault) {
        return new Dom4jSoapFaultException(bodyFault);
    }

    @Override
    public String getParserType() {
        return "dom4j";
    }

    @Override
    public Envelope convertEnvelope(BIBusEnvelope envelope, BodyHandler bodyHandler, InputStream inputStream) throws Exception {
        log.debug("Converting ", envelope.getClass().getSimpleName(), " to Dom4jEnvelope.");
        return envelope.toDom4j(inputStream);
    }
}

