/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.pdk.dom4j;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.common.SetCookieVar;
import com.cognos.pogo.pdk.common.SetCookieVars;
import com.cognos.pogo.pdk.dom4j.Dom4jSetCookieVar;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.dom4j.Element;

public class Dom4jSetCookieVars
implements SetCookieVars {
    private final BIBusEnvelope envelope;

    public Dom4jSetCookieVars(BIBusEnvelope envelope) {
        this.envelope = envelope;
    }

    @Override
    public String getValue(String name) {
        return this.envelope.getSetCookieValue(name);
    }

    @Override
    public Dom4jSetCookieVar getSetCookie(String name) {
        Element setCookieVar = this.envelope.getSetCookieVar(name);
        return setCookieVar != null ? new Dom4jSetCookieVar(setCookieVar, name) : null;
    }

    @Override
    public String asXML() {
        Element setCookieVars = this.envelope.getSetCookieVars();
        return setCookieVars != null ? setCookieVars.asXML() : null;
    }

    private List<Element> getSetCookieVarsElements() {
        Element setCookieVars = this.envelope.getSetCookieVars();
        return setCookieVars != null ? setCookieVars.elements() : Collections.EMPTY_LIST;
    }

    @Override
    public boolean isEmpty() {
        return !this.isPresent() || this.getSetCookieVarsElements().isEmpty();
    }

    @Override
    public boolean isPresent() {
        Element hdrElement = this.envelope.getBIBusHeader().element(BIBusEnvelope.BUS_HDR_SESSION);
        return hdrElement != null && hdrElement.element(BIBusEnvelope.BUS_SET_COOKIE_VARS) != null;
    }

    @Override
    public void setSetCookie(String name, String value) {
        this.envelope.setSetCookie(name, value);
    }

    @Override
    public void setSetCookie(String name, String value, Integer maxAge) {
        this.envelope.setSetCookie(name, value, maxAge);
    }

    @Override
    public void clear() {
        Element setCookieVars = this.envelope.getSetCookieVars();
        if (setCookieVars != null) {
            setCookieVars.detach();
        }
    }

    @Override
    public List<SetCookieVar> getSetCookies() {
        ArrayList<SetCookieVar> setCookies = new ArrayList<SetCookieVar>(this.getSize());
        ListIterator<Element> it = this.getSetCookieIterator();
        while (it.hasNext()) {
            setCookies.add(new Dom4jSetCookieVar(it.next()));
        }
        return setCookies;
    }

    private int getSize() {
        return this.getSetCookieVarsElements().size();
    }

    private ListIterator<Element> getSetCookieIterator() {
        return this.getSetCookieVarsElements().listIterator();
    }
}

