/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.pdk.dom4j;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.common.Tracking;
import com.cognos.pogo.pdk.dom4j.Dom4jBase;
import com.cognos.pogo.pdk.dom4j.Dom4jConversationContext;
import com.cognos.pogo.pdk.dom4j.Dom4jEnvelope;
import com.cognos.pogo.pdk.dom4j.Dom4jProviders;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;
import org.dom4j.QName;

public class Dom4jTracking
implements Tracking {
    private final BIBusEnvelope envelope;
    private Dom4jConversationContext conversationContext;
    private Dom4jProviders providers;

    public Dom4jTracking(BIBusEnvelope envelope) {
        this.envelope = envelope;
    }

    @Override
    public Dom4jConversationContext getConversationContext() {
        if (this.conversationContext == null) {
            this.conversationContext = new Dom4jConversationContext(this.envelope);
        }
        return this.conversationContext;
    }

    @Override
    public Dom4jProviders getProviders() {
        if (this.providers == null) {
            this.providers = new Dom4jProviders(this.envelope);
        }
        return this.providers;
    }

    @Override
    public long getHopCount() {
        String hopCountText = this.getElementText(BIBusEnvelope.BUS_HOP_COUNT);
        return Dom4jBase.parseLong("hop count", hopCountText, 0L);
    }

    @Override
    public String getRequestContext() {
        return this.getElementTextTrim(BIBusEnvelope.BUS_REQUEST_CONTEXT);
    }

    @Override
    public String getSessionContext() {
        return this.getElementText(BIBusEnvelope.BUS_SESSION_CONTEXT);
    }

    @Override
    public String getStepContext() {
        return this.getElementText(BIBusEnvelope.BUS_STEP_CONTEXT);
    }

    @Override
    public void setHopCount(long hopCount) {
        this.setChildElementText(BIBusEnvelope.BUS_HOP_COUNT, BIBusEnvelope.XSD_INTEGER, String.valueOf(hopCount));
    }

    @Override
    public long incrementHopCount() {
        long hopCount = this.hasHopCount() ? this.getHopCount() + 1L : 0L;
        this.setHopCount(hopCount);
        return hopCount;
    }

    private boolean hasHopCount() {
        String hopCountText = this.getElementText(BIBusEnvelope.BUS_HOP_COUNT);
        return StringUtils.isNotEmpty((String)hopCountText);
    }

    @Override
    public void setRequestContext(String requestContext) {
        this.setChildElementText(BIBusEnvelope.BUS_REQUEST_CONTEXT, BIBusEnvelope.XSD_STRING, requestContext);
    }

    @Override
    public void setSessionContext(String sessionContext) {
        this.setChildElementText(BIBusEnvelope.BUS_SESSION_CONTEXT, BIBusEnvelope.XSD_STRING, sessionContext);
    }

    @Override
    public void setStepContext(String stepContext) {
        this.setChildElementText(BIBusEnvelope.BUS_STEP_CONTEXT, BIBusEnvelope.XSD_STRING, stepContext);
    }

    @Override
    public String asXML() {
        Element optionalTracking = this.getRawElement();
        return optionalTracking != null ? optionalTracking.asXML() : null;
    }

    private Element getRawElement() {
        return this.envelope.getBIBusHeader().element(Dom4jEnvelope.BUS_TRACKING.getName());
    }

    @Override
    public boolean isEmpty() {
        Element optionalTracking = this.getRawElement();
        return optionalTracking == null || optionalTracking.elements().isEmpty();
    }

    @Override
    public boolean isPresent() {
        return this.envelope.hasOptionalElement(Dom4jEnvelope.BUS_TRACKING);
    }

    private String getElementText(QName qname) {
        Element element = this.getTrackingElement(qname);
        return this.isNull(element) ? null : element.getText();
    }

    private Element getTrackingElement(QName qname) {
        return this.envelope.getTracking().element(qname.getName());
    }

    private boolean isNull(Element element) {
        return element == null || element.attribute(BIBusEnvelope.XSI_NIL) != null;
    }

    private String getElementTextTrim(QName qname) {
        Element element = this.getTrackingElement(qname);
        return this.isNull(element) ? null : element.getTextTrim();
    }

    private void setChildElementText(QName qname, String type, String value) {
        Dom4jBase.setChildElementText(this.envelope.getTracking(), qname.getName(), type, value);
    }
}

