/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.pdk.soapaction;

import com.cognos.p2pd.util.PropertyInserter;
import com.cognos.p2plb.clerver.LoadBalanceHandler;
import com.cognos.p2plb.clerver.balancer.OMBridgeHelper;
import com.cognos.pogo.pdk.Handler;
import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.pogo.pdk.soapaction.WrappedBridgeHandler;
import com.cognos.pogo.util.PogoLogger;
import com.ibm.cognos.internal.ombridge.BibusSoapAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class SoapActionLookup {
    private static final PogoLogger log = PogoLogger.getLogger();
    public static final String ENABLE_AUTOMATIC_BRIDGING = "enableAutomaticBridging";
    private String currentVersion;
    private HashMap<String, HandlerOrigin> mappings = new HashMap();
    private List<String> supportedVersions;
    private OMBridgeHelper bridgeHelper;
    private PogoEngine pogoEngine;
    private boolean enableBridging;

    public SoapActionLookup() {
        this(new OMBridgeHelper());
    }

    public SoapActionLookup(OMBridgeHelper bridgeHelper) {
        this.bridgeHelper = bridgeHelper;
        this.enableBridging = SoapActionLookup.enableAutomaticBridging();
    }

    public static boolean enableAutomaticBridging() {
        String property = PropertyInserter.getProperty(ENABLE_AUTOMATIC_BRIDGING, "false");
        return "true".equalsIgnoreCase(property);
    }

    private void loadVersions() {
        this.supportedVersions = this.bridgeHelper.getSupportedVersions();
        this.currentVersion = this.supportedVersions.get(0);
    }

    private List<String> getSupportedVersions() {
        if (this.supportedVersions == null) {
            this.loadVersions();
        }
        return this.supportedVersions;
    }

    public ArrayList<String> addMapping(String soapAction, Handler handler) {
        return this.addMapping(soapAction, handler, null, false);
    }

    public ArrayList<String> addMapping(String soapAction, Handler handler, String bridgeVersion) {
        return this.addMapping(soapAction, handler, bridgeVersion, false);
    }

    public ArrayList<String> changeMapping(String soapAction, Handler handler) {
        return this.addMapping(soapAction, handler, null, true);
    }

    protected ArrayList<String> addMapping(String soapAction, Handler handler, String bridgeVersion, boolean overwrite) {
        HandlerOrigin handlerOrigin = new HandlerOrigin(handler, soapAction);
        this.addToMappings(soapAction, handlerOrigin, bridgeVersion, overwrite);
        for (String versioned : this.getAllVersions(soapAction)) {
            this.addToMappings(versioned, handlerOrigin, bridgeVersion, overwrite);
        }
        return this.getAllVersions(soapAction);
    }

    private void addToMappings(String soapAction, HandlerOrigin handlerOrigin, String bridgeVersion, boolean overwrite) {
        if (!this.shouldBridge(soapAction, bridgeVersion)) {
            this.maybeAddToMappings(soapAction, handlerOrigin, overwrite);
        } else {
            String version = this.getIncomingVersion(bridgeVersion, soapAction);
            WrappedBridgeHandler wrappedHandler = new WrappedBridgeHandler(handlerOrigin.getHandler(), version, this.getVersionOrLowest(soapAction), this.bridgeHelper);
            wrappedHandler.setPogoEngine(this.pogoEngine);
            this.maybeAddToMappings(soapAction, new HandlerOrigin((Handler)wrappedHandler, handlerOrigin.isWildcard()), overwrite);
        }
    }

    public List<String> transferSoapAction(String soapAction, Handler loadBalanceHandler) {
        ArrayList<String> transferredSoapActions = new ArrayList<String>();
        boolean transferred = false;
        this.transferVersionedSoapAction(soapAction, loadBalanceHandler);
        for (String versioned : this.getAllVersions(soapAction)) {
            transferred |= this.transferVersionedSoapAction(versioned, loadBalanceHandler);
            transferredSoapActions.add(versioned);
        }
        if (!transferred) {
            transferredSoapActions.clear();
        }
        return transferredSoapActions;
    }

    protected boolean transferVersionedSoapAction(String versioned, Handler loadBalanceHandler) {
        HandlerOrigin localHandler = this.mappings.get(versioned);
        if (localHandler == null) {
            this.mappings.put(versioned, new HandlerOrigin(loadBalanceHandler, false));
            log.debug("Added mapping for soap action: ", versioned, " to handler ", loadBalanceHandler);
            return true;
        }
        if (localHandler != null && localHandler.getHandler() != loadBalanceHandler) {
            String localVersion = LoadBalanceHandler.makeLocal(versioned);
            this.mappings.put(localVersion, localHandler);
            this.mappings.put(versioned, new HandlerOrigin(loadBalanceHandler, false));
            log.debug("Transferred soap action ", versioned, " handler ", localHandler);
            return true;
        }
        return false;
    }

    protected String getIncomingVersion(String bridgeVersion, String soapAction) {
        if (StringUtils.isEmpty((String)bridgeVersion)) {
            return this.currentVersion;
        }
        if (this.supportedVersions.contains(bridgeVersion)) {
            return bridgeVersion;
        }
        log.warn("Invalid bridgeVersion ", bridgeVersion, " for soapAction ", soapAction, " using version: ", this.currentVersion);
        return this.currentVersion;
    }

    private String getVersionOrLowest(String soapAction) {
        BibusSoapAction bibusSoapAction = new BibusSoapAction(soapAction);
        if (bibusSoapAction.getFormat() == BibusSoapAction.Format.IBM || bibusSoapAction.getFormat() == BibusSoapAction.Format.Unknown) {
            return this.getVersion(soapAction);
        }
        return this.getSupportedVersions().get(this.supportedVersions.size() - 1);
    }

    private boolean shouldBridge(String soapAction, String bridgeVersion) {
        if (!this.enableBridging || "*".equals(bridgeVersion)) {
            return false;
        }
        BibusSoapAction bibusSoapAction = new BibusSoapAction(soapAction);
        String version = bibusSoapAction.getVersion();
        BibusSoapAction.Format format = bibusSoapAction.getFormat();
        if (format == BibusSoapAction.Format.Unknown) {
            return false;
        }
        return format != BibusSoapAction.Format.IBM || !version.equals(this.currentVersion) && this.getSupportedVersions().contains(version);
    }

    private void maybeAddToMappings(String soapAction, HandlerOrigin handler, boolean overwrite) {
        if (this.shouldAddMapping(soapAction, handler) || overwrite) {
            log.debug("Added mapping for: ", soapAction, " to ", handler);
            this.mappings.put(soapAction, handler);
        } else {
            log.debug("Not overwriting mapping for: ", soapAction, " to ", handler);
        }
    }

    private boolean shouldAddMapping(String soapAction, HandlerOrigin handler) {
        HandlerOrigin existing = this.mappings.get(soapAction);
        return existing == null || existing.isWildcard();
    }

    public ArrayList<String> getAllVersions(String soapAction) {
        ArrayList<String> versionedSoapActions = new ArrayList<String>();
        if (this.hasWildcard(soapAction)) {
            for (String version : this.getSupportedVersions()) {
                String versioned = soapAction.replace("*", version);
                versionedSoapActions.add(versioned);
            }
        }
        return versionedSoapActions;
    }

    private boolean hasWildcard(String soapAction) {
        BibusSoapAction bibusSoapAction = new BibusSoapAction(soapAction);
        return bibusSoapAction.getFormat() == BibusSoapAction.Format.IBM && soapAction.contains("*");
    }

    private String getVersion(String soapAction) {
        BibusSoapAction bibusSoapAction = new BibusSoapAction(soapAction);
        String version = bibusSoapAction.getVersion();
        return this.getSupportedVersions().contains(version) ? version : null;
    }

    public Handler lookupSoapAction(String soapAction) {
        HandlerOrigin handlerOrigin = this.mappings.get(soapAction);
        if (handlerOrigin == null) {
            handlerOrigin = this.lookupPreviousVersion(soapAction);
        }
        return handlerOrigin == null ? null : handlerOrigin.getHandler();
    }

    private HandlerOrigin lookupPreviousVersion(String soapAction) {
        for (String newVersion : this.expandPreviousVersions(soapAction)) {
            log.debug("Trying soap action: ", newVersion);
            if (!this.mappings.containsKey(newVersion)) continue;
            return this.mappings.get(newVersion);
        }
        return null;
    }

    public List<String> expandPreviousVersions(String soapAction) {
        ArrayList<String> previousVersions = new ArrayList<String>();
        BibusSoapAction bibusSoapAction = new BibusSoapAction(soapAction);
        if (this.isValidVersion(bibusSoapAction.getVersion())) {
            for (String version : this.getSupportedVersions()) {
                bibusSoapAction.setVersion(version);
                String newVersion = bibusSoapAction.toString();
                previousVersions.add(newVersion);
            }
        }
        return previousVersions;
    }

    private boolean isValidVersion(String version) {
        return this.getSupportedVersions().contains(version);
    }

    public void removeSoapAction(String soapAction) {
        log.debug("Removed mapping for: ", soapAction);
        this.mappings.remove(soapAction);
        for (String versioned : this.getAllVersions(soapAction)) {
            log.debug("Removed mapping for: ", versioned);
            this.mappings.remove(versioned);
        }
    }

    public Map<String, Handler> getMap() {
        HashMap<String, Handler> map = new HashMap<String, Handler>();
        for (Map.Entry<String, HandlerOrigin> entry : this.mappings.entrySet()) {
            map.put(entry.getKey(), entry.getValue().getHandler());
        }
        return map;
    }

    public void setPogoEngine(PogoEngine engine) {
        this.pogoEngine = engine;
    }

    private class HandlerOrigin {
        private Handler handler;
        private boolean wildcard;

        public HandlerOrigin(Handler handler, String soapAction) {
            this(handler, soapActionLookup.hasWildcard(soapAction));
        }

        public HandlerOrigin(Handler handler, boolean wildcard) {
            this.handler = handler;
            this.wildcard = wildcard;
        }

        public Handler getHandler() {
            return this.handler;
        }

        public boolean isWildcard() {
            return this.wildcard;
        }

        public String toString() {
            return this.handler != null ? this.handler.toString() : "null";
        }
    }
}

