/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.pdk.stax;

import com.cognos.pogo.pdk.common.HdrSession;
import com.cognos.pogo.pdk.stax.StaxCookieVars;
import com.cognos.pogo.pdk.stax.StaxEnvironmentVars;
import com.cognos.pogo.pdk.stax.StaxFormFieldVars;
import com.cognos.pogo.pdk.stax.StaxSetCookieVars;
import com.cognos.pogo.stax.utils.StaxBase;
import com.cognos.pogo.stax.utils.StaxElement;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class StaxHdrSession
extends StaxBase
implements HdrSession {
    private static final String HDR_SESSION = "hdrSession";
    private final StaxFormFieldVars formFieldVars;
    private final StaxCookieVars cookieVars;
    private final StaxSetCookieVars setCookieVars;
    private final StaxEnvironmentVars environmentVars;
    private StaxElement[] staxElements;

    public StaxHdrSession() {
        this.formFieldVars = new StaxFormFieldVars();
        this.cookieVars = new StaxCookieVars();
        this.setCookieVars = new StaxSetCookieVars();
        this.environmentVars = new StaxEnvironmentVars();
        this.setElements();
    }

    public StaxHdrSession(StaxHdrSession source) {
        this.formFieldVars = new StaxFormFieldVars(source.formFieldVars);
        this.cookieVars = new StaxCookieVars(source.cookieVars);
        this.setCookieVars = new StaxSetCookieVars(source.setCookieVars);
        this.environmentVars = new StaxEnvironmentVars(source.environmentVars);
        this.setElements();
    }

    private void setElements() {
        this.staxElements = new StaxElement[]{this.formFieldVars, this.cookieVars, this.setCookieVars, this.environmentVars};
    }

    @Override
    public StaxFormFieldVars getFormFieldVars() {
        return this.formFieldVars;
    }

    @Override
    public StaxCookieVars getCookieVars() {
        return this.cookieVars;
    }

    @Override
    public StaxSetCookieVars getSetCookieVars() {
        return this.setCookieVars;
    }

    @Override
    public StaxEnvironmentVars getEnvironmentVars() {
        return this.environmentVars;
    }

    @Override
    public boolean canParse(String entryName) {
        return HDR_SESSION.equals(entryName);
    }

    @Override
    protected void parseElement(XMLStreamReader xsr, String entryName) throws XMLStreamException {
        for (StaxElement element : this.staxElements) {
            if (!element.canParse(entryName)) continue;
            element.parse(xsr, entryName);
            break;
        }
    }

    @Override
    public void writeXML(XMLStreamWriter xsw, boolean writeNamespace) throws XMLStreamException {
        StaxHdrSession.writeStartBusElement(HDR_SESSION, HDR_SESSION, writeNamespace, xsw);
        this.writeStaxElements(xsw);
        xsw.writeEndElement();
        xsw.flush();
    }

    private void writeStaxElements(XMLStreamWriter xsw) throws XMLStreamException {
        for (StaxElement element : this.staxElements) {
            StaxHdrSession.writeChildXML(element, xsw);
        }
    }

    @Override
    public boolean isEmpty() {
        for (StaxElement element : this.staxElements) {
            if (element.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isPresent() {
        for (StaxElement element : this.staxElements) {
            if (!element.isPresent()) continue;
            return true;
        }
        return false;
    }
}

