/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.pdk.stax;

import com.cognos.pogo.pdk.common.ConversationContext;
import com.cognos.pogo.pdk.common.Providers;
import com.cognos.pogo.pdk.common.Tracking;
import com.cognos.pogo.pdk.stax.StaxConversationContext;
import com.cognos.pogo.pdk.stax.StaxProviders;
import com.cognos.pogo.stax.utils.StaxBase;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class StaxTracking
extends StaxBase
implements Tracking {
    private static final String TRACKING = "tracking";
    private static final String HOP_COUNT = "hopCount";
    private static final String REQUEST_CONTEXT = "requestContext";
    private static final String SESSION_CONTEXT = "sessionContext";
    private static final String STEP_CONTEXT = "stepContext";
    private StaxConversationContext conversationContext = new StaxConversationContext();
    private StaxProviders providers = new StaxProviders();
    private Long hopCount;
    private String requestContext;
    private String sessionContext;
    private String stepContext;

    public StaxTracking() {
    }

    public StaxTracking(XMLStreamReader xsr) throws XMLStreamException {
        this.parse(xsr, TRACKING);
    }

    public StaxTracking(StaxTracking source) {
        this.conversationContext = new StaxConversationContext(source.conversationContext);
        this.providers = new StaxProviders(source.providers);
        this.hopCount = source.hopCount;
        this.requestContext = source.requestContext;
        this.sessionContext = source.sessionContext;
        this.stepContext = source.stepContext;
    }

    @Override
    public boolean canParse(String entryName) {
        return TRACKING.equals(entryName);
    }

    @Override
    protected void parseElement(XMLStreamReader xsr, String localName) throws XMLStreamException {
        if (this.conversationContext.canParse(localName)) {
            this.conversationContext.parse(xsr, localName);
        } else if (this.providers.canParse(localName)) {
            this.providers.parse(xsr, localName);
        } else if (localName.equals(HOP_COUNT)) {
            this.hopCount = StaxTracking.parseLong(xsr);
        } else if (localName.equals(REQUEST_CONTEXT)) {
            this.requestContext = xsr.getElementText();
        } else if (localName.equals(SESSION_CONTEXT)) {
            this.sessionContext = xsr.getElementText();
        } else if (localName.equals(STEP_CONTEXT)) {
            this.stepContext = xsr.getElementText();
        }
    }

    @Override
    public void writeXML(XMLStreamWriter xsw, boolean writeNamespace) throws XMLStreamException {
        StaxTracking.writeStartBusElement(TRACKING, TRACKING, writeNamespace, xsw);
        StaxTracking.writeChildXML(this.conversationContext, xsw);
        StaxTracking.writeChildXML(this.providers, xsw);
        StaxTracking.writeLongElement(HOP_COUNT, this.hopCount, xsw);
        StaxTracking.writeStringElement(REQUEST_CONTEXT, this.requestContext, xsw);
        StaxTracking.writeStringElement(SESSION_CONTEXT, this.sessionContext, xsw);
        StaxTracking.writeStringElement(STEP_CONTEXT, this.stepContext, xsw);
        xsw.writeEndElement();
        xsw.flush();
    }

    @Override
    public ConversationContext getConversationContext() {
        return this.conversationContext;
    }

    @Override
    public Providers getProviders() {
        return this.providers;
    }

    @Override
    public long getHopCount() {
        return this.hopCount != null ? this.hopCount : 0L;
    }

    @Override
    public void setHopCount(long hopCount) {
        this.hopCount = hopCount;
    }

    @Override
    public long incrementHopCount() {
        this.hopCount = this.hopCount != null ? this.hopCount + 1L : 0L;
        return this.hopCount;
    }

    @Override
    public String getRequestContext() {
        return this.requestContext;
    }

    @Override
    public void setRequestContext(String requestContext) {
        this.requestContext = requestContext;
    }

    @Override
    public String getSessionContext() {
        return this.sessionContext;
    }

    @Override
    public void setSessionContext(String sessionContext) {
        this.sessionContext = sessionContext;
    }

    @Override
    public String getStepContext() {
        return this.stepContext;
    }

    @Override
    public void setStepContext(String stepContext) {
        this.stepContext = stepContext;
    }

    @Override
    public boolean isPresent() {
        return this.conversationContext.isPresent() || this.providers.isPresent() || this.hopCount != null || this.requestContext != null || this.sessionContext != null || this.stepContext != null;
    }
}

