/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.pdk.stax.cam;

import com.cognos.ccl4j.bibus.CAMCookie;
import com.cognos.pogo.pdk.common.Cam;
import com.cognos.pogo.pdk.stax.cam.StaxCAMPassport;
import com.cognos.pogo.pdk.stax.cam.StaxException;
import com.cognos.pogo.pdk.stax.cam.StaxRoles;
import com.cognos.pogo.pdk.stax.cam.StaxSettings;
import com.cognos.pogo.stax.stream.XMLStreamFactory;
import com.cognos.pogo.stax.utils.StaxBase;
import com.cognos.pogo.util.CAMUtils;
import com.cognos.pogo.util.PogoLogger;
import java.io.BufferedReader;
import java.io.StringReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class StaxCam
extends StaxBase
implements Cam {
    private static final PogoLogger log = PogoLogger.getLogger();
    private static final String CAM = "CAM";
    private static final String ACTION = "action";
    private static final String AUTHENTICITY_TOKEN = "authenticityToken";
    private static final String USER_SESSION_ID = "userSessionID";
    private static final String CAM_CREDENTIAL_PATH = "CAMCredentialPath";
    private static final String SECURITY_BLOB = "securityBlob";
    private String action;
    private String authenticityToken;
    private String camCredentialPath;
    private String securityBlob;
    private String userSessionId;
    private StaxCAMPassport camPassport = new StaxCAMPassport();
    private StaxRoles roles = StaxRoles.NULL;
    private StaxSettings settings = StaxSettings.NULL;
    private StaxException exception = StaxException.NULL;

    public StaxCam() {
    }

    public StaxCam(XMLStreamReader xsr) throws XMLStreamException {
        this.parse(xsr, CAM);
    }

    public StaxCam(StaxCam source) {
        this.action = source.action;
        this.authenticityToken = source.authenticityToken;
        this.camCredentialPath = source.camCredentialPath;
        this.securityBlob = source.securityBlob;
        this.userSessionId = source.userSessionId;
        this.camPassport = new StaxCAMPassport(source.camPassport);
        this.roles = source.roles == StaxRoles.NULL ? StaxRoles.NULL : new StaxRoles(source.roles);
        this.settings = source.settings == StaxSettings.NULL ? StaxSettings.NULL : new StaxSettings(source.settings);
        this.exception = source.exception == StaxException.NULL ? StaxException.NULL : new StaxException(source.exception);
    }

    @Override
    public boolean canParse(String entryName) {
        return CAM.equals(entryName);
    }

    @Override
    protected void parseElement(XMLStreamReader xsr, String localName) throws XMLStreamException {
        if (this.camPassport.canParse(localName)) {
            this.camPassport = new StaxCAMPassport(xsr);
        } else if (this.roles.canParse(localName)) {
            this.roles = new StaxRoles(xsr);
        } else if (this.settings.canParse(localName)) {
            this.settings = new StaxSettings(xsr);
        } else if (this.exception.canParse(localName)) {
            this.exception = new StaxException(xsr);
        } else if (localName.equals(ACTION)) {
            this.action = xsr.getElementText();
        } else if (localName.equals(AUTHENTICITY_TOKEN)) {
            this.authenticityToken = xsr.getElementText();
        } else if (localName.equals(CAM_CREDENTIAL_PATH)) {
            this.camCredentialPath = xsr.getElementText();
        } else if (localName.equals(SECURITY_BLOB)) {
            this.securityBlob = xsr.getElementText();
        } else if (localName.equals(USER_SESSION_ID)) {
            this.setUserSessionId(xsr.getElementText());
        }
    }

    @Override
    public boolean isPresent() {
        return this.action != null || this.authenticityToken != null || this.camCredentialPath != null || this.securityBlob != null || this.getUserSessionId() != null || this.camPassport.isPresent() || this.roles.isPresent() || this.settings.isPresent() || this.exception.isPresent();
    }

    @Override
    public void writeXML(XMLStreamWriter xsw, boolean writeNamespace) throws XMLStreamException {
        StaxBase.writeStartBusElement(CAM, CAM, writeNamespace, xsw);
        StaxBase.writeStringElement(ACTION, this.action, xsw);
        StaxBase.writeBase64BinaryElement(AUTHENTICITY_TOKEN, this.authenticityToken, xsw);
        StaxBase.writeStringElement(CAM_CREDENTIAL_PATH, this.camCredentialPath, xsw);
        StaxBase.writeBase64BinaryElement(SECURITY_BLOB, this.securityBlob, xsw);
        StaxBase.writeChildXML(this.camPassport, xsw);
        StaxBase.writeChildXML(this.exception, xsw);
        StaxBase.writeChildXML(this.roles, xsw);
        StaxBase.writeChildXML(this.settings, xsw);
        StaxBase.writeBase64BinaryElement(USER_SESSION_ID, this.getUserSessionId(), xsw);
        xsw.writeEndElement();
        xsw.flush();
    }

    @Override
    public String getAction() {
        return this.action;
    }

    @Override
    public void setAction(String action) {
        this.action = action;
    }

    @Override
    public String getAuthenticityToken() {
        return this.authenticityToken;
    }

    @Override
    public void setAuthenticityToken(String authenticityToken) {
        this.authenticityToken = authenticityToken;
    }

    public String getCamCredentialPath() {
        return this.camCredentialPath;
    }

    public void setCamCredentialPath(String camCredentialPath) {
        this.camCredentialPath = camCredentialPath;
    }

    public String getSecurityBlob() {
        return this.securityBlob;
    }

    public void setSecurityBlob(String securityBlob) {
        this.securityBlob = securityBlob;
    }

    @Override
    public void setUserSessionId(String userSessionId) {
        this.userSessionId = userSessionId;
    }

    @Override
    public String getUserSessionId() {
        return this.userSessionId;
    }

    @Override
    public StaxCAMPassport getCAMPassport() {
        return this.camPassport;
    }

    public StaxRoles getRoles() {
        return this.roles;
    }

    public StaxSettings getSettings() {
        return this.settings;
    }

    @Override
    public StaxException getException() {
        return this.exception;
    }

    @Override
    public void setCamCookie(String camCookieString) {
        CAMCookie camCookie = CAMUtils.createCookie(camCookieString);
        this.setCamCookie(camCookie);
    }

    @Override
    public void setCamCookie(CAMCookie camCookie) {
        log.debug("Copying CAM Cookie to BIBus header");
        try {
            String camCookieXml = camCookie.asXMLString();
            BufferedReader bufferedReader = new BufferedReader(new StringReader(camCookieXml), 4096);
            XMLStreamReader xmlStreamReader = XMLStreamFactory.createXMLStreamReader(bufferedReader);
            this.parse(xmlStreamReader, CAM);
        }
        catch (Exception e) {
            log.warn("Error copying CAM Cookie to BIBus header", e);
        }
    }

    @Override
    public boolean hasIncompleteCamElement() {
        return this.isPresent() && !this.settings.isPresent();
    }
}

