/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.pdk.xml;

import com.cognos.pogo.pdk.xml.SAXReaderPool;
import java.io.InputStream;
import java.io.Reader;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;

public abstract class PooledSAXReader {
    private static final Logger logger = Hierarchy.getDefaultHierarchy().getLoggerFor(PooledSAXReader.class.getName());
    protected SAXReader theReader = null;
    private SAXReaderPool thePool;

    PooledSAXReader(SAXReader reader, SAXReaderPool pool) {
        this.thePool = pool;
        this.theReader = reader;
        this.disallowDocType();
    }

    void disallowDocType() {
        try {
            this.theReader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        }
        catch (SAXException e) {
            logger.fatalError("Unable to set disallow-doctype-decl on SAXReader", (Throwable)e);
        }
    }

    public Document read(InputStream in) throws DocumentException {
        return this.theReader.read(in);
    }

    public Document read(Reader reader) throws DocumentException {
        return this.theReader.read(reader);
    }

    public void release() {
        this.thePool.release(this);
    }

    abstract boolean isValid();

    public SAXReader getRealReader() {
        return this.theReader;
    }

    protected void finalize() throws Throwable {
        if (this.theReader != null) {
            logger.error("finalizing a pooled reader that still has a SAXReader.  Someone probably forgot to release it.");
        }
    }

    public void reset() {
        if (this.theReader != null) {
            this.theReader.setXMLReader(null);
        }
    }
}

