/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.pdk.xml;

import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.pdk.xml.SAXReaderPool;
import com.cognos.pogo.util.ConfigurationParameter;
import com.cognos.pogo.util.PogoLogger;

public class SaxReaderPoolHandler
extends BasicHandler {
    private static final PogoLogger log = PogoLogger.getLogger();
    private static final String SAX_READER_POOL_RESET_ON_RELEASE = "SAXReaderPool.resetOnRelease";
    private ConfigurationParameter configurationParameter = new ConfigurationParameter("DISP.", "");

    public SaxReaderPoolHandler() {
        super(log.getNativeLogger());
        this.configurationParameter.disableDefaultParameter();
    }

    @Override
    public void configure(Configuration configuration) {
        this.configurationParameter.updateConfiguration(configuration);
        this.updateSaxPoolReader();
    }

    private void updateSaxPoolReader() {
        boolean resetOnRelease = this.getConfigurationParameterValue();
        SAXReaderPool.getInstance().setResetOnRelease(resetOnRelease);
    }

    private boolean getConfigurationParameterValue() {
        return Boolean.valueOf(this.configurationParameter.getValue(SAX_READER_POOL_RESET_ON_RELEASE));
    }

    @Override
    public void reconfigure(Configuration configuration) {
        this.configure(configuration);
    }

    @Override
    public void invokeImpl(MessageContext mc) throws PogoException {
    }
}

