/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.reportservice;

import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.util.PogoLogger;
import java.util.Iterator;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class AdvancedSettingsConfigurationChange {
    private static final PogoLogger log = PogoLogger.getLogger();
    private static final int MEGABYTES_TO_BYTES = 0x100000;
    private String advancedSettingsString = null;

    private Element getSettingsFromConfiguration(Configuration configuration) {
        try {
            Element settingsElement = configuration.getICCLConfiguration().getValueElement("advancedSettings", false);
            if (settingsElement != null) {
                return settingsElement;
            }
            log.debug("advancedSettings property not present in configuration.");
        }
        catch (CCLConfigurationException e) {
            log.debug("Exception caught while attempting to get the 'advancedSettings' property", e);
        }
        return null;
    }

    public boolean check(Configuration configuration) {
        Element settingsValueElement = this.getSettingsFromConfiguration(configuration);
        if (settingsValueElement == null) {
            return false;
        }
        String settings = settingsValueElement.getText();
        if (settings.equals(this.advancedSettingsString)) {
            log.debug("advancedSettings property did not change since last configuration");
            return false;
        }
        this.advancedSettingsString = settings;
        log.debug("advancedSettings property changed since last configuration");
        return true;
    }

    public int extractProcessUseLimit(String processUseLimitPropertyName) throws DocumentException {
        String processUseLimitStringValue = this.getAdvancedSettingsValue(processUseLimitPropertyName);
        if (processUseLimitStringValue == null) {
            log.debug(processUseLimitPropertyName, " not found in advancedSettings");
        } else {
            try {
                int requestCountLimit = Integer.parseInt(processUseLimitStringValue);
                if (requestCountLimit > 0) {
                    log.debug("Setting ", processUseLimitPropertyName, " to ", requestCountLimit);
                    return requestCountLimit;
                }
                log.debug(processUseLimitPropertyName, " < 1. Ignoring bad value");
            }
            catch (NumberFormatException nfe) {
                log.debug("ProcessUseLimit is not an integer... ignoring bad value", nfe);
            }
        }
        return -1;
    }

    public int extractPartialSaxLimit(String partialSaxLimitPropertyName) throws DocumentException {
        String partialSaxLimitStringValue = this.getAdvancedSettingsValue(partialSaxLimitPropertyName);
        if (partialSaxLimitStringValue == null) {
            log.debug(partialSaxLimitPropertyName, " not found in advancedSettings");
        } else {
            try {
                int partialSaxLimit = Integer.parseInt(partialSaxLimitStringValue);
                if (partialSaxLimit > 0) {
                    log.debug("Setting ", partialSaxLimitStringValue, " to ", partialSaxLimit);
                    return partialSaxLimit * 0x100000;
                }
                log.debug(partialSaxLimitStringValue, " < 1. Ignoring bad value");
            }
            catch (NumberFormatException nfe) {
                log.debug("ProcessUseLimit is not an integer... ignoring bad value", nfe);
            }
        }
        return -1;
    }

    public int extractDuplicatedRequestSuspensionInSeconds(String duplicatedRequestSuspensionInSecondsName) throws DocumentException {
        String duplicatedRequestSuspensionInSecondsValue = this.getAdvancedSettingsValue(duplicatedRequestSuspensionInSecondsName);
        if (duplicatedRequestSuspensionInSecondsValue == null) {
            log.debug(duplicatedRequestSuspensionInSecondsValue, " not found in advancedSettings");
        } else {
            try {
                int duplicatedRequestSuspensionInSeconds = Integer.parseInt(duplicatedRequestSuspensionInSecondsValue);
                if (duplicatedRequestSuspensionInSeconds > 0) {
                    log.debug("Setting ", duplicatedRequestSuspensionInSecondsValue, " to ", duplicatedRequestSuspensionInSeconds);
                    return duplicatedRequestSuspensionInSeconds;
                }
                log.debug(duplicatedRequestSuspensionInSeconds, " < 1. Ignoring bad value");
            }
            catch (NumberFormatException nfe) {
                log.debug("duplicatedRequestSuspensionInSeconds is not an integer... ignoring bad value", nfe);
            }
        }
        return -1;
    }

    public String getAdvancedSettingsValue(String attributeName) {
        if (this.advancedSettingsString == null) {
            return null;
        }
        String advancedSettingsValue = null;
        try {
            Element el = DocumentHelper.parseText((String)this.advancedSettingsString).getRootElement();
            Iterator elit = el.elementIterator();
            while (elit.hasNext()) {
                Element element = (Element)elit.next();
                if (!element.attribute("name").getValue().equalsIgnoreCase(attributeName)) continue;
                advancedSettingsValue = element.getTextTrim();
                break;
            }
        }
        catch (DocumentException e) {
            log.debug("Parse error on advanced settings: ", this.advancedSettingsString);
        }
        return advancedSettingsValue;
    }
}

