/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.reportservice;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.Fault;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.util.base64;
import java.io.ByteArrayInputStream;
import java.io.SequenceInputStream;
import java.util.ArrayList;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;
import org.apache.soap.util.mime.MimeUtils;
import org.dom4j.Element;

public class MapPreviewResponseHandler
extends BasicHandler {
    private static final Logger logger = Hierarchy.getDefaultHierarchy().getLoggerFor(MapPreviewResponseHandler.class.getName());
    private static final byte[] HEADER_BYTES = "Content-Type: image/png\r\n\r\n".getBytes();

    public MapPreviewResponseHandler() {
        super(logger);
    }

    @Override
    public void invokeImpl(MessageContext mc) throws PogoException {
        Element responseNode;
        BIBusEnvelope responseEnvelope = (BIBusEnvelope)mc.getProperty("response.envelope");
        Element resultNode = null;
        if (responseEnvelope != null && (responseNode = responseEnvelope.getBody().element("getMapPreviewResponse")) != null) {
            resultNode = responseNode.element("result");
        }
        if (resultNode == null) {
            logger.error("Response from reportService does not contain a getMapPreviewResponse element.");
            mc.setFault(new Fault("mapPreview.badResponseFromRS"));
            return;
        }
        String base64String = resultNode.getText();
        if (base64String.length() == 0) {
            logger.error("Map preview image data in the response has a length of 0");
            mc.setFault(new Fault("mapPreview.emptyImageData"));
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Preparing to return map preview image: " + base64String);
        }
        mc.setResponseName("response");
        mc.setProperty("response.envelope", responseEnvelope);
        mc.setProperty("response.status_code", "200");
        byte[] mapPreview = base64.decode(0, base64String);
        base64String = null;
        if (logger.isDebugEnabled()) {
            logger.debug("Preparing to Send back a map preview image (PNG) of size " + mapPreview.length + " bytes");
        }
        ByteArrayInputStream headerStream = new ByteArrayInputStream(HEADER_BYTES);
        ByteArrayInputStream dataStream = new ByteArrayInputStream(mapPreview);
        SequenceInputStream sequenceStream = new SequenceInputStream(headerStream, dataStream);
        ArrayList<SequenceInputStream> attachmentList = new ArrayList<SequenceInputStream>(1);
        attachmentList.add(sequenceStream);
        mc.setProperty("response.attachments", attachmentList.iterator());
        mc.setProperty("response.boundary", MimeUtils.getUniqueValue());
    }
}

