/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.reportservice;

import com.cognos.pogo.bibus.RequestAffinity;
import com.cognos.pogo.logging.LoggingContext;
import com.cognos.pogo.logging.LoggingRealm;
import com.cognos.pogo.logging.LoggingRealmFactory;
import com.cognos.pogo.monitoring.QueueableRequestReporter;
import com.cognos.pogo.reportservice.ProcessFacade;
import com.cognos.pogo.reportservice.ProcessManager;
import com.cognos.pogo.reportservice.ProcessReaper;
import com.cognos.pogo.reportservice.ReportServerConnection;
import com.cognos.pogo.reportservice.ReportServerProcess;
import com.cognos.pogo.util.Check;
import com.cognos.pogo.util.PogoIPFLog;
import com.cognos.pogo.util.PogoLogger;
import com.cognos.pogo.util.threads.SafeTimerTask;
import java.io.IOException;
import java.rmi.NoSuchObjectException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Timer;
import java.util.TimerTask;

public class ProcessList {
    private static PogoLogger log = PogoLogger.getLogger();
    private static PogoLogger timerTaskLog = PogoLogger.getLoggerFor(IdleProcessChecker.class);
    static final LoggingRealm loggingRealm = LoggingRealmFactory.getInstance("DISP");
    private List<ProcessFacade> processList = Collections.synchronizedList(new ArrayList());
    private final ProcessReaper processReaper;
    private QueueableRequestReporter reporter;
    private boolean isSuspended;
    private int minProcessCount = 1;
    private int maxProcessCount = 2;
    private boolean shutdown;
    private final ProcessManager processManager;
    private Timer idleCheckTimer;
    private final String serviceName;
    private Timer processCleanerTimer;

    public ProcessList(ProcessReaper processReaper, ProcessManager processManager, String serviceName) {
        this.processReaper = processReaper;
        this.processManager = processManager;
        this.serviceName = serviceName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReportServerConnection getAffineConnection(int processID, RequestAffinity requestAffinity) throws NoSuchObjectException {
        log.debug("getAffineConnection() for processID ", processID, ", requestAffinity: ", requestAffinity);
        List<ProcessFacade> list = this.processList;
        synchronized (list) {
            ListIterator<ProcessFacade> listIterator = this.processList.listIterator();
            while (!this.isShutdown() && !this.isSuspended && listIterator.hasNext()) {
                ProcessFacade aProcess = listIterator.next();
                log.debug("Checking ", aProcess);
                if (!aProcess.startedExternally() && aProcess.getProcessID() != processID) continue;
                try {
                    if (requestAffinity == RequestAffinity.CONTROL) {
                        return aProcess.getCancelConnection();
                    }
                    if (requestAffinity == RequestAffinity.SESSION) {
                        return aProcess.getNonAffineConnection();
                    }
                    if (requestAffinity == RequestAffinity.GET) {
                        return aProcess.getGetConnection();
                    }
                    return aProcess.getAffineConnection(requestAffinity);
                }
                catch (IllegalStateException ex) {
                    log.info("Process ", aProcess.getProcessID(), " is not responding (probably crashed). Destroying it.");
                    listIterator.remove();
                    this.processReaper.addZombieProcess(aProcess, 10);
                    PogoIPFLog.getInstance().logFailureStatus("ProcessManager.notResponding", new Object[]{aProcess.getProcessName()});
                }
            }
        }
        this.incrementNumberOfUnexpectedAbortedProcesses();
        throw new NoSuchObjectException("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resizeConnectionPools(int maxAffineConnections, int maxNonAffineConnections) {
        List<ProcessFacade> list = this.processList;
        synchronized (list) {
            ListIterator<ProcessFacade> listIterator = this.processList.listIterator();
            while (!this.isShutdown() && !this.isSuspended && listIterator.hasNext()) {
                ProcessFacade aProcess = listIterator.next();
                log.debug("Resizing the connection pools for process ", aProcess);
                try {
                    aProcess.resizeNonAffinePool(maxNonAffineConnections);
                    aProcess.resizeAffinePool(maxAffineConnections);
                    aProcess.resizeCancelPool(maxNonAffineConnections + maxAffineConnections);
                }
                catch (Exception ex) {
                    log.info("Process ", aProcess.getProcessID(), " is not responding (probably crashed). Destroying it.");
                    this.incrementNumberOfUnexpectedAbortedProcesses();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReportServerConnection getNonAffineConnection() {
        List<ProcessFacade> list = this.processList;
        synchronized (list) {
            Collections.sort(this.processList);
            ListIterator<ProcessFacade> listIterator = this.processList.listIterator();
            while (!this.isShutdown() && !this.isSuspended && listIterator.hasNext()) {
                ProcessFacade aProcess = listIterator.next();
                log.debug("Attempting to get a non-affine connection from ", aProcess);
                try {
                    ReportServerConnection aConnection = aProcess.getNonAffineConnection();
                    if (aConnection != null) {
                        if (this.processList.indexOf(aProcess) == 0 && aProcess.pastWatermark()) {
                            if (this.canStartAnotherProcess()) {
                                log.debug("Hinting to start another process because the last one hit the watermark");
                                this.processManager.createAnotherProcess();
                            } else {
                                log.debug("NOT hinting to start another process");
                            }
                        }
                        return aConnection;
                    }
                    log.debug("No free non-affine connection is available from ", aProcess);
                }
                catch (IllegalStateException ex) {
                    log.info("Process ", aProcess.getProcessID(), " is not responding (probably crashed). Destroying it.");
                    listIterator.remove();
                    this.processReaper.addZombieProcess(aProcess, 10);
                    PogoIPFLog.getInstance().logFailureStatus("ProcessManager.notResponding", new Object[]{aProcess.getProcessName()});
                    this.incrementNumberOfUnexpectedAbortedProcesses();
                }
            }
        }
        return null;
    }

    private boolean canStartAnotherProcess() {
        int activeProcessCount = this.activeProcessCount();
        log.debug("Current process count (active/max): ", activeProcessCount, "/", this.maxProcessCount);
        return activeProcessCount < this.maxProcessCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int activeProcessCount() {
        int activeCount = 0;
        List<ProcessFacade> list = this.processList;
        synchronized (list) {
            for (ProcessFacade aProcess : this.processList) {
                if (aProcess.isExpired()) continue;
                ++activeCount;
            }
        }
        return activeCount;
    }

    public void addProcess(ProcessFacade aProcess) {
        this.processList.add(aProcess);
    }

    public ProcessFacade get(int index) {
        return this.processList.get(index);
    }

    public void cleanup() {
        this.cleanup(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup(int terminateTimeout) {
        List<ProcessFacade> list = this.processList;
        synchronized (list) {
            if (0 == this.processList.size()) {
                log.debug("no processes to destroy.");
                return;
            }
            this.processReaper.addZombieProcesses(this.processList, terminateTimeout);
            this.processList.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expireExcessProcesses(int newMaxProcess) {
        int activeProcesses = 0;
        List<ProcessFacade> list = this.processList;
        synchronized (list) {
            for (ProcessFacade aProcess : this.processList) {
                log.debug("Examining ", aProcess);
                if (aProcess.isExpired()) {
                    log.debug(aProcess, " is already expired");
                    continue;
                }
                if (activeProcesses < newMaxProcess) {
                    ++activeProcesses;
                    log.debug("Counting ", aProcess, " as an active process");
                    continue;
                }
                log.debug("Expiring ", aProcess);
                aProcess.setExpired(true);
            }
        }
        Check.assertTrue(activeProcesses <= newMaxProcess, "activeProcesses > maxProcess!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expireAllProcesses() {
        List<ProcessFacade> list = this.processList;
        synchronized (list) {
            for (ProcessFacade aProcess : this.processList) {
                log.info("Expiring ", aProcess, " because configuration has changed");
                aProcess.setExpired(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconfigureProcess(int processID) {
        List<ProcessFacade> list = this.processList;
        synchronized (list) {
            for (ProcessFacade aProcess : this.processList) {
                if (aProcess.getProcessID() != processID) continue;
                try {
                    aProcess.reconfigureProcess();
                }
                catch (IOException iOException) {}
                break;
            }
        }
    }

    private void incrementNumberOfUnexpectedAbortedProcesses() {
        if (this.reporter != null) {
            this.reporter.incrementNumberOfUnexpectedAbortedProcesses();
        }
    }

    public int size() {
        return this.processList.size();
    }

    public int indexOf(ProcessFacade process) {
        return this.processList.indexOf(process);
    }

    public void setRequestReporter(QueueableRequestReporter reporter) {
        this.reporter = reporter;
    }

    public void suspend() {
        this.isSuspended = true;
    }

    public void resume() {
        this.isSuspended = false;
    }

    public int getMaxProcessCount() {
        return this.maxProcessCount;
    }

    public void setMaxProcessCount(int maxProcessCount) {
        this.maxProcessCount = maxProcessCount;
    }

    public int getMinProcessCount() {
        return this.minProcessCount;
    }

    public void setMinProcessCount(int minProcessCount) {
        this.minProcessCount = minProcessCount;
    }

    private boolean isShutdown() {
        return this.shutdown;
    }

    public void setShutdown(boolean shutdown) {
        this.shutdown = shutdown;
        if (shutdown) {
            this.getIdleCheckTimer().cancel();
        }
    }

    public void createAnotherProcess() {
        this.processManager.createAnotherProcess();
    }

    public void scheduleIdlePoolChecking(long idlePoolCheckIntervalms) {
        this.getIdleCheckTimer().schedule((TimerTask)new IdlePoolChecker(), idlePoolCheckIntervalms, idlePoolCheckIntervalms);
    }

    public void scheduleIdleProcessChecking(int idleProcessMaxIntervals, long idleProcessCheckIntervalms, long idleMaxWaitInSecs) {
        this.getIdleCheckTimer().schedule((TimerTask)new IdleProcessChecker(idleProcessMaxIntervals, idleMaxWaitInSecs), idleProcessCheckIntervalms, idleProcessCheckIntervalms);
    }

    private synchronized Timer getIdleCheckTimer() {
        if (this.idleCheckTimer == null) {
            this.idleCheckTimer = new Timer(true);
            this.idleCheckTimer.schedule((TimerTask)new IdleCheckTimerPrepareTask(this.serviceName), 0L);
        }
        return this.idleCheckTimer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRequestCount() {
        int total = 0;
        List<ProcessFacade> list = this.processList;
        synchronized (list) {
            for (ProcessFacade aProcess : this.processList) {
                total += aProcess.getRequestCapacity();
            }
        }
        return total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void idleAllProcesses() {
        List<ProcessFacade> list = this.processList;
        synchronized (list) {
            for (ProcessFacade aProcess : this.processList) {
                aProcess.setForcedIdle(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ProcessFacade> getProcesListView() {
        List<ProcessFacade> list = this.processList;
        synchronized (list) {
            return new ArrayList<ProcessFacade>(this.processList);
        }
    }

    public void setIdleCheckTimerForTesting(Timer idleCheckTimer) {
        this.idleCheckTimer = idleCheckTimer;
    }

    public static void setIdleCheckLoggerForTesting(PogoLogger logger) {
        timerTaskLog = logger;
    }

    protected Timer createProcessCleanerTimer() {
        if (this.processCleanerTimer == null) {
            this.processCleanerTimer = new Timer(true);
        }
        return this.processCleanerTimer;
    }

    protected void setProcessCleanerTimerForTesting(Timer timer) {
        this.processCleanerTimer = timer;
    }

    public void startProcessCleaning(int processCleanerInterval) {
        if (processCleanerInterval == 0) {
            return;
        }
        SafeTimerTask processCleaner = new SafeTimerTask(){

            @Override
            protected void safeRun() {
                ProcessList.this.ping();
            }
        };
        Timer timer = this.createProcessCleanerTimer();
        timer.scheduleAtFixedRate((TimerTask)processCleaner, processCleanerInterval, (long)processCleanerInterval);
    }

    public void ping() {
        List<ProcessFacade> deadProcessList = this.findDeadProcesses();
        this.removeDeadProcesses(deadProcessList);
    }

    private List<ProcessFacade> findDeadProcesses() {
        ArrayList<ProcessFacade> deadProcessList = new ArrayList<ProcessFacade>();
        for (ProcessFacade aProcess : this.getProcesListView()) {
            if (aProcess.isAlive()) continue;
            deadProcessList.add(aProcess);
            log.info("Process ", aProcess, " for service ", this.serviceName, " is not running, and will be removed. Queue size: ", this.getQueueSize());
            this.incrementNumberOfHungProcesses();
        }
        return deadProcessList;
    }

    private void incrementNumberOfHungProcesses() {
        if (this.reporter != null) {
            this.reporter.incrementNumberOfHungProcesses();
        }
    }

    private void removeDeadProcesses(List<ProcessFacade> deadProcessList) {
        this.processList.removeAll(deadProcessList);
    }

    protected int getQueueSize() {
        return this.processManager.getQueueSize();
    }

    public boolean isFull() {
        return !this.canStartAnotherProcess();
    }

    class IdleCheckTimerPrepareTask
    extends SafeTimerTask {
        String serviceName;

        IdleCheckTimerPrepareTask(String serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        public void safeRun() {
            Thread.currentThread().setName(this.serviceName + "-IdleCheckTimerThread");
            LoggingContext loggingContext = loggingRealm.getLoggingContext();
            loggingContext.setSessionID("idleCheckTimer");
            loggingContext.setStepID("0");
            loggingContext.setRequestID("na");
            loggingContext.setSubRequestID("");
        }
    }

    class IdlePoolChecker
    extends SafeTimerTask {
        IdlePoolChecker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void safeRun() {
            try {
                log.debug("IdlePoolChecker: checking for idle connections");
                List list = ProcessList.this.processList;
                synchronized (list) {
                    for (ProcessFacade aProcess : ProcessList.this.processList) {
                        aProcess.checkPoolsForIdleConnetions();
                        log.debug("Examining ", aProcess);
                    }
                }
            }
            catch (RuntimeException e) {
                timerTaskLog.error("Swallowed otherwise unhandled exception in timer task run()", e);
            }
        }
    }

    class IdleProcessChecker
    extends SafeTimerTask {
        private int maxIdleIntervals;
        private long maxIdleWaitInSecs;
        private List<ProcessFacade> removeList = new ArrayList<ProcessFacade>();

        IdleProcessChecker(int maxIdleIntervals, long maxIdleWaitInSecs) {
            this.maxIdleIntervals = maxIdleIntervals;
            this.maxIdleWaitInSecs = maxIdleWaitInSecs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void safeRun() {
            try {
                log.debug("IdleProcessChecker: checking for idle processes");
                List list = ProcessList.this.processList;
                synchronized (list) {
                    int processCount = 0;
                    ListIterator listIterator = ProcessList.this.processList.listIterator();
                    while (listIterator.hasNext()) {
                        ProcessFacade aProcess = (ProcessFacade)listIterator.next();
                        log.debug("Examining ", aProcess);
                        if (aProcess.startedExternally()) {
                            ++processCount;
                            continue;
                        }
                        if (aProcess.isExpired()) {
                            log.debug(aProcess, " is expired.");
                        }
                        this.auditForStuckProcess(aProcess);
                        if (!aProcess.isExpired()) {
                            ++processCount;
                        }
                        if (processCount <= ProcessList.this.minProcessCount && !aProcess.isExpired()) {
                            log.debug("skipping idle check because active process count is below the minimum.", " Active process count: ", processCount);
                            continue;
                        }
                        if (!aProcess.isIdle()) {
                            log.debug("process is not idle.");
                            continue;
                        }
                        log.debug("Process ", aProcess, " was already marked as idle.");
                        if (aProcess.isMarkedAsIdle() < this.maxIdleIntervals) {
                            int idleTicks = aProcess.setMarkedAsIdle(true);
                            log.debug("idle tick count bumped to: ", idleTicks);
                            continue;
                        }
                        if (log.isInfoEnabled()) {
                            StringBuffer strBuf = new StringBuffer("Destroying idle ");
                            if (aProcess.isExpired()) {
                                strBuf.append("and expired ");
                            }
                            strBuf.append("process: ");
                            strBuf.append(aProcess);
                            log.info(strBuf);
                        }
                        if (!aProcess.isExpired()) {
                            --processCount;
                        }
                        listIterator.remove();
                        this.removeList.add(aProcess);
                    }
                    this.reportProcessCount(processCount);
                }
                if (this.removeList.size() > 0) {
                    timerTaskLog.debug("send idle processes to the cemetery.");
                    ReportServerProcess.logReportServerStatus(this.getClass().getName(), false, "BIBus.removeIdleProcess", new Object[]{String.valueOf(this.removeList.size())});
                    ProcessList.this.processReaper.addZombieProcesses(this.removeList, -1);
                    this.removeList.clear();
                }
            }
            catch (RuntimeException e) {
                timerTaskLog.error("Swallowed otherwise unhandled exception in timer task run()", e);
            }
        }

        private void reportProcessCount(int processCount) {
            if (ProcessList.this.reporter != null) {
                ProcessList.this.reporter.reportProcessCount(processCount);
            }
        }

        private void auditForStuckProcess(ProcessFacade aProcess) {
            long expiredFor;
            if (aProcess.isExpired() && !aProcess.isIdle() && (expiredFor = System.currentTimeMillis() - aProcess.getExpiryTime()) > this.maxIdleWaitInSecs * 1000L) {
                log.debug(aProcess, " is expired but hasn't gone idle after ", expiredFor, " seconds. Forcing it to idle so that it can be destroyed.");
                aProcess.setForcedIdle(true);
            }
        }
    }
}

