/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.reportservice;

import com.cognos.pogo.pdk.stax.StaxBodyHandler;
import com.cognos.pogo.stax.utils.recorder.StaxRecorder;
import com.cognos.pogo.util.PogoLogger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class ReportServerBodyHandler
implements StaxBodyHandler {
    private static final PogoLogger log = PogoLogger.getLogger();
    private StaxRecorder recorder = null;
    private boolean shouldRecord = true;

    public ReportServerBodyHandler(boolean inShouldRecord) {
        this.shouldRecord = inShouldRecord;
    }

    public ReportServerBodyHandler() {
        this.shouldRecord = true;
    }

    @Override
    public boolean canParse(String entryName) {
        return true;
    }

    @Override
    public void parse(XMLStreamReader xsr, String entryName) throws XMLStreamException {
        this.recorder = new StaxRecorder(xsr);
        if (this.shouldRecord) {
            this.recorder.recordTo("Body");
        }
    }

    @Override
    public void writeXML(XMLStreamWriter xsw) throws XMLStreamException {
        this.writeXML(xsw, true);
    }

    @Override
    public void writeXML(XMLStreamWriter xsw, boolean writeNamespace) throws XMLStreamException {
        if (this.shouldRecord) {
            this.recorder.replay(xsw);
        } else {
            this.recorder.transferTo(xsw, "body", "body");
        }
        this.recorder.close();
    }

    @Override
    public String getMethodName() {
        String methodName = null;
        if (this.recorder != null) {
            methodName = this.recorder.getRootElementName();
        }
        return methodName;
    }

    @Override
    public String getReportPath() {
        String reportPath = "";
        String[] elementNames = new String[]{"searchPath", "search", "objectPath", "obj", "value"};
        for (int i = 0; i < elementNames.length; ++i) {
            String elementName = elementNames[i];
            String elementText = this.recorder.getElementText(elementName);
            if (elementText == null || elementText.length() == 0) continue;
            reportPath = elementText;
            break;
        }
        return reportPath;
    }

    @Override
    public String asXML() {
        String asXML = null;
        try {
            asXML = this.recorder.asXML();
        }
        catch (XMLStreamException e) {
            log.error(this.getClass().getName() + " asXML operation failed!", e);
        }
        return asXML;
    }

    @Override
    public boolean isEmpty() {
        boolean empty = true;
        if (this.recorder != null) {
            empty = this.recorder.isEmpty();
        }
        return empty;
    }

    @Override
    public boolean isPresent() {
        return true;
    }
}

