/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.reportservice;

import com.cognos.pogo.http.ConnectionOwner;
import com.cognos.pogo.http.IRawHttpMethodFactory;
import com.cognos.pogo.http.ServerConnection;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.reportservice.ProcessFacade;
import com.cognos.pogo.reportservice.RSComponentFactory;
import com.cognos.pogo.reportservice.ReportServerRequest;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class ReportServerConnection
extends ServerConnection {
    private static final Logger logger = Hierarchy.getDefaultHierarchy().getLoggerFor(ReportServerConnection.class.getName());
    private int processID;
    private boolean nonAffine = true;
    private boolean cancelOnly;
    private ProcessFacade ownerProcess;
    private ReportServerRequest ownerRequest;
    private boolean affineOnly;

    protected ReportServerConnection(RSComponentFactory factory, ConnectionOwner newOwner, int newPoolLocation, boolean affineRequestsOnly) {
        super(factory, newOwner, newPoolLocation);
        this.affineOnly = affineRequestsOnly;
    }

    protected ReportServerConnection(IRawHttpMethodFactory factory, ConnectionOwner newOwner, int newPoolLocation, boolean affineRequestsOnly) {
        super(factory, newOwner, newPoolLocation);
        this.affineOnly = affineRequestsOnly;
    }

    public ReportServerConnection(RSComponentFactory factory, ConnectionOwner newOwner, int newPoolLocation, boolean affineRequestsOnly, String tempDir) {
        super(factory, newOwner, newPoolLocation, tempDir);
        this.affineOnly = affineRequestsOnly;
    }

    public boolean isAffineOnly() {
        return this.affineOnly;
    }

    public boolean isNonAffine() {
        return this.nonAffine;
    }

    public void setNonAffine(boolean b) {
        this.nonAffine = b;
    }

    int getProcessID() {
        return this.processID;
    }

    public void setProcessID(int id) {
        this.processID = id;
    }

    @Override
    protected void releaseImpl() {
        boolean debugLog = logger.isDebugEnabled();
        if (this.isReleased()) {
            if (debugLog) {
                logger.debug("releaseImpl() called for already-released connection " + this);
            }
            return;
        }
        if (debugLog) {
            logger.debug("releaseImpl() called for connection " + this + (this.isNonAffine() ? "[non-affine]" : "[affine]"));
        }
        if (this.isDisposed()) {
            if (debugLog) {
                logger.debug(this + " is disposed.  Will not try to hand off this connection");
            }
            super.releaseImpl();
            return;
        }
        this.recycle();
        boolean handedOff = this.ownerProcess.handoffConnection(this);
        if (!handedOff) {
            if (debugLog) {
                logger.debug("No waiting requests so connection " + this + " will be released.");
            }
            this.ownerRequest = null;
            super.releaseImpl();
        } else if (debugLog) {
            logger.debug("connection " + this + " was handed-off to another request.");
        }
    }

    public boolean isCancelOnly() {
        return this.cancelOnly;
    }

    public void setCancelOnly(boolean cancelOnly) {
        this.cancelOnly = cancelOnly;
    }

    public String toString() {
        return "ReportServerConnection from Process " + this.processID + ", pool location " + this.getPoolLocation();
    }

    public void setOwnerProcess(ProcessFacade facade) {
        this.ownerProcess = facade;
    }

    ReportServerRequest getOwnerRequest() {
        return this.ownerRequest;
    }

    void setOwnerRequest(ReportServerRequest ownerRequest) {
        this.ownerRequest = ownerRequest;
    }

    @Override
    protected synchronized void dispose() {
        this.ownerRequest = null;
        super.dispose();
    }

    @Override
    protected void endSession() {
        super.endSession();
    }

    @Override
    public void clean(MessageContext mc) {
        this.ownerRequest = null;
        super.clean(mc);
    }

    public String getProcessName() {
        return this.ownerProcess != null ? this.ownerProcess.getProcessName() : null;
    }
}

