/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.reportservice;

import com.cognos.pogo.http.ConnectionCreator;
import com.cognos.pogo.http.ConnectionOwner;
import com.cognos.pogo.http.ServerConnection;
import com.cognos.pogo.reportservice.ProcessFacade;
import com.cognos.pogo.reportservice.RSComponentFactory;
import com.cognos.pogo.reportservice.ReportServerConnection;

public class ReportServerConnectionCreator
implements ConnectionCreator {
    private RSComponentFactory componentFactory;
    private boolean affineOnly;
    private int processID;
    private ProcessFacade facade;
    private boolean getMethod;

    public ReportServerConnectionCreator(RSComponentFactory componentFactory, boolean affineOnly, int processID, ProcessFacade facade) {
        this(componentFactory, affineOnly, processID, facade, false);
    }

    public ReportServerConnectionCreator(RSComponentFactory componentFactory, boolean affineOnly, int processID, ProcessFacade facade, boolean getMethod) {
        this.componentFactory = componentFactory;
        this.affineOnly = affineOnly;
        this.processID = processID;
        this.facade = facade;
        this.getMethod = getMethod;
    }

    @Override
    public ServerConnection newConnection(ConnectionOwner owner, int position) {
        ReportServerConnection aConnection = this.getMethod ? this.componentFactory.newReportServerGETConnection(owner, position, this.affineOnly) : this.componentFactory.newReportServerConnection(owner, position, this.affineOnly);
        aConnection.setProcessID(this.processID);
        aConnection.setOwnerProcess(this.facade);
        if (this.facade.getLightThreads() > 0) {
            byte[] prologue = new byte[]{this.getMethod ? (byte)1 : 0};
            aConnection.setConnectionPrologue(prologue);
        }
        return aConnection;
    }

    protected boolean getAffineOnly() {
        return this.affineOnly;
    }

    protected int getProcessID() {
        return this.processID;
    }

    protected ProcessFacade getProcessFacade() {
        return this.facade;
    }
}

