/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.reportservice;

import com.cognos.pogo.http.ConnectionPool;
import com.cognos.pogo.http.ServerConnection;
import com.cognos.pogo.reportservice.ProcessFacade;
import com.cognos.pogo.reportservice.ProcessList;
import com.cognos.pogo.reportservice.RSComponentFactory;
import com.cognos.pogo.reportservice.ReportServerConnection;
import com.cognos.pogo.reportservice.ReportServerRequest;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Set;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class ReportServerConnectionPool
extends ConnectionPool {
    private static final Logger category = Hierarchy.getDefaultHierarchy().getLoggerFor(ReportServerConnectionPool.class.getName());
    private int processID;
    private ProcessFacade processFacade;
    private boolean affineOnly;

    public ReportServerConnectionPool(RSComponentFactory componentFactory, String serverHost, int serverPort, boolean ssl, int maximumPoolSize, boolean affineRequestsOnly) {
        super(serverHost, serverPort, ssl, maximumPoolSize);
        this.affineOnly = affineRequestsOnly;
    }

    public ReportServerConnectionPool(String serverHost, int serverPort, boolean ssl, int maximumPoolSize, boolean affineRequestsOnly, String tempDir) {
        super(serverHost, serverPort, ssl, maximumPoolSize, tempDir);
        this.affineOnly = affineRequestsOnly;
    }

    protected boolean isAffineOnly() {
        return this.affineOnly;
    }

    protected int getProcessID() {
        return this.processID;
    }

    public void setReportServerProcessID(int id) {
        this.processID = id;
    }

    protected ProcessFacade getProcessFacade() {
        return this.processFacade;
    }

    public void setProcessFacade(ProcessFacade owner) {
        this.processFacade = owner;
    }

    void dumpUsage(PrintWriter pw) throws IOException {
        Set<ServerConnection> resultSet = this.getConnectionsView();
        for (ReportServerConnection reportServerConnection : resultSet) {
            if (reportServerConnection == null) continue;
            pw.print("Connection ");
            pw.print(reportServerConnection.getPoolLocation());
            pw.print(": ");
            ReportServerRequest aRequest = reportServerConnection.getOwnerRequest();
            this.dumpRequest(pw, aRequest);
            pw.print(" (");
            pw.print(System.currentTimeMillis() - reportServerConnection.getSendStartTime());
            pw.print(" ms)");
            pw.println();
        }
    }

    void dumpRequest(PrintWriter pw, ReportServerRequest aRequest) {
        if (aRequest != null) {
            pw.print(aRequest.toString());
        } else {
            pw.print("No request owner");
        }
    }

    void terminateDelinquents(ProcessList processList, int timeLimitSeconds) {
        Set<ServerConnection> resultSet = this.getConnectionsView();
        for (ReportServerConnection reportServerConnection : resultSet) {
            if (reportServerConnection == null) continue;
            ReportServerRequest aRequest = reportServerConnection.getOwnerRequest();
            long startTime = reportServerConnection.getSendStartTime();
            if (System.currentTimeMillis() - startTime <= (long)(timeLimitSeconds * 1000)) continue;
            if (category.isErrorEnabled()) {
                category.error("Terminating delinquent request: ");
                category.error(aRequest.toString());
            }
            aRequest.cancelRequest(processList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void terminateIdle() {
        Set<ServerConnection> resultSet = this.getConnectionsView();
        for (ReportServerConnection reportServerConnection : resultSet) {
            if (reportServerConnection == null) continue;
            if (category.isDebugEnabled()) {
                try {
                    if (!reportServerConnection.isConnectionInUse() && reportServerConnection.shouldCloseConnection()) {
                        category.debug("Ending connection for process " + reportServerConnection.getProcessID());
                    } else {
                        category.debug("Connection for process " + reportServerConnection.getProcessID() + " still in use or not idle");
                    }
                }
                catch (Exception e) {
                    category.debug("terminateIdle: Swallowing exception ", (Throwable)e);
                }
            }
            ReportServerConnection reportServerConnection2 = reportServerConnection;
            synchronized (reportServerConnection2) {
                try {
                    if (!reportServerConnection.isConnectionInUse() && reportServerConnection.shouldCloseConnection()) {
                        reportServerConnection.endSession();
                        reportServerConnection.setBadInputStream();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

