/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.reportservice;

import com.cognos.pogo.bibus.CommandExecutionException;
import com.cognos.pogo.http.ServerConnection;
import com.cognos.pogo.monitoring.jmx.report.InteractiveReportExecutingRequests;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.reportservice.NoConnectionException;
import com.cognos.pogo.reportservice.ProcessShutdownException;
import com.cognos.pogo.reportservice.RSComponentFactory;
import com.cognos.pogo.reportservice.ReportServerQueue;
import com.cognos.pogo.reportservice.ReportServerRequest;
import com.cognos.pogo.reportservice.ReportServiceGetCommand;
import com.cognos.pogo.reportservice.ServiceStoppedException;
import com.cognos.pogo.util.PogoLogger;
import java.io.InputStream;
import java.rmi.NoSuchObjectException;
import javax.mail.internet.InternetHeaders;

public class ReportServerGetRequest
extends ReportServerRequest {
    private static final PogoLogger log = PogoLogger.getLogger();
    private String queryString;

    public ReportServerGetRequest(RSComponentFactory factory, BIBusEnvelope anEnvelope, InternetHeaders headers, ReportServerQueue queue, String dispatcherGuid, InteractiveReportExecutingRequests executingRequests) {
        super(factory, anEnvelope, headers, queue, dispatcherGuid, executingRequests);
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    @Override
    public void sendRequest() throws CommandExecutionException, NoConnectionException, NoSuchObjectException, ServiceStoppedException, ProcessShutdownException {
        this.getConnection();
        this.connection.setRequestContentLength(-2);
        this.command = this.createGetCommand(this.requestHeaders, this.connection);
        this.command.setAutoRelease(false);
        this.timeWhenRequestWasSentToProcess = System.currentTimeMillis();
        this.command.execute();
        this.updatePerformanceIndicator();
        this.getRequestInfo().setProcessTime(System.currentTimeMillis() - this.timeWhenRequestWasSentToProcess);
        this.lastAccessed = System.currentTimeMillis();
    }

    protected ReportServiceGetCommand createGetCommand(InternetHeaders requestHeaders, ServerConnection connection) {
        ReportServiceGetCommand getCommand = this.componentFactory.createGetCommand(requestHeaders, connection);
        if (this.queryString != null) {
            getCommand.setQueryString(this.queryString);
        }
        getCommand.setRequestContext(this.requestPath);
        return getCommand;
    }

    @Override
    public boolean saveResponse(MessageContext mc) {
        int statusCode = this.command.getStatusCode();
        mc.setProperty("rscache.statusCode", statusCode);
        try {
            InternetHeaders headers = this.command.getRawResponseHeaders();
            mc.setProperty("rscache.headers", headers);
        }
        catch (Exception e) {
            log.error(this, ".saveResponse failed to get response headers.", e);
            return false;
        }
        try {
            InputStream response = this.command.getRawResponse();
            mc.setProperty("rscache.response", response);
        }
        catch (Exception e) {
            log.error(this, ".saveResponse failed to get response stream.", e);
            return false;
        }
        return true;
    }
}

