/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.reportservice;

import com.cognos.pogo.monitoring.jmx.report.InteractiveReportList;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.reportservice.CancelledRequestException;
import com.cognos.pogo.reportservice.IRSHandler;
import com.cognos.pogo.reportservice.ReportServerRequest;
import com.cognos.pogo.reportservice.ReportServerRequestInformation;
import com.cognos.pogo.util.PogoLogger;
import com.cognos.pogo.util.threads.SafeTimerTask;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javax.mail.internet.InternetHeaders;

public class ReportServerInProgressRequests
implements InteractiveReportList {
    private static final PogoLogger category = PogoLogger.getLogger();
    private Map<String, ReportServerRequest> inProgressRequests;
    private List<ReportServerRequest> overiddenRequests;
    private final Timer expirationTimer = new Timer(true);
    private static int timerCount = 0;
    private final IRSHandler reportServerHandler;
    private int executionTimeLimit = 0;
    private Object mutex = new Object();

    public ReportServerInProgressRequests(IRSHandler reportServerHandler) {
        this.reportServerHandler = reportServerHandler;
        this.inProgressRequests = new HashMap<String, ReportServerRequest>();
        this.overiddenRequests = new LinkedList<ReportServerRequest>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReportServerRequest fetchReportServerRequest(BIBusEnvelope envelope, InternetHeaders headers) throws CancelledRequestException {
        ReportServerRequest aRequest;
        String requestID = envelope.getConversationContextID();
        if (requestID == null || "".equals(requestID)) {
            category.debug("No id found in conversationContext");
            aRequest = null;
        } else {
            category.debug("Looking up request id (", requestID, ") in the in-progress map");
            Object object = this.mutex;
            synchronized (object) {
                aRequest = this.inProgressRequests.get(requestID);
            }
            if (aRequest == null) {
                return null;
            }
            if (aRequest.isCancel()) {
                throw new CancelledRequestException(this.reportServerHandler.constructMessageID("staleRequest"));
            }
            if (aRequest.requestLimitReached(this.executionTimeLimit)) {
                category.info(aRequest, " is cancelled due to execution time limit");
                aRequest.cancelRequest(this.reportServerHandler.getProcessManager().getProcessList());
                throw new CancelledRequestException(this.reportServerHandler.constructMessageID("executionLimitReached"));
            }
            if (!aRequest.isInUse()) {
                category.debug("request instance found.  Re-using request (and connection)");
                aRequest.claimRequest(envelope, headers, requestID);
            } else {
                aRequest = null;
            }
        }
        return aRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReportServerRequest remove(ReportServerRequest request) {
        Object object = this.mutex;
        synchronized (object) {
            if (this.overiddenRequests.contains(request)) {
                this.overiddenRequests.remove(request);
                category.debug(request, " removed from the overiddenRequests");
                return request;
            }
            if (this.inProgressRequests.containsValue(request)) {
                category.debug(request, " removed from the in-progress map");
                return this.inProgressRequests.remove(request.getRequestID());
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(ReportServerRequest request) {
        String requestID = request.getRequestID();
        Object object = this.mutex;
        synchronized (object) {
            if (this.inProgressRequests.containsKey(requestID)) {
                ReportServerRequest oldRequest = this.inProgressRequests.get(requestID);
                if (oldRequest == request) {
                    category.debug(request, " is already in the in-progress map");
                    return;
                }
                category.info("Key collision detected. Moving old key mapping to overridenRequests list");
                category.info("Old request:");
                category.info(oldRequest);
                category.info("New request: ");
                category.info(request);
                this.overiddenRequests.add(this.inProgressRequests.remove(requestID));
            }
            this.inProgressRequests.put(requestID, request);
            category.debug(request, " is not in the in-progress map.  Adding the instance to the map");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReportServerRequest getRequestFromInProgressMap(String requestID) {
        Object object = this.mutex;
        synchronized (object) {
            return this.inProgressRequests.get(requestID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Object object = this.mutex;
        synchronized (object) {
            return this.inProgressRequests.size() + this.overiddenRequests.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.mutex;
        synchronized (object) {
            this.inProgressRequests.clear();
            this.overiddenRequests.clear();
        }
    }

    public void startExpirationTimer(long requestExpirationTime) {
        this.expirationTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                Thread.currentThread().setName("pogo.rsvExpirationTimerThread-" + ++timerCount);
            }
        }, 0L);
        if (requestExpirationTime != 0L) {
            category.debug("Scheduling timer to check for expired async requests every ", requestExpirationTime, " ms");
            this.expirationTimer.schedule((TimerTask)new ExpiredAsynchRequestCleanup(requestExpirationTime), requestExpirationTime, requestExpirationTime);
        } else {
            category.debug("Not scheduling timer to check for expired async requests since async_wait_timeout_ms == 0");
        }
    }

    public void cancelExpirationTimer() {
        this.expirationTimer.cancel();
    }

    void checkOnce(long requestExpirationTime) {
        this.expirationTimer.schedule((TimerTask)new ExpiredAsynchRequestCleanup(requestExpirationTime), 0L);
    }

    public void setExecutionTimeLimit(int executionTimeLimit) {
        this.executionTimeLimit = executionTimeLimit * 1000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<ReportServerRequestInformation> getRequests() {
        ArrayList<ReportServerRequestInformation> list;
        Object object = this.mutex;
        synchronized (object) {
            list = new ArrayList<ReportServerRequestInformation>(this.inProgressRequests.values());
        }
        return list;
    }

    class ExpiredAsynchRequestCleanup
    extends SafeTimerTask {
        PogoLogger ttcat = PogoLogger.getLogger();
        private final long requestExpirationTime;
        private ArrayList<ReportServerRequest> requestsToCancel = new ArrayList();

        ExpiredAsynchRequestCleanup(long requestExpirationTime) {
            this.requestExpirationTime = requestExpirationTime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void safeRun() {
            try {
                ReportServerRequest aRequest;
                this.ttcat.debug("Checking for expired requests in the in progress map");
                this.requestsToCancel.clear();
                Object object = ReportServerInProgressRequests.this.mutex;
                synchronized (object) {
                    Iterator requestIterator = ReportServerInProgressRequests.this.overiddenRequests.iterator();
                    while (requestIterator.hasNext()) {
                        aRequest = (ReportServerRequest)requestIterator.next();
                        this.ttcat.debug("Checking request ", aRequest);
                        if (!aRequest.isExpired(this.requestExpirationTime)) continue;
                        requestIterator.remove();
                        category.info(aRequest, " has expired on overriden list, will release connection back to the pool");
                        aRequest.setRecycleOnly(false);
                        aRequest.clean(null);
                    }
                    Iterator keyIterator = ReportServerInProgressRequests.this.inProgressRequests.keySet().iterator();
                    while (keyIterator.hasNext()) {
                        aRequest = (ReportServerRequest)ReportServerInProgressRequests.this.inProgressRequests.get(keyIterator.next());
                        this.ttcat.debug("Checking request ", aRequest);
                        if (!aRequest.isExpired(this.requestExpirationTime)) continue;
                        this.ttcat.debug("Request ", aRequest, " has expired, will send cancel request to report server");
                        keyIterator.remove();
                        this.requestsToCancel.add(aRequest);
                    }
                }
                if (this.requestsToCancel.size() > 0) {
                    for (int i = 0; i < this.requestsToCancel.size(); ++i) {
                        aRequest = this.requestsToCancel.get(i);
                        try {
                            category.info("Cancelling expired request ", aRequest);
                            aRequest.cancelRequest(ReportServerInProgressRequests.this.reportServerHandler.getProcessManager().getProcessList());
                            continue;
                        }
                        catch (Exception ex) {
                            this.ttcat.error("Caught unexpected exception", ex);
                        }
                    }
                }
                ReportServerInProgressRequests.this.reportServerHandler.testFinishedStopping();
                try {
                    if (category.isInfoEnabled()) {
                        StringWriter strWriter = new StringWriter();
                        PrintWriter writer = new PrintWriter(strWriter);
                        ReportServerInProgressRequests.this.reportServerHandler.getProcessManager().dumpUsage(writer);
                        writer.flush();
                        category.info(strWriter.toString());
                    }
                }
                catch (IOException ex) {
                    category.error("Unable to dump process/connection usage information", ex);
                }
            }
            catch (RuntimeException e) {
                this.ttcat.error("Swallowed otherwise unhandled exception in timer task run()", e);
            }
        }
    }
}

