/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.reportservice;

import com.cognos.pogo.impl.DispatcherStrings;
import com.cognos.pogo.logging.LoggingRealm;
import com.cognos.pogo.logging.LoggingRealmFactory;
import com.cognos.pogo.logging.Slogger;
import com.cognos.pogo.logging.messages.ServiceEventAuditMsg;
import com.cognos.pogo.reportservice.util.ReportServerProcessCommands;
import com.cognos.pogo.util.PogoLogger;
import com.cognos.pogo.util.RuntimeEnvironment;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.commons.lang.StringUtils;

public class ReportServerProcess {
    private static final int MAX_STDOUT_LEN = 256;
    private static final PogoLogger log = PogoLogger.getLogger();
    private static LoggingRealm loggingRealm;
    private static final String DEFAULT_ENVIRONMENT_REPLACEMENT = "bin64%bin";
    private int reportServerPort;
    private Process nativeProcess;
    private final String[] commandLineArguments;
    private final String workingDirectory;
    private RuntimeEnvironment runtimeEnvironment;
    private int processID = 0;
    private String processName;
    public static String unknownProcessName;

    public ReportServerProcess(String[] commandLineArguments, String workingDirectory) {
        this(commandLineArguments, workingDirectory, new RuntimeEnvironment());
    }

    public ReportServerProcess(String[] commandLineArguments, String workingDirectory, RuntimeEnvironment runtimeEnvironment) {
        this.commandLineArguments = commandLineArguments;
        this.workingDirectory = workingDirectory;
        this.runtimeEnvironment = runtimeEnvironment;
        this.processName = ReportServerProcess.extractProcessName(commandLineArguments);
    }

    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    public String[] getCommandLineArguments() {
        return this.commandLineArguments;
    }

    public void setNativeProcess(Process p) {
        this.nativeProcess = p;
    }

    public Process getNativeProcess() {
        return this.nativeProcess;
    }

    public void start() throws Exception {
        log.debug("Setting process working directory to: ", this.workingDirectory);
        if (log.isDebugEnabled()) {
            StringBuffer sb = new StringBuffer("exec()ing child process: ");
            for (int i = 0; i < this.commandLineArguments.length; ++i) {
                sb.append(' ').append(this.commandLineArguments[i]);
            }
            log.debug(sb);
        }
        this.nativeProcess = this.runtimeEnvironment.startProcess(this.commandLineArguments, this.getEnvironment(), this.workingDirectory);
        try {
            int exitValue = this.nativeProcess.exitValue();
            log.debug("Process exit value is ", exitValue);
        }
        catch (IllegalThreadStateException stateException) {
            log.debug("Process.exitValue() threw IllegalThreadStateException.  ", "This implies the process was started correctly");
        }
        if (this.readPort()) {
            boolean bIsStdOutInASCII = true;
            try {
                BufferedReader aReader = null;
                bIsStdOutInASCII = this.isStdOutInASCII(this.nativeProcess.getInputStream());
                aReader = bIsStdOutInASCII ? new BufferedReader(new InputStreamReader(this.nativeProcess.getInputStream(), "ISO-8859-1")) : new BufferedReader(new InputStreamReader(this.nativeProcess.getInputStream()));
                String line = this.getProcessOutput(aReader);
                String[] outputStr = line.split("[= ]");
                if (outputStr.length == 4) {
                    this.reportServerPort = Integer.parseInt(outputStr[1]);
                    this.processID = Integer.parseInt(outputStr[3]);
                } else if (outputStr.length == 1 && Integer.parseInt(outputStr[0]) > 0) {
                    this.reportServerPort = Integer.parseInt(outputStr[0]);
                    log.error("Obsolete ", this.getProcessName(), " output is detected");
                } else {
                    throw new IllegalArgumentException("Illegal " + this.getProcessName() + " output is detected: '" + line + "'");
                }
                log.debug("New process with PID ", this.getProcessID(), " is listening on port ", this.reportServerPort);
            }
            catch (Exception e) {
                this.stop();
                throw e;
            }
            try {
                String errLine;
                BufferedReader errReader = null;
                errReader = bIsStdOutInASCII ? new BufferedReader(new InputStreamReader(this.nativeProcess.getErrorStream(), "ISO-8859-1")) : new BufferedReader(new InputStreamReader(this.nativeProcess.getErrorStream()));
                if (errReader.ready() && (errLine = errReader.readLine()) != null && errLine.length() != 0) {
                    ReportServerProcess.logReportServerStatus(this.getClass().getName(), true, "BIBus.startedWithstderr", new Object[]{this.getProcessName(), String.valueOf(this.getProcessID()), errLine});
                }
                errReader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        ReportServerProcess.logReportServerStatus(this.getClass().getName(), true, "BIBus.started", new Object[]{this.getProcessName(), String.valueOf(this.getProcessID())});
    }

    String getProcessOutput(BufferedReader aReader) throws IOException {
        String line = aReader.readLine();
        if (line != null && line.startsWith("Listening for transport ")) {
            line = aReader.readLine();
        }
        aReader.close();
        if (line == null) {
            String message = "Process " + this.getProcessName() + " failed to start properly.";
            log.debug(message);
            throw new IOException(message);
        }
        log.debug(this.getProcessName(), " responded with \"", line, "\"");
        return line;
    }

    public boolean isStdOutInASCII(InputStream is) throws IOException {
        if (!System.getProperty("os.name").equals("z/OS")) {
            return true;
        }
        boolean bIsStdOutInASCII = true;
        is.mark(257);
        BufferedReader aReader = new BufferedReader(new InputStreamReader(is, "ISO-8859-1"));
        char[] myChar = new char[256];
        aReader.read(myChar, 0, 256);
        String asciiString = new String(myChar, 0, 256);
        if (asciiString.indexOf("port=") != -1) {
            log.debug("stdout is in ASCII encoding.");
        } else {
            log.debug("stdout is in non-ASCII encoding.");
            bIsStdOutInASCII = false;
        }
        is.reset();
        return bIsStdOutInASCII;
    }

    String[] getEnvironment() {
        if (this.runtimeEnvironment.hasNoEnvironmentReplacement()) {
            this.runtimeEnvironment.setEnvironmentReplacement(DEFAULT_ENVIRONMENT_REPLACEMENT);
        }
        return this.runtimeEnvironment.getEnvironment();
    }

    public static String extractProcessName(String[] args) {
        int pos;
        File f;
        String pathAndFilename;
        String processName = unknownProcessName;
        if (args != null && args.length > 0 && StringUtils.isNotEmpty((String)(pathAndFilename = args[0])) && (processName = (f = new File(pathAndFilename)).getName()) != null && (pos = processName.lastIndexOf(".exe")) > 0) {
            processName = processName.substring(0, pos);
        }
        return processName;
    }

    protected String getProcessName() {
        return this.processName;
    }

    protected boolean readPort() {
        return true;
    }

    void stop() {
        log.debug("Calling native kill command");
        int exitVal = ReportServerProcessCommands.runKillCommand(this.getProcessID());
        if (exitVal != 0) {
            log.debug("Calling nativeProcess.destroy()");
            this.nativeProcess.destroy();
        }
        ReportServerProcess.logReportServerStatus(this.getClass().getName(), false, "BIBus.stopped", new Object[]{this.getProcessName(), String.valueOf(this.getProcessID())});
    }

    public int getReportServerPort() {
        return this.reportServerPort;
    }

    public void setReportServerPort(int p) {
        this.reportServerPort = p;
    }

    public int exitValue() throws IllegalThreadStateException {
        if (this.nativeProcess == null) {
            return 999;
        }
        return this.nativeProcess.exitValue();
    }

    public int getProcessID() {
        return this.processID;
    }

    static synchronized void logReportServerStatus(String className, boolean start, String key, Object[] parameters) {
        ServiceEventAuditMsg msg = null;
        msg = start ? new ServiceEventAuditMsg("com.cognos.pogo.reportservice", "Start") : new ServiceEventAuditMsg("com.cognos.pogo.reportservice", "Stop");
        msg.setStatus("Info");
        String logData = DispatcherStrings.getInstance().getString(key, parameters);
        msg.setLogData(logData);
        if (loggingRealm == null && (loggingRealm = LoggingRealmFactory.getInstance("DISP")) != null) {
            Slogger slogger = loggingRealm.getLogger(className);
            slogger.log(msg);
        }
    }

    public void setRuntimeEnvironment(RuntimeEnvironment runtimeEnvironment) {
        this.runtimeEnvironment = runtimeEnvironment;
    }

    static {
        unknownProcessName = "External Process";
    }
}

