/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.reportservice;

import com.cognos.pogo.bibus.CommandExecutionException;
import com.cognos.pogo.bibus.CommandExecutionFailureException;
import com.cognos.pogo.bibus.RequestAffinity;
import com.cognos.pogo.bibus.SoapFaultException;
import com.cognos.pogo.impl.DispatcherStrings;
import com.cognos.pogo.monitoring.RequestInfo;
import com.cognos.pogo.monitoring.jmx.report.InteractiveReportExecutingRequests;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.Fault;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.reportservice.BatchReportServerHandler;
import com.cognos.pogo.reportservice.CancelledRequestException;
import com.cognos.pogo.reportservice.ConnectionAssignmentInterlock;
import com.cognos.pogo.reportservice.IRSHandler;
import com.cognos.pogo.reportservice.NoConnectionException;
import com.cognos.pogo.reportservice.ProcessShutdownException;
import com.cognos.pogo.reportservice.RSComponentFactory;
import com.cognos.pogo.reportservice.ReportServerGetRequest;
import com.cognos.pogo.reportservice.ReportServerRequest;
import com.cognos.pogo.reportservice.ServiceStoppedException;
import com.cognos.pogo.transport.MethodDispatcherCacheExtractor;
import com.cognos.pogo.util.PogoLogger;
import com.cognos.pogo.util.URLEncoderDecoder;
import java.rmi.NoSuchObjectException;
import java.util.List;
import javax.mail.internet.InternetHeaders;

public class RequestInvoker {
    private static final PogoLogger log = PogoLogger.getLogger();
    private final IRSHandler reportServerHandler;
    private long defaultTimeout;
    private String dispatcherGuid;
    private String cnRequestInfo;
    private String reportServerPath;
    private String cleanListName;
    private RSComponentFactory compFactory;
    private int partialSaxLimit = -1;
    private final InteractiveReportExecutingRequests executingRequests;

    public RequestInvoker(RSComponentFactory compFactory, IRSHandler handler, InteractiveReportExecutingRequests executingRequests) {
        this.compFactory = compFactory;
        this.reportServerHandler = handler;
        this.executingRequests = executingRequests;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(MessageContext mc) {
        BIBusEnvelope envelope = (BIBusEnvelope)mc.getProperty("request.envelope");
        InternetHeaders headers = (InternetHeaders)mc.getProperty("request.headers");
        RequestAffinity affinity = RequestAffinity.determineAffinity((String)mc.getProperty("request.soapaction"));
        mc.setProperty("RSReportRequest", Boolean.TRUE);
        if (envelope.getConversationContextProcessID() == -1 && (affinity == RequestAffinity.CONTROL || affinity == RequestAffinity.ABSOLUTE || affinity == RequestAffinity.GET)) {
            mc.setFault(new Fault(this.getReportServerHandler().constructMessageID("missingConversationContext")));
            return;
        }
        ReportServerRequest aRequest = null;
        try {
            aRequest = this.getRequest(mc, envelope, headers);
            aRequest.setPartialSaxLimitInput(this.partialSaxLimit);
        }
        catch (CancelledRequestException e) {
            mc.setFault(new Fault(e.getMessage()));
            return;
        }
        ConnectionAssignmentInterlock connectionAssignment = (ConnectionAssignmentInterlock)mc.getProperty("connectionAssignmentInterlock");
        if (connectionAssignment != null) {
            aRequest.setConnectionAssignmentInterlock(connectionAssignment);
        }
        BatchReportServerHandler.ServiceCapacityCallback scc = (BatchReportServerHandler.ServiceCapacityCallback)mc.getProperty("batchReportServerCapacityConfiguration");
        aRequest.setCapacityConfiguration(scc);
        this.assignAffinity(affinity, aRequest, mc);
        try {
            if (!this.sendRequest(aRequest, mc)) {
                return;
            }
        }
        catch (CommandExecutionException commandException) {
            log.debug("sendRequest() threw a CommandExecutionException... retrying request", commandException);
            aRequest.setRecycleOnly(false);
            ReportServerRequest reportServerRequest = aRequest;
            synchronized (reportServerRequest) {
                aRequest.clean(mc);
                aRequest.claimRequest(envelope, headers, aRequest.getRequestID());
            }
            try {
                if (!this.sendRequest(aRequest, mc)) {
                    return;
                }
            }
            catch (CommandExecutionException anotherCommandException) {
                log.debug("sendRequest() threw a CommandExecutionException AGAIN", commandException);
            }
        }
        boolean validResponse = aRequest.saveResponse(mc);
        if (!validResponse) {
            if (aRequest.receivedResponse()) {
                mc.setFault(new Fault(this.getReportServerHandler().constructMessageID("badResponse")));
            } else {
                mc.setFault(new Fault(this.getReportServerHandler().constructMessageID("noResponse")));
                Object[] pid = new Object[]{String.valueOf(aRequest.getProcessID())};
                log.error(DispatcherStrings.getInstance().getString("ReportServerHandler.noResponseWithPID", pid));
            }
            this.reportServerHandler.getInProgressRequests().remove(aRequest);
            this.registerCleanable(mc, aRequest);
            return;
        }
        this.checkForMissingConfiguration(aRequest);
        this.finishRequest(aRequest);
        this.registerCleanable(mc, aRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getOutput(MessageContext mc, MethodDispatcherCacheExtractor mdce) {
        BIBusEnvelope envelope = (BIBusEnvelope)mc.getProperty("request.envelope");
        InternetHeaders headers = (InternetHeaders)mc.getProperty("request.headers");
        ReportServerRequest aRequest = null;
        try {
            aRequest = this.getGetRequest(mc, envelope, headers, mdce);
        }
        catch (CancelledRequestException e) {
            log.error(this, ".getOutput getGetRequest failed.", e);
            mc.setFault(new Fault(e.getMessage()));
            return;
        }
        this.assignAffinity(RequestAffinity.GET, aRequest, mc);
        try {
            if (!this.sendRequest(aRequest, mc)) {
                log.error(this, ".getOutput call to sendRequest failed.");
                return;
            }
        }
        catch (CommandExecutionException commandException) {
            log.debug("sendRequest() threw a CommandExecutionException... retrying request", commandException);
            aRequest.setRecycleOnly(false);
            ReportServerRequest reportServerRequest = aRequest;
            synchronized (reportServerRequest) {
                aRequest.clean(mc);
                aRequest.claimRequest(envelope, headers, aRequest.getRequestID());
            }
            try {
                if (!this.sendRequest(aRequest, mc)) {
                    log.error(this, ".getOutput call to sendRequest failed AGAIN.");
                    return;
                }
            }
            catch (CommandExecutionException anotherCommandException) {
                log.debug("sendRequest() threw a CommandExecutionException AGAIN", commandException);
            }
        }
        boolean validResponse = aRequest.saveResponse(mc);
        if (!validResponse) {
            if (aRequest.receivedResponse()) {
                mc.setFault(new Fault(this.getReportServerHandler().constructMessageID("badResponse")));
            } else {
                mc.setFault(new Fault(this.getReportServerHandler().constructMessageID("noResponse")));
                Object[] pid = new Object[]{String.valueOf(aRequest.getProcessID())};
                log.error(DispatcherStrings.getInstance().getString("ReportServerHandler.noResponseWithPID", pid));
            }
        }
        this.registerCleanable(mc, aRequest);
    }

    protected IRSHandler getReportServerHandler() {
        return this.reportServerHandler;
    }

    private void assignAffinity(RequestAffinity affinity, ReportServerRequest aRequest, MessageContext mc) {
        if (affinity == RequestAffinity.ABSOLUTE) {
            aRequest.setAffinity(RequestAffinity.ABSOLUTE, this.getDefaultTimeout());
            mc.setProperty("RSReportRequest", Boolean.FALSE);
        } else if (affinity == RequestAffinity.GET) {
            aRequest.setAffinity(RequestAffinity.GET, this.getDefaultTimeout());
            mc.setProperty("RSReportRequest", Boolean.FALSE);
        } else if (affinity == RequestAffinity.CONTROL) {
            mc.setProperty("RSReportRequest", Boolean.FALSE);
            aRequest.setAffinity(RequestAffinity.CONTROL, this.getDefaultTimeout());
        } else if (affinity == RequestAffinity.HIGH) {
            aRequest.setAffinity(RequestAffinity.HIGH, this.getDefaultTimeout());
        } else if (affinity == RequestAffinity.SESSION) {
            aRequest.setAffinity(RequestAffinity.SESSION, this.getDefaultTimeout());
        } else {
            aRequest.setAffinity(RequestAffinity.NONE, this.getDefaultTimeout());
        }
    }

    public void setDefaultTimeout(long newDefaultTimeout) {
        this.defaultTimeout = newDefaultTimeout;
    }

    public long getDefaultTimeout() {
        return this.defaultTimeout;
    }

    protected ReportServerRequest getRequest(MessageContext mc, BIBusEnvelope envelope, InternetHeaders headers) throws CancelledRequestException {
        RequestInfo requestTimeInfo = new RequestInfo();
        mc.setProperty(this.cnRequestInfo, requestTimeInfo);
        ReportServerRequest aRequest = this.reportServerHandler.getInProgressRequests().fetchReportServerRequest(envelope, headers);
        if (aRequest == null) {
            log.debug("Request not found in-progress map or request is in use.  Using new instance of ReportServerRequest");
            aRequest = this.createServerRequest(mc, envelope, headers, this.getDispatcherGuid());
            String worker_request_path = mc.getStrProperty("tmp.worker_request_path");
            if (worker_request_path != null && worker_request_path.length() > 0) {
                aRequest.setRequestPath(worker_request_path);
                log.debug("worker request path forced to: ", worker_request_path);
            } else {
                aRequest.setRequestPath(this.reportServerPath);
            }
        }
        aRequest.setRequestInfo(requestTimeInfo);
        aRequest.setRequestAttachments(mc);
        return aRequest;
    }

    protected ReportServerRequest getGetRequest(MessageContext mc, BIBusEnvelope envelope, InternetHeaders headers, MethodDispatcherCacheExtractor mdce) throws CancelledRequestException {
        RequestInfo requestTimeInfo = new RequestInfo();
        mc.setProperty(this.cnRequestInfo, requestTimeInfo);
        ReportServerGetRequest aRequest = this.createServerGetRequest(mc, envelope, headers, this.getDispatcherGuid());
        String passport = envelope.getPassportID();
        String queryString = RequestInvoker.createQueryString(passport, mdce);
        aRequest.setQueryString(queryString);
        String worker_request_path = mc.getStrProperty("tmp.worker_request_path");
        if (worker_request_path != null && worker_request_path.length() > 0) {
            aRequest.setRequestPath(worker_request_path);
            if (log.isDebugEnabled()) {
                log.debug("worker request path forced to: " + worker_request_path);
            }
        } else {
            aRequest.setRequestPath(this.reportServerPath);
        }
        aRequest.setRequestInfo(requestTimeInfo);
        return aRequest;
    }

    public static String createQueryString(String passport, MethodDispatcherCacheExtractor mdce) {
        StringBuilder queryString = new StringBuilder("b_action=rc");
        try {
            if (passport != null) {
                queryString.append("&p=");
                queryString.append(URLEncoderDecoder.encode(passport, "UTF-8"));
            }
            if (mdce.getFileName() != null) {
                queryString.append("&f=");
                queryString.append(URLEncoderDecoder.encode(mdce.getFileName(), "UTF-8"));
            }
            if (mdce.getPartName() != null) {
                queryString.append("&part=");
                queryString.append(URLEncoderDecoder.encode(mdce.getPartName(), "UTF-8"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return queryString.toString();
    }

    protected ReportServerRequest createServerRequest(MessageContext mc, BIBusEnvelope envelope, InternetHeaders headers, String dispatcherGuid) {
        return this.compFactory.newReportServerRequest(mc, envelope, headers, this.reportServerHandler.getReportServerQueue(), dispatcherGuid, this.executingRequests);
    }

    protected ReportServerGetRequest createServerGetRequest(MessageContext mc, BIBusEnvelope envelope, InternetHeaders headers, String dispatcherGuid) {
        return this.compFactory.newReportServerGetRequest(mc, envelope, headers, this.reportServerHandler.getReportServerQueue(), dispatcherGuid, this.executingRequests);
    }

    boolean sendRequest(ReportServerRequest aRequest, MessageContext mc) throws CommandExecutionException {
        try {
            aRequest.setMc(mc);
            aRequest.sendRequest();
        }
        catch (NoSuchObjectException anotherRequestedProcessNotFound) {
            Fault aFault = new Fault(this.getReportServerHandler().constructMessageID("missingProcess"));
            Object[] pid = new Object[]{String.valueOf(aRequest.getProcessID())};
            aFault.setMessageParameters(pid);
            mc.setFault(aFault);
            this.cleanupRequest(mc, aRequest);
            return false;
        }
        catch (SoapFaultException anotherRequestedProcessNotFound) {
        }
        catch (NoConnectionException anotherConnectionException) {
            this.setFaultCleanupRequest(aRequest, mc, "NO_PROCESS");
            return false;
        }
        catch (ServiceStoppedException sse) {
            this.setFaultCleanupRequest(aRequest, mc, "AbortIfSuspendedHandler.serviceStopped");
            return false;
        }
        catch (CommandExecutionFailureException cefe) {
            this.setFaultCleanupRequest(aRequest, mc, cefe.getCustomErrorMessage());
            return false;
        }
        catch (ProcessShutdownException pse) {
            Fault aFault = new Fault(this.getReportServerHandler().constructMessageID("missingProcess"));
            Object[] pid = new Object[]{String.valueOf(aRequest.getProcessID())};
            aFault.setMessageParameters(pid);
            mc.setFault(aFault);
            this.cleanupRequest(mc, aRequest);
            return false;
        }
        return true;
    }

    private void setFaultCleanupRequest(ReportServerRequest aRequest, MessageContext mc, String messageCode) {
        mc.setFault(new Fault(messageCode));
        this.cleanupRequest(mc, aRequest);
    }

    private void registerCleanable(MessageContext aMessageContext, ReportServerRequest aRequest) {
        List cleanables = (List)aMessageContext.getProperty(this.cleanListName);
        if (cleanables != null) {
            cleanables.add(aRequest);
        }
    }

    private void cleanupRequest(MessageContext mc, ReportServerRequest aRequest) {
        this.reportServerHandler.getInProgressRequests().remove(aRequest);
        this.registerCleanable(mc, aRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finishRequest(ReportServerRequest aRequest) {
        if (aRequest.isInProgress()) {
            log.debug(aRequest, " is in progress.  Reserving the request instance");
            this.reportServerHandler.getInProgressRequests().put(aRequest);
            ReportServerRequest reportServerRequest = aRequest;
            synchronized (reportServerRequest) {
                aRequest.setRecycleOnly(true);
            }
        } else {
            ReportServerRequest removedRequest = this.reportServerHandler.getInProgressRequests().remove(aRequest);
            this.logRemovedRequest(removedRequest, aRequest);
            if (removedRequest == null) {
                this.checkForUncompletedRequests(aRequest.getRequestID());
            }
        }
    }

    private void logRemovedRequest(ReportServerRequest removedRequest, ReportServerRequest aRequest) {
        if (removedRequest != null) {
            log.debug(aRequest, " is complete.  Removed request instance from the in-progress map");
        } else {
            log.debug(aRequest, " is complete and request instance was not in the in-progress map");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkForUncompletedRequests(String reqID) {
        ReportServerRequest prevRequest = this.reportServerHandler.getInProgressRequests().getRequestFromInProgressMap(reqID);
        if (prevRequest != null) {
            log.debug("The original request ", prevRequest, " is still in the the in-progress map.");
            ReportServerRequest reportServerRequest = prevRequest;
            synchronized (reportServerRequest) {
                prevRequest.setOverrideStatus(true);
                prevRequest.setRecycleOnly(false);
                if (!prevRequest.isInUse()) {
                    log.debug("The original request ", prevRequest, " is not in use, clean it.");
                    prevRequest.clean(null);
                }
            }
        }
    }

    protected void checkForMissingConfiguration(ReportServerRequest aRequest) {
        BIBusEnvelope responseEnvelope = aRequest.getResponseEnvelope();
        if (responseEnvelope == null) {
            log.debug("Can't check for missing warp configuration since no response was received");
            return;
        }
        String faultString = responseEnvelope.getFaultString();
        if (faultString == null || !faultString.startsWith("CCL-SRV-0506")) {
            log.debug("Can't check for missing warp configuration since the fault string CCL-SRV-0506 was not found");
            return;
        }
        int processID = aRequest.getProcessID();
        this.reportServerHandler.getProcessManager().reconfigureProcess(processID);
    }

    public synchronized void setDispatcherGuid(String guid) {
        this.dispatcherGuid = guid;
    }

    protected synchronized String getDispatcherGuid() {
        return this.dispatcherGuid;
    }

    public void setCnRequestInfo(String requestInfo) {
        this.cnRequestInfo = requestInfo;
    }

    public String getCnRequestInfo() {
        return this.cnRequestInfo;
    }

    public void setReportServerPath(String reportServerPath) {
        this.reportServerPath = reportServerPath;
    }

    public String getReportServerPath() {
        return this.reportServerPath;
    }

    public void setCleanListName(String cleanListName) {
        this.cleanListName = cleanListName;
    }

    public String getCleanListName() {
        return this.cleanListName;
    }

    public void setPartialSaxLimit(int limit) {
        this.partialSaxLimit = limit;
    }
}

