/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.reportservice.temporary;

import com.cognos.pogo.util.threads.SafeTimerTask;
import java.io.File;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

class CleanupExpiredSessionObjectsTimerTask
extends SafeTimerTask {
    static final Logger category = Hierarchy.getDefaultHierarchy().getLoggerFor(CleanupExpiredSessionObjectsTimerTask.class.getName());
    private long timeLimit;
    private File sessionTempDir;

    CleanupExpiredSessionObjectsTimerTask(long timeToLiveMilliSeconds, String tmpObjectsFolder) {
        this.timeLimit = timeToLiveMilliSeconds;
        this.sessionTempDir = new File(tmpObjectsFolder);
    }

    @Override
    public void safeRun() {
        try {
            if (this.timeLimit < 0L) {
                return;
            }
            this.deleteFilesFromTempDir();
        }
        catch (Exception ex) {
            category.debug("Unexpected error while deleting files from the temporary directory", (Throwable)ex);
        }
    }

    protected void deleteFilesFromTempDir() {
        File[] files = this.sessionTempDir.listFiles();
        if (files == null) {
            return;
        }
        long curTime = System.currentTimeMillis();
        for (File f : files) {
            if (!this.fileIsOlderThanLimit(f, curTime)) continue;
            f.delete();
        }
    }

    private boolean fileIsOlderThanLimit(File f, long curTime) {
        return curTime - f.lastModified() >= this.timeLimit;
    }
}

