/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.reqlog;

import com.cognos.cclcfgapi.base64;
import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;

public class RequestLog {
    private long t0;
    private ArrayList<ReqLogItem> events = new ArrayList();

    public RequestLog(long t0) {
        this.t0 = t0;
    }

    public RequestLog() {
        this.t0 = System.currentTimeMillis();
    }

    public void addNote(String tag, String note) {
        this.events.add(new Note(tag, note));
    }

    public void splitTime(String tag) {
        this.events.add(new Event(tag));
    }

    public void formatMsg(StringBuffer sb) {
        for (ReqLogItem item : this.events) {
            item.formatMsg(sb, this.t0);
            sb.append('\t');
        }
    }

    public static RequestLog fromStringForm(String s) {
        byte[] bytes = base64.decode((int)0, (String)s);
        try {
            ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(bytes));
            return (RequestLog)ois.readObject();
        }
        catch (Exception e) {
            System.out.println("failed to deserialize RequestLog from string");
            e.printStackTrace();
            return null;
        }
    }

    class Note
    extends ReqLogItem {
        private static final long serialVersionUID = 1L;
        String note;

        Note(String tag, String note) {
            super(tag);
            this.note = note;
        }

        @Override
        public void formatMsg(StringBuffer sb, long t0) {
            super.formatMsg(sb, t0);
            sb.append(this.note);
        }
    }

    class Event
    extends ReqLogItem {
        private static final long serialVersionUID = 1L;
        long timeStamp;

        Event(String tag) {
            super(tag);
            this.timeStamp = System.currentTimeMillis();
        }

        @Override
        public void formatMsg(StringBuffer sb, long t0) {
            super.formatMsg(sb, t0);
            sb.append(this.timeStamp - t0);
        }
    }

    class ReqLogItem
    implements Serializable {
        private static final long serialVersionUID = 1L;
        String tag;

        ReqLogItem(String tag) {
            this.tag = tag;
        }

        public void formatMsg(StringBuffer sb, long t0) {
            sb.append(this.tag).append('=');
        }
    }
}

