/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.sdk;

import com.cognos.p2pd.util.PropertyInserter;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.pdk.Fault;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.pdk.SOAPEnvelope;
import com.cognos.pogo.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.SequenceInputStream;
import java.util.ArrayList;
import javax.mail.internet.InternetHeaders;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class WSDL
extends BasicHandler {
    private String gatewayLocation = null;
    public static final String sSDK_ENDPOINT = "@@SDK_ENDPOINT@@";
    static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(WSDL.class.getName());
    private static final InternetHeaders responseHeaders = new InternetHeaders();
    private static final SOAPEnvelope dummyEnvelope = new BIBusEnvelope();
    private static final byte[] CONTENT_TYPE_HEADER = "Content-Type: text/xml; charset=utf-8\r\n\r\n".getBytes();
    private static byte[] wsdlContent = null;

    public WSDL() {
        super(cat);
    }

    public byte[] getWSDL() throws IOException {
        DataInputStream inStream = new DataInputStream(this.getClass().getClassLoader().getResourceAsStream(PropertyInserter.getProperty("wsdl.name")));
        int bytesAvailable = inStream.available();
        byte[] data = new byte[bytesAvailable];
        inStream.readFully(data);
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invokeImpl(MessageContext mc) throws PogoException {
        WSDL wSDL = this;
        synchronized (wSDL) {
            if (wsdlContent == null) {
                try {
                    wsdlContent = this.getWSDL();
                    String wsdlStr = new String(wsdlContent, "UTF-8");
                    wsdlStr = this.replaceEndpoint(wsdlStr);
                    wsdlContent = wsdlStr.getBytes("UTF-8");
                }
                catch (Exception ex) {
                    mc.setFault(new Fault("CANNOT_READ_WSDL"));
                    return;
                }
                if (wsdlContent == null) {
                    mc.setFault(new Fault("CANNOT_READ_WSDL"));
                    return;
                }
            }
        }
        ByteArrayInputStream wsdlStream = new ByteArrayInputStream(wsdlContent);
        SequenceInputStream compositeStream = new SequenceInputStream(new ByteArrayInputStream(CONTENT_TYPE_HEADER), wsdlStream);
        ArrayList<SequenceInputStream> attachmentList = new ArrayList<SequenceInputStream>(1);
        attachmentList.add(compositeStream);
        mc.setProperty("response.status_code", "200");
        mc.setProperty("response.status_msg", "OK");
        mc.setProperty("response.headers", responseHeaders);
        mc.setProperty("response.envelope", dummyEnvelope);
        mc.setProperty("response.attachments", attachmentList.iterator());
        mc.setProperty("response.boundary", StringUtils.getUniqueValue());
    }

    @Override
    public void configure(Configuration configuration) {
        this.gatewayLocation = configuration.getValue("sdk");
    }

    private String replaceEndpoint(String rawWSDL) {
        int currentMatch = rawWSDL.indexOf(sSDK_ENDPOINT);
        if (currentMatch == -1) {
            return rawWSDL;
        }
        int markerLength = sSDK_ENDPOINT.length();
        int currentStringPosition = 0;
        StringBuffer strBuf = new StringBuffer();
        while (currentMatch != -1) {
            strBuf.append(rawWSDL.substring(currentStringPosition, currentMatch));
            strBuf.append(this.gatewayLocation);
            currentStringPosition = currentMatch + markerLength;
            currentMatch = rawWSDL.indexOf(sSDK_ENDPOINT, currentStringPosition);
        }
        int rawWSDLLength = rawWSDL.length();
        if (currentStringPosition < rawWSDLLength) {
            strBuf.append(rawWSDL.substring(currentStringPosition, rawWSDLLength));
        }
        return strBuf.toString();
    }
}

