/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.services;

import com.cognos.pogo.impl.DispatcherStrings;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.pdk.Handler;
import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.pogo.services.HandlerReadingService;
import com.cognos.pogo.util.PogoIPFLog;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class DefaultHandlerService
extends HandlerReadingService {
    private static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(DefaultHandlerService.class.getName());
    protected PogoEngine engine;

    @Override
    public void compose(PogoEngine manager) {
        this.engine = manager;
        for (Handler h : this.handlers.values()) {
            try {
                cat.debug("composing handler \"" + h.getName() + "\"");
                h.compose(this.engine);
            }
            catch (Exception e) {
                cat.error("problem composing handler " + h.getName(), (Throwable)e);
                String errorMessage = DispatcherStrings.getInstance().getString("DefaultHandlerService.threwException", new Object[]{h.getName()});
                PogoIPFLog.getInstance().logStartupError(errorMessage);
            }
        }
    }

    @Override
    public void configure(Configuration configuration) {
        super.configure(configuration);
        this.changeConfiguration(configuration);
        for (Handler h : this.handlers.values()) {
            cat.debug("configuring handler \"" + h.getName() + "\"");
            try {
                h.configure(configuration);
            }
            catch (Exception e) {
                cat.error("problem configuring handler " + h.getName(), (Throwable)e);
                String errorMessage = DispatcherStrings.getInstance().getString("DefaultHandlerService.threwException", new Object[]{h.getName()});
                PogoIPFLog.getInstance().logStartupError(errorMessage);
            }
        }
    }

    private void changeConfiguration(Configuration configuration) {
        if (this.isRegisterInCM()) {
            configuration.reconfigureForService(this.getName());
        }
    }

    @Override
    public void initialize() {
        super.initialize();
        for (Handler h : this.handlers.values()) {
            cat.debug("initializing handler \"" + h.getName() + "\"");
            try {
                h.initialize();
            }
            catch (Exception e) {
                cat.error("problem initializing handler " + h.getName(), (Throwable)e);
                String errorMessage = DispatcherStrings.getInstance().getString("DefaultHandlerService.threwException", new Object[]{h.getName()});
                PogoIPFLog.getInstance().logStartupError(errorMessage);
            }
        }
    }

    @Override
    public void start() {
        for (Handler h : this.handlers.values()) {
            cat.debug("starting handler \"" + h.getName() + "\"");
            try {
                h.start();
            }
            catch (Exception e) {
                cat.error("problem starting handler " + h.getName(), (Throwable)e);
                String errorMessage = DispatcherStrings.getInstance().getString("DefaultHandlerService.threwException", new Object[]{h.getName()});
                PogoIPFLog.getInstance().logStartupError(errorMessage);
            }
        }
    }

    @Override
    public void allServicesStarted() {
        for (Handler h : this.handlers.values()) {
            cat.debug("allServicesStarted: handler \"" + h.getName() + "\"");
            try {
                h.allServicesStarted();
            }
            catch (Exception e) {
                cat.error("allServicesStarted: problem with handler " + h.getName(), (Throwable)e);
                String errorMessage = DispatcherStrings.getInstance().getString("DefaultHandlerService.threwException", new Object[]{h.getName()});
                PogoIPFLog.getInstance().logStartupError(errorMessage);
            }
        }
    }

    @Override
    public void suspend(boolean immediate) {
        for (Handler h : this.handlers.values()) {
            cat.debug("suspending handler \"" + h.getName() + "\"");
            try {
                h.suspend(immediate);
            }
            catch (RuntimeException re) {
                cat.error("problem suspending handler " + h.getName(), (Throwable)re);
                throw re;
            }
            catch (Exception e) {
                cat.error("problem suspending handler " + h.getName(), (Throwable)e);
            }
        }
    }

    @Override
    public void resume() {
        for (Handler h : this.handlers.values()) {
            cat.debug("resuming handler \"" + h.getName() + "\"");
            try {
                h.resume();
            }
            catch (RuntimeException re) {
                cat.error("problem resuming handler " + h.getName(), (Throwable)re);
                throw re;
            }
            catch (Exception e) {
                cat.error("problem resuming handler " + h.getName(), (Throwable)e);
            }
        }
    }

    @Override
    public void reconfigure(Configuration configuration) {
        super.reconfigure(configuration);
        this.changeConfiguration(configuration);
        for (Handler h : this.handlers.values()) {
            cat.debug("reconfiguring handler \"" + h.getName() + "\"");
            try {
                h.reconfigure(configuration);
            }
            catch (Exception e) {
                cat.error("problem reconfiguring handler " + h.getName(), (Throwable)e);
            }
        }
    }

    @Override
    public void stop() {
        for (Handler h : this.handlers.values()) {
            cat.debug("stopping handler \"" + h.getName() + "\"");
            try {
                h.stop();
            }
            catch (Exception e) {
                cat.error("problem stopping handler " + h.getName(), (Throwable)e);
            }
        }
    }

    @Override
    public void dispose() {
        for (Handler h : this.handlers.values()) {
            cat.debug("disposing handler \"" + h.getName() + "\"");
            try {
                h.dispose();
            }
            catch (Exception e) {
                cat.error("problem disposing handler " + h.getName(), (Throwable)e);
            }
        }
    }
}

