/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.services;

import com.cognos.indications.LogIPFControl;
import com.cognos.pogo.config.ConfigurationImpl;
import com.cognos.pogo.impl.DispatcherStrings;
import com.cognos.pogo.logging.LoggingRealm;
import com.cognos.pogo.logging.LoggingRealmFactory;
import com.cognos.pogo.logging.Slogger;
import com.cognos.pogo.logging.SystemEventLogger;
import com.cognos.pogo.logging.messages.ServiceErrorAuditMsg;
import com.cognos.pogo.logging.messages.ServiceEventAuditMsg;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.pdk.Handler;
import com.cognos.pogo.pdk.Invokable;
import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.pogo.pdk.Service;
import com.cognos.pogo.pdk.soapaction.SoapActionLookup;
import com.cognos.pogo.services.attributes.ServiceAttribute;
import com.cognos.pogo.services.concurrent.ServiceExecutor;
import com.cognos.pogo.services.concurrent.ServiceOrderedMap;
import com.cognos.pogo.util.PogoLogger;
import com.cognos.pogo.util.threads.SafeThread;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class DispatcherServices {
    static final LoggingRealm loggingRealm = LoggingRealmFactory.getInstance("DISP");
    static final Slogger slogger = loggingRealm.getLogger(DispatcherServices.class.getName());
    private static final PogoLogger cat = PogoLogger.getLoggerFor(DispatcherServices.class.getName());
    private static final Logger catStatus = Hierarchy.getDefaultHierarchy().getLoggerFor("STATUS." + DispatcherServices.class.getName());
    private ServiceOrderedMap serviceLoadMap = new ServiceOrderedMap();
    private ArrayList<Service> serviceUnloadMap = new ArrayList();
    private Map<String, Invokable> invokableLookupMap = Collections.synchronizedMap(new HashMap());
    private HashMap<String, Service> serviceLookupMap = new HashMap();
    private HashMap<String, String> serviceForPath = new HashMap();
    private ArrayList<String> attributeList = null;
    private boolean firstTimeConfigured = true;
    protected PogoEngine pogo_engine;
    private ArrayList<String> globalAttributeList;
    private SoapActionLookup soapActionLookup;
    private static final String startServiceSuccess = "StartService".concat(" {0} ").concat("Success");
    private static final String stopServiceSuccess = "StopService".concat(" {0} ").concat("Success");

    public DispatcherServices() {
        this(new SoapActionLookup());
    }

    public DispatcherServices(SoapActionLookup soapActionLookup) {
        this.soapActionLookup = soapActionLookup;
    }

    public void add(Service service) {
        this.addToLoadMap(service);
        this.addToUnloadMap(service);
        this.addServiceToLookupMap(service);
    }

    public void addServiceToLookupMap(Service service) {
        this.serviceLookupMap.put(service.getName(), service);
    }

    private void addToLoadMap(Service service) {
        this.serviceLoadMap.add(service.getLoadPriority(), service);
    }

    private void addToUnloadMap(Service service) {
        for (int i = 0; i < this.serviceUnloadMap.size(); ++i) {
            if (service.getUnloadPriority() < this.serviceUnloadMap.get(i).getUnloadPriority()) continue;
            this.serviceUnloadMap.add(i, service);
            return;
        }
        this.serviceUnloadMap.add(service);
    }

    public void compose(PogoEngine engine) {
        this.pogo_engine = engine;
        for (Service service : this.serviceLoadMap.getList()) {
            ServiceErrorAuditMsg msg;
            if (service.getLoadPriority() <= 0) continue;
            try {
                cat.debug("Attempting to compose service: ", service.getName());
                service.compose(engine);
            }
            catch (Exception e) {
                cat.error("error in compose of service " + service.getName(), e);
                msg = new ServiceErrorAuditMsg(service.getName(), "compose");
                msg.addErrorMessage(e);
                slogger.log(msg);
            }
            catch (LinkageError le) {
                cat.error("LinkageError in compose of service " + service.getName(), le);
                msg = new ServiceErrorAuditMsg(service.getName(), "compose");
                msg.addErrorMessage(le);
                slogger.log(msg);
            }
        }
    }

    public void configure(Configuration configuration) {
        this.serviceLoadMap.run(ServiceExecutor.OperationType.CONFIGURE, configuration);
        if (this.firstTimeConfigured) {
            this.firstTimeConfigured = false;
            this.continueStartup();
        }
    }

    public void reconfigure(Configuration configuration) {
        this.serviceLoadMap.run(ServiceExecutor.OperationType.RECONFIGURE, configuration);
    }

    public void initialize() {
        for (Service service : this.serviceLoadMap.getList()) {
            ServiceErrorAuditMsg msg;
            if (service.getLoadPriority() <= 0) continue;
            try {
                cat.debug("Attempting to init service: ", service.getName());
                service.initialize();
            }
            catch (Exception e) {
                cat.error("error in initialize of service " + service.getName(), e);
                msg = new ServiceErrorAuditMsg(service.getName(), "initialize");
                msg.addErrorMessage(e);
                slogger.log(msg);
            }
            catch (LinkageError le) {
                cat.error("LinkageError in initialize of service " + service.getName(), le);
                msg = new ServiceErrorAuditMsg(service.getName(), "initialize");
                msg.addErrorMessage(le);
                slogger.log(msg);
            }
        }
    }

    public void start() {
        this.serviceLoadMap.run(ServiceExecutor.OperationType.START, null);
    }

    public void allServicesStarted() {
        for (Service service : this.serviceLoadMap.getList()) {
            ServiceErrorAuditMsg msg;
            try {
                Method method = service.getClass().getMethod("allServicesStarted", null);
                if (method == null) continue;
                cat.debug("Attempting to invoke allServicesStarted method on service: ", service.getName());
                method.invoke((Object)service, (Object[])null);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                cat.debug("ignoring exception - cannot invoke allServicesStarted method for service " + service.getName());
            }
            catch (Exception e) {
                cat.error("error in allServicseStarted of service " + service.getName(), e);
                msg = new ServiceErrorAuditMsg(service.getName(), "StartService");
                msg.addErrorMessage(e);
                slogger.log(msg);
            }
            catch (LinkageError le) {
                cat.error("LinkageError in allServicesStarted of service " + service.getName(), le);
                msg = new ServiceErrorAuditMsg(service.getName(), "StartService");
                msg.addErrorMessage(le);
                slogger.log(msg);
            }
        }
    }

    public void stop() {
        for (Service service : this.serviceUnloadMap) {
            ServiceErrorAuditMsg msg;
            try {
                cat.debug("Attempting to stop service: ", service.getName());
                if (service.isLogStartStop()) {
                    String serviceName = service.getCMdefaultName();
                    if (serviceName == null) {
                        serviceName = service.getName();
                    }
                    catStatus.info(MessageFormat.format(stopServiceSuccess, serviceName));
                    slogger.log(new ServiceEventAuditMsg(serviceName, "StopService"));
                }
                if (this.stopServiceInThread(service, 20000)) {
                    cat.debug("Service is stopped: ", service.getName());
                    continue;
                }
                cat.error("Service did not stop in timely fashion: ", service.getName());
                ServiceErrorAuditMsg msg2 = new ServiceErrorAuditMsg(service.getName(), "StopService");
                String errorMessage = DispatcherStrings.getInstance().getString("SERVICE_DIDNT_STOP", new Object[]{service.getName()});
                msg2.addErrorMessage(errorMessage);
                slogger.log(msg2);
            }
            catch (Exception e) {
                cat.error("error in stop of service " + service.getName(), e);
                msg = new ServiceErrorAuditMsg(service.getName(), "StopService");
                msg.addErrorMessage(e);
                slogger.log(msg);
            }
            catch (LinkageError le) {
                cat.error("LinkageError in stop of service " + service.getName(), le);
                msg = new ServiceErrorAuditMsg(service.getName(), "StopService");
                msg.addErrorMessage(le);
                slogger.log(msg);
            }
        }
    }

    public void dispose() {
        for (Service service : this.serviceLoadMap.getList()) {
            try {
                service.dispose();
            }
            catch (Exception e) {
                cat.error("error in dispose of service " + service.getName(), e);
            }
            catch (LinkageError le) {
                cat.error("LinkageError in dispode of service " + service.getName(), le);
            }
        }
    }

    private boolean stopServiceInThread(Service service, int msTimeLimit) {
        ServiceStopper stopper = new ServiceStopper(service);
        stopper.start();
        try {
            stopper.join(msTimeLimit);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!stopper.isStopped()) {
            cat.debug("service did not stop within timelimit, interrupting stopper thread.");
            stopper.interrupt();
            try {
                stopper.join(1000L);
            }
            catch (InterruptedException e1) {
                cat.debug("thread interrupted stopping service, will not try again");
            }
        }
        return stopper.isStopped();
    }

    public Handler lookupHandler(String path) {
        return this.soapActionLookup.lookupSoapAction(path);
    }

    public Invokable lookupInvokable(String path) {
        return this.invokableLookupMap.containsKey(path) ? this.invokableLookupMap.get(path) : this.lookupHandler(path);
    }

    public void addHandlerForPath(String path, Handler handler) {
        this.addHandlerForPath(path, handler, null);
    }

    public ArrayList<String> addHandlerForPath(String path, Handler handler, String bridgeVersion) {
        cat.debug("addHandlerForPath: ", path, ", ", handler);
        return this.soapActionLookup.addMapping(path, handler, bridgeVersion);
    }

    public ArrayList<String> changeHandlerForPath(String soapAction, Handler handler) {
        cat.debug("changeHandlerForPath: ", soapAction, ", ", handler);
        return this.soapActionLookup.changeMapping(soapAction, handler);
    }

    public void addInvokableForPath(String path, Invokable invokable) {
        cat.debug("addInvokableForPath: ", path, ", ", invokable);
        this.invokableLookupMap.put(path, invokable);
    }

    public Map<String, Handler> getHandlerMap() {
        return this.soapActionLookup.getMap();
    }

    public HashMap<String, String> getServiceMap() {
        return this.serviceForPath;
    }

    public Service getService(String name) {
        return this.serviceLookupMap.get(name);
    }

    public void startInititalServices(PogoEngine engine) {
        ConfigurationImpl configuration = new ConfigurationImpl();
        configuration.reconfigure(null);
        this.soapActionLookup.setPogoEngine(engine);
        for (Service service : this.serviceLoadMap.getList()) {
            if (service.getLoadPriority() > 0) {
                return;
            }
            this.startInitialService(service, engine, configuration);
        }
    }

    public void startInitialService(Service service, PogoEngine engine, Configuration configuration) {
        String serviceName = service.getName();
        try {
            cat.debug("compose initial service \"", serviceName, "\"");
            service.compose(engine);
            cat.debug("configure initial service \"", serviceName, "\"");
            service.configure(configuration);
            cat.debug("initialize initial service \"", serviceName, "\"");
            service.initialize();
            cat.debug("start initial service \"", serviceName, "\"");
            service.start();
            if (service.isLogStartStop()) {
                String loggingName = service.getCMdefaultName();
                if (loggingName == null) {
                    loggingName = service.getName();
                }
                catStatus.info(MessageFormat.format(startServiceSuccess, loggingName));
                slogger.log(new ServiceEventAuditMsg(loggingName, "StartService"));
            }
        }
        catch (Exception e) {
            cat.error("error in start of initial service " + serviceName, e);
            ServiceErrorAuditMsg msg = new ServiceErrorAuditMsg(serviceName, "initialStart");
            msg.addErrorMessage(e);
            slogger.log(msg);
        }
        catch (LinkageError le) {
            cat.error("LinkageError in starting of initial service " + serviceName, le);
            ServiceErrorAuditMsg msg = new ServiceErrorAuditMsg(serviceName, "initialStart");
            msg.addErrorMessage(le);
            slogger.log(msg);
        }
    }

    void continueStartup() {
        this.initialize();
        this.start();
        this.allServicesStarted();
        this.pogo_engine.setReadyToProcess(true);
        catStatus.info(DispatcherStrings.getInstance().getString("DISPATCHER_ISREADY"));
        SystemEventLogger.logSystemStartup();
        LogIPFControl.closeFeedbackLoop();
    }

    public ArrayList<String> getAttributeList() {
        if (this.attributeList == null) {
            this.attributeList = this.getAttributesFromServices(true);
        }
        return this.attributeList;
    }

    private ArrayList<String> getAttributesFromServices(boolean isLocal) {
        ArrayList<String> attributeNameList = new ArrayList<String>();
        for (Service service : this.serviceLoadMap.getList()) {
            List<ServiceAttribute> list = service.getAttributeList();
            if (list == null) continue;
            for (ServiceAttribute serviceAttribute : list) {
                if (isLocal != serviceAttribute.isLocal()) continue;
                attributeNameList.add(serviceAttribute.getValue());
            }
        }
        return attributeNameList;
    }

    public List<Service> getBootstrapServices() {
        ArrayList<Service> bootstrapServices = new ArrayList<Service>();
        for (Service service : this.serviceLoadMap.getList()) {
            if (!service.isRegisterInCM()) continue;
            bootstrapServices.add(service);
        }
        return bootstrapServices;
    }

    public void addServiceForPath(String path, String serviceName) {
        this.serviceForPath.put(path, serviceName);
    }

    public String getServiceForPath(String path) {
        return this.serviceForPath.get(path);
    }

    public ArrayList<String> getGlobalAttributeList() {
        if (this.globalAttributeList == null) {
            this.globalAttributeList = this.getAttributesFromServices(false);
        }
        return this.globalAttributeList;
    }

    public String getServiceParameter(String soapAction, String paramaterName) {
        String serviceName = this.getServiceForPath(soapAction);
        Service service = serviceName != null ? this.getService(serviceName) : null;
        return service != null ? service.getServiceParameter(paramaterName) : null;
    }

    public void removeSoapAction(String soapAction) {
        this.soapActionLookup.removeSoapAction(soapAction);
    }

    public void addGlobalAttributes(String[] attributes) {
        for (String attribute : attributes) {
            this.globalAttributeList.add(attribute);
        }
    }

    public void removeService(String serviceName) {
        this.removeFromMap(serviceName, this.serviceLoadMap);
        this.serviceLookupMap.remove(serviceName);
    }

    private void removeFromMap(String serviceName, ServiceOrderedMap serviceLoadMap2) {
        List<Service> serviceList = serviceLoadMap2.getList();
        for (int i = 0; i < serviceList.size(); ++i) {
            if (!serviceList.get(i).getName().equals(serviceName)) continue;
            serviceList.remove(i);
        }
    }

    List<Service> getServiceLoadMapForTesting() {
        return this.serviceLoadMap.getList();
    }

    ArrayList<Service> getServiceUnloadMapForTesting() {
        return this.serviceUnloadMap;
    }

    public List<String> expandPreviousVersions(String soapAction) {
        return this.soapActionLookup.expandPreviousVersions(soapAction);
    }

    public List<String> transferSoapAction(String soapAction, Handler loadBalanceServiceHandler) {
        return this.soapActionLookup.transferSoapAction(soapAction, loadBalanceServiceHandler);
    }

    public List<String> getAllSoapActionVersions(String soapAction) {
        return this.soapActionLookup.getAllVersions(soapAction);
    }

    private static class ServiceStopper
    extends SafeThread {
        private static final Logger sslgr = Hierarchy.getDefaultHierarchy().getLoggerFor(ServiceStopper.class.getName());
        private Service service;
        private boolean stopped = false;

        ServiceStopper(Service service) {
            super("stopper-" + service.getName());
            this.service = service;
            this.setDaemon(true);
        }

        @Override
        public void safeRun() {
            sslgr.debug("before calling service.stop() for " + this.service.getName());
            this.service.stop();
            sslgr.debug("service.stop() returned");
            this.stopped = true;
        }

        public boolean isStopped() {
            return this.stopped;
        }
    }
}

