/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.services;

import com.cognos.pogo.pdk.Handler;
import com.cognos.pogo.pdk.HandlerPool;
import com.cognos.pogo.pdk.InvalidServiceException;
import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.pogo.services.CMSoapActionHandlerService;
import com.cognos.pogo.services.DefaultHandlerService;
import com.cognos.pogo.services.DispatcherServices;
import com.cognos.pogo.util.DefaultLocalSoapActions;
import com.cognos.pogo.util.PogoLogger;
import java.util.ArrayList;
import java.util.HashMap;
import org.dom4j.Element;

public class SoapActionHandlerService
extends DefaultHandlerService {
    private static final PogoLogger cat = PogoLogger.getLogger();
    protected HashMap<String, String> soapActionList = new HashMap();

    @Override
    public HandlerPool contextualize(Element element) throws InvalidServiceException {
        HandlerPool hp = super.contextualize(element);
        return hp;
    }

    protected void getActions(Element element, boolean addAsLocalSoapActions) {
        for (Element e : element.selectNodes("soapActions/soapAction")) {
            String path = e.attributeValue("path");
            if (path == null || path.length() == 0) {
                cat.error("SoapAction path missing, Action will be ignored");
                continue;
            }
            String handlerName = e.attributeValue("handler");
            if (handlerName == null || handlerName.length() == 0) {
                cat.error("SoapAction handler name missing, Action will be ignored");
                continue;
            }
            String bridgeVersion = e.attributeValue("bridgeVersion");
            this.addSoapAction(path, handlerName, bridgeVersion);
            if (!addAsLocalSoapActions) continue;
            cat.debug("addLocalSoapAction: " + path);
            DefaultLocalSoapActions.addLocalDispSoapAction(path);
        }
    }

    private void addSoapAction(String path, String handlerName, String bridgeVersion) {
        cat.debug("addSoapAction: ", path, ", ", handlerName, " bridgeVersion= ", bridgeVersion);
        this.soapActionList.put(path, handlerName);
        this.addHandlerForPath(path, handlerName, bridgeVersion);
    }

    @Override
    public void compose(PogoEngine manager) {
        super.compose(manager);
        this.getActions(this.element, this.ifThisIsCMService());
    }

    protected void addHandlerForPath(String path, String handlerName, String bridgeVersion) {
        Handler handler = this.engine.getHandlerPool().find(handlerName);
        if (handler == null) {
            cat.error("SOAPAction \"", path, "\" maps to non-existent handler: \"", handlerName);
        }
        DispatcherServices dispatcherServices = this.engine.getDispatcherServices();
        ArrayList<String> expandedSoapActions = dispatcherServices.addHandlerForPath(path, handler, bridgeVersion);
        for (String soapAction : expandedSoapActions) {
            dispatcherServices.addServiceForPath(soapAction, this.getName());
        }
        dispatcherServices.addServiceForPath(path, this.getName());
    }

    protected boolean ifThisIsCMService() {
        return this instanceof CMSoapActionHandlerService;
    }
}

