/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.stax.connection;

import com.cognos.pogo.bibus.Crypto;
import com.cognos.pogo.bibus.CryptoFacility;
import com.cognos.pogo.http.mime.MIMEPartParser;
import com.cognos.pogo.stax.IXMLHandler;
import com.cognos.pogo.stax.SOAPFault;
import com.cognos.pogo.stax.SOAPMessage;
import com.cognos.pogo.stax.connection.IAttachmentHandler;
import com.cognos.pogo.stax.connection.SOAPConnection;
import com.cognos.pogo.stax.stream.IsolatedXMLStreamReader;
import com.cognos.pogo.stax.stream.PathIterator;
import com.cognos.pogo.stax.stream.XMLStreamFactory;
import com.cognos.pogo.stax.utils.StaxUtils;
import com.cognos.pogo.util.PerfLogger;
import com.cognos.pogo.util.PerfTimer;
import com.cognos.pogo.util.PogoLogger;
import com.cognos.pogo.util.XmlUtils;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import javax.mail.MessagingException;
import javax.mail.internet.InternetHeaders;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.log.Priority;

public class SOAPConnectionImpl
extends SOAPConnection {
    public static final String XML_PROLOG = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>";
    private static final String SOAP_ENV_START = "<SOAP-ENV:Envelope";
    private static final String FAULT_NAMESPACE = " xmlns:faults=\"http://www.w3.org/2001/09/soap-faults\"";
    private static final String COMMON_NAMESPACES = " xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:bus=\"http://developer.cognos.com/schemas/bibus/3/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\">";
    public static final String SOAP_ENV_OPEN = "<SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:bus=\"http://developer.cognos.com/schemas/bibus/3/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\">";
    public static final String SOAP_ENV_OPEN_WITH_FAULTS = "<SOAP-ENV:Envelope xmlns:faults=\"http://www.w3.org/2001/09/soap-faults\" xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:bus=\"http://developer.cognos.com/schemas/bibus/3/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\">";
    public static final String SOAP_ENV_CLOSE = "</SOAP-ENV:Envelope>";
    public static final String SOAP_BODY_OPEN = "<SOAP-ENV:Body>";
    public static final String SOAP_BODY_CLOSE = "</SOAP-ENV:Body>";
    public static final String SOAP_HEADER_OPEN = "<SOAP-ENV:Header>";
    public static final String SOAP_HEADER_CLOSE = "</SOAP-ENV:Header>";
    protected static final String CONTENT_TYPE = "content-type";
    protected static final String MULTIPART_MIME_TYPE = "multipart/related";
    private static final int BUFFER_SIZE = 4096;
    private static final String serviceID = "CMCS";
    protected HttpURLConnection m_connection;
    private PerfLogger perfLogger;
    private Crypto crypto;
    private boolean trustedRequest;
    private static PogoLogger log = PogoLogger.getLogger();

    public SOAPConnectionImpl(PerfLogger perfLogger) {
        this.perfLogger = perfLogger.cloneIfEnabled(this.getClass());
    }

    @Override
    public void execute(SOAPMessage message, String urlString) throws MalformedURLException, SOAPFault, IOException, XMLStreamException {
        URL url = new URL(urlString);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        this.execute(message, connection, urlString);
    }

    public void execute(SOAPMessage message, HttpURLConnection connection, String urlString) throws MalformedURLException, SOAPFault, IOException, XMLStreamException {
        InputStream input;
        PerfTimer executeTimer;
        block4: {
            executeTimer = this.perfLogger.startTimer(PerfLogger.Level.LEVEL2, "execute", urlString);
            this.m_connection = connection;
            this.m_connection.setRequestMethod("POST");
            this.m_connection.setUseCaches(true);
            this.m_connection.setDoOutput(true);
            this.m_connection.setDoInput(true);
            this.m_connection.setRequestProperty("Content-Type", "text/xml; charset=utf-8");
            String soapAction = message.getSOAPAction();
            if (soapAction != null) {
                this.m_connection.setRequestProperty("SOAPAction", soapAction);
            }
            PerfTimer sendRequestTimer = this.perfLogger.startTimer(PerfLogger.Level.LEVEL2, "execute", "Send SOAP Request");
            OutputStream output = this.m_connection.getOutputStream();
            BufferedWriter writerOutput = new BufferedWriter(new OutputStreamWriter(output, "UTF-8"));
            this.writeRequest(message, writerOutput, true);
            ((Writer)writerOutput).flush();
            output.close();
            this.perfLogger.stopTimer(sendRequestTimer);
            this.logRequest(message);
            input = null;
            try {
                input = new BufferedInputStream(this.m_connection.getInputStream(), 4096);
            }
            catch (IOException e) {
                input = this.m_connection.getErrorStream();
                if (input != null) break block4;
                throw e;
            }
        }
        if (this.m_connection.getResponseCode() >= 400 && this.m_connection.getResponseCode() != 500) {
            log.error("SOAP Connection response code: ", this.m_connection.getResponseCode());
            throw new IOException("SOAP connection error " + this.m_connection.getResponseCode() + " : " + this.m_connection.getResponseMessage());
        }
        String contentTypeValue = this.m_connection.getHeaderField(CONTENT_TYPE);
        this.processResponse(message, input, contentTypeValue);
        this.perfLogger.stopTimer(executeTimer);
    }

    protected void processResponse(SOAPMessage message, InputStream input, String contentTypeValue) throws IOException, SOAPFault, XMLStreamException {
        PerfTimer processResponseTimer = this.perfLogger.startTimer(PerfLogger.Level.LEVEL2, "processResponse", "process SOAP Response");
        if (log.isDebugEnabled()) {
            input = this.logResponse(input);
        }
        if (contentTypeValue.regionMatches(true, 0, MULTIPART_MIME_TYPE, 0, MULTIPART_MIME_TYPE.length())) {
            String multiPartBoundary = MIMEPartParser.getBoundaryFromContentType(contentTypeValue);
            MIMEPartParser it = new MIMEPartParser(input, multiPartBoundary);
            if (it.hasNext()) {
                input = (InputStream)it.next();
                this.advanceHeaders(input);
                this.readResponse(input, message);
                while (it.hasNext()) {
                    input = (InputStream)it.next();
                    IAttachmentHandler handler = message.getResponseAttachmentHandler();
                    if (handler == null) continue;
                    handler.handle(input, this.advanceHeaders(input));
                }
            }
        } else {
            this.readResponse(input, message);
        }
        this.perfLogger.stopTimer(processResponseTimer);
    }

    protected InternetHeaders advanceHeaders(InputStream input) throws IOException {
        try {
            return new InternetHeaders(input);
        }
        catch (MessagingException e) {
            throw new IOException(e.getLocalizedMessage());
        }
    }

    protected void readResponse(InputStream in, SOAPMessage message) throws IOException, SOAPFault, XMLStreamException {
        int index;
        XMLStreamReader xsr = XMLStreamFactory.createXMLStreamReader(in);
        String[] pathArray = new String[]{"/Envelope/Header", "/Envelope/Body", "/Envelope/Body/Fault"};
        PathIterator pathIterator = new PathIterator(xsr, pathArray);
        while ((index = pathIterator.moveToNextPath()) != -1) {
            switch (index) {
                case 0: {
                    IXMLHandler handler = message.getResponseHeaderHandler();
                    if (handler == null) break;
                    IsolatedXMLStreamReader isolatedReader = new IsolatedXMLStreamReader(pathIterator);
                    handler.handle(isolatedReader);
                    break;
                }
                case 1: {
                    if (1 != pathIterator.nextTag()) break;
                    if ("Fault".equals(pathIterator.getLocalName())) {
                        this.handleFault(message, pathIterator);
                        return;
                    }
                    IXMLHandler handler = message.getResponseBodyHandler();
                    if (handler == null) break;
                    IsolatedXMLStreamReader isolatedReader = new IsolatedXMLStreamReader(pathIterator);
                    handler.handle(isolatedReader);
                    break;
                }
                case 2: {
                    this.handleFault(message, pathIterator);
                    return;
                }
            }
        }
    }

    void handleFault(SOAPMessage message, PathIterator pathIterator) throws XMLStreamException, SOAPFault {
        int i;
        IXMLHandler handler = message.getResponseFaultHandler();
        if (handler != null) {
            IsolatedXMLStreamReader isolatedReader = new IsolatedXMLStreamReader(pathIterator);
            handler.handle(isolatedReader);
            return;
        }
        String faultCode = null;
        String faultString = null;
        String faultDetail = null;
        String[] faultElements = new String[]{"/Envelope/Body/Fault/faultcode", "/Envelope/Body/Fault/faultstring", "/Envelope/Body/Fault/faultdetail", "/Envelope/Body/Fault/detail"};
        while ((i = pathIterator.moveToNextPath(faultElements)) != -1) {
            switch (i) {
                case 0: {
                    faultCode = pathIterator.getElementText();
                    break;
                }
                case 1: {
                    faultString = pathIterator.getElementText();
                    break;
                }
                case 2: 
                case 3: {
                    StringWriter writer = new StringWriter();
                    StaxUtils.copyChildren(pathIterator, XMLStreamFactory.createXMLStreamWriter(writer));
                    faultDetail = writer.getBuffer().toString();
                }
            }
        }
        SOAPFault fault = new SOAPFault();
        fault.setFaultCode(new QName("", faultCode));
        fault.setFaultString(faultString);
        fault.setDetail(faultDetail);
        throw fault;
    }

    @Override
    public void disconnect() {
        this.m_connection.disconnect();
    }

    protected void writeRequest(SOAPMessage requestMsg, Writer output, boolean includeXmlProlog) throws IOException {
        if (this.trustedRequest) {
            this.writeTrustedRequest(requestMsg, output, includeXmlProlog);
        } else {
            this.writePlainRequest(requestMsg, output, includeXmlProlog);
        }
    }

    protected void writePlainRequest(SOAPMessage requestMsg, Writer output, boolean includeXmlProlog) throws IOException {
        if (includeXmlProlog) {
            output.write(XML_PROLOG);
        }
        output.write(SOAP_ENV_OPEN);
        output.write(SOAP_HEADER_OPEN);
        requestMsg.writeHeaders(output);
        output.write(SOAP_HEADER_CLOSE);
        output.write(SOAP_BODY_OPEN);
        requestMsg.writeBody(output);
        output.write(SOAP_BODY_CLOSE);
        output.write(SOAP_ENV_CLOSE);
        output.flush();
    }

    protected void writeTrustedRequest(SOAPMessage requestMsg, Writer output, boolean includeXmlProlog) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.writePlainRequest(requestMsg, new OutputStreamWriter((OutputStream)baos, "UTF-8"), includeXmlProlog);
        byte[] trustedRequest = this.signTrustedRequest(baos.toByteArray());
        output.write(new String(trustedRequest, "UTF-8"));
    }

    protected byte[] signTrustedRequest(byte[] requestBytes) throws IOException {
        try {
            log.debug("Signing trusted request as ", serviceID);
            return this.getCrypto().signTrustedRequest(requestBytes, serviceID);
        }
        catch (Exception x) {
            log.error("Exception signing trusted request: ", x);
            throw new IOException("Exception signing trusted request");
        }
    }

    protected void logRequest(SOAPMessage message) {
        if (log.isDebugEnabled()) {
            try {
                log.debug("SOAP Request: ", XmlUtils.prettyPrint(this.getAsString(message)));
            }
            catch (Exception e) {
                log.error("Error logging SOAP Request: ", e);
            }
        }
    }

    protected String getAsString(SOAPMessage message) throws Exception {
        StringWriter writer = new StringWriter();
        this.writeRequest(message, writer, true);
        writer.write("\n");
        writer.flush();
        return writer.toString();
    }

    private InputStream logResponse(InputStream input) throws IOException, XMLStreamException {
        byte[] response = this.getResponseBytes(input);
        log.debug("SOAP Response:\n", this.getResponseString(response));
        return new ByteArrayInputStream(response);
    }

    private byte[] getResponseBytes(InputStream input) throws IOException {
        ByteArrayOutputStream bio = new ByteArrayOutputStream();
        byte[] buf = new byte[4096];
        int bytesRead = input.read(buf, 0, 4096);
        while (bytesRead != -1) {
            bio.write(buf, 0, bytesRead);
            bytesRead = input.read(buf, 0, 4096);
        }
        return bio.toByteArray();
    }

    private String getResponseString(byte[] responseBytes) {
        String responseString = this.decodeResponse(responseBytes);
        try {
            return XmlUtils.prettyPrint(responseString);
        }
        catch (Exception e) {
            log.warn("Can't pretty-print response string. Logging original version.");
            return responseString;
        }
    }

    private String decodeResponse(byte[] responseBytes) {
        try {
            return new String(responseBytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.warn("Can't decode response string. Logging unencoded version.");
            return new String(responseBytes);
        }
    }

    public static void setLogPriority(Priority priority) {
        PogoLogger.getLoggerFor(SOAPConnectionImpl.class).setPriority(priority);
    }

    @Override
    public void doTrustedRequest() {
        this.trustedRequest = true;
    }

    public Crypto getCrypto() {
        if (this.crypto == null) {
            this.crypto = new CryptoFacility();
        }
        return this.crypto;
    }

    public void setCrypto(Crypto crypto) {
        this.crypto = crypto;
    }
}

