/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.stax.stream;

import com.cognos.pogo.util.PogoLogger;
import com.ctc.wstx.stax.WstxInputFactory;
import com.ctc.wstx.stax.WstxOutputFactory;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import javax.xml.stream.StreamFilter;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class XMLStreamFactory {
    private static final PogoLogger log = PogoLogger.getLogger();
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private static final boolean OPTIMIZED_FOR_SPEED = true;
    private static XMLOutputFactory outputFactory;
    private static XMLInputFactory inputFactory;

    public static XMLStreamWriter createXMLStreamWriter(Writer writer) throws XMLStreamException {
        return outputFactory.createXMLStreamWriter(writer);
    }

    public static XMLStreamReader createXMLStreamReader(Reader reader) throws XMLStreamException {
        return inputFactory.createXMLStreamReader(reader);
    }

    public static XMLStreamReader createXMLStreamReader(InputStream in) throws XMLStreamException {
        return XMLStreamFactory.createXMLStreamReader(in, "UTF-8");
    }

    public static XMLStreamReader createXMLStreamReader(InputStream in, String encoding) throws XMLStreamException {
        Reader reader = XMLStreamFactory.convertInputStreamToReader(in, encoding);
        return XMLStreamFactory.createXMLStreamReader(reader);
    }

    private static Reader convertInputStreamToReader(InputStream in, String encoding) throws XMLStreamException {
        try {
            return new InputStreamReader(in, encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new XMLStreamException("Can't convert input stream to a reader", e);
        }
    }

    public static XMLStreamWriter createXMLStreamWriter(OutputStream output) throws XMLStreamException {
        return outputFactory.createXMLStreamWriter(output);
    }

    public static XMLStreamReader createFilteredReader(XMLStreamReader xmlstreamreader, StreamFilter streamfilter) throws XMLStreamException {
        return inputFactory.createFilteredReader(xmlstreamreader, streamfilter);
    }

    public static XMLEventReader createXMLEventReader(InputStream input) throws XMLStreamException {
        return inputFactory.createXMLEventReader(input);
    }

    public static XMLEventWriter createXMLEventWriter(OutputStream output) throws XMLStreamException {
        return outputFactory.createXMLEventWriter(output);
    }

    public static XMLStreamReader createXMLStreamReader(String xml) throws XMLStreamException {
        StringReader reader = new StringReader(xml);
        BufferedReader bufferedReader = new BufferedReader(reader, 4096);
        return XMLStreamFactory.createXMLStreamReader(bufferedReader);
    }

    public static XMLInputFactory setInputFactoryForTesting(XMLInputFactory newInputFactory) {
        XMLInputFactory previousInputFactory = inputFactory;
        inputFactory = newInputFactory;
        return previousInputFactory;
    }

    static {
        try {
            outputFactory = new WstxOutputFactory();
            inputFactory = new WstxInputFactory();
            outputFactory.setProperty("com.ctc.wstx.outputValidateAttr", "false");
            outputFactory.setProperty("com.ctc.wstx.outputValidateContent", "false");
            outputFactory.setProperty("com.ctc.wstx.outputValidateNames", "false");
            outputFactory.setProperty("javax.xml.stream.isRepairingNamespaces", "true");
            inputFactory.setProperty("com.ctc.wstx.inputBufferLength", new Integer(8000));
            inputFactory.setProperty("com.ctc.wstx.minTextSegment", new Integer(16));
            inputFactory.setProperty("com.ctc.wstx.normalizeAttrValues", "false");
            inputFactory.setProperty("com.ctc.wstx.normalizeLFs", "true");
            inputFactory.setProperty("javax.xml.stream.isCoalescing", "false");
            inputFactory.setProperty("org.codehaus.stax2.preserveLocation", "false");
            inputFactory.setProperty("org.codehaus.stax2.reportPrologWhitespace", "true");
            inputFactory.setProperty("javax.xml.stream.supportDTD", "false");
        }
        catch (Exception e) {
            log.error("Failed to initialize XML factories", e);
        }
    }
}

