/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.stax.utils;

import com.cognos.pogo.stax.utils.StaxEntryLocalName;
import com.cognos.pogo.stax.utils.StaxUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public abstract class StaxItemArray
extends StaxEntryLocalName {
    private static final List<String> EMPTY_LIST = Collections.emptyList();
    protected List<String> items;
    private String enforcedType;

    public StaxItemArray() {
        this.items = EMPTY_LIST;
    }

    public StaxItemArray(StaxItemArray source) {
        this.items = this.cloneItemsList(source.items);
    }

    private List<String> cloneItemsList(List<String> items) {
        return items.isEmpty() ? EMPTY_LIST : new ArrayList<String>(items);
    }

    protected void createItemsList(int size) {
        this.items = new ArrayList<String>(size);
    }

    @Override
    public boolean isPresent() {
        return this.items != EMPTY_LIST;
    }

    @Override
    public void parse(XMLStreamReader xsr, String arrayName) throws XMLStreamException {
        this.createItemsList(StaxItemArray.parseArraySize(xsr));
        if (this.parseFirstItem(xsr, arrayName)) {
            super.parse(xsr, arrayName);
        }
    }

    private boolean parseFirstItem(XMLStreamReader xsr, String arrayName) throws XMLStreamException {
        if (StaxUtils.moveToNextElementWithinParent(arrayName, xsr)) {
            this.setEntryLocalName(xsr.getLocalName());
            this.parseElement(xsr, null);
            return true;
        }
        return false;
    }

    @Override
    protected void parseElement(XMLStreamReader xsr, String ignore) throws XMLStreamException {
        boolean hasValidTypeAttribute = this.hasValidTypeAttribute(xsr);
        String itemText = xsr.getElementText();
        if (hasValidTypeAttribute) {
            this.add(itemText);
        }
    }

    private boolean hasValidTypeAttribute(XMLStreamReader xsr) {
        return this.enforcedType == null || this.hasEnforcedType(xsr);
    }

    private boolean hasEnforcedType(XMLStreamReader xsr) {
        int attributeCount = xsr.getAttributeCount();
        for (int i = 0; i < attributeCount; ++i) {
            if (!this.hasEnforcedType(xsr, i)) continue;
            return true;
        }
        return false;
    }

    private boolean hasEnforcedType(XMLStreamReader xsr, int i) {
        String attributeName = xsr.getAttributeName(i).getLocalPart();
        return "type".equalsIgnoreCase(attributeName) && xsr.getAttributeValue(i).contains(this.enforcedType);
    }

    protected void writeXML(String arrayName, String type, XMLStreamWriter xsw, boolean writeNamespace) throws XMLStreamException {
        this.writeXML(arrayName, "bus", type, xsw, writeNamespace);
    }

    protected void writeXML(String arrayName, String typeNSPrefix, String type, XMLStreamWriter xsw, boolean writeNamespace) throws XMLStreamException {
        StaxItemArray.writeStartArrayElement(arrayName, typeNSPrefix, type, this.size(), writeNamespace, xsw);
        for (String item : this.items) {
            StaxItemArray.writeElement(this.getEntryLocalName(), item, type, typeNSPrefix, xsw);
        }
        xsw.writeEndElement();
    }

    public int size() {
        return this.items.size();
    }

    @Override
    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    @Override
    public abstract boolean canParse(String var1);

    @Override
    public abstract void writeXML(XMLStreamWriter var1, boolean var2) throws XMLStreamException;

    public List<String> getItems() {
        return Collections.unmodifiableList(this.items);
    }

    public void add(String value) {
        if (!this.isPresent()) {
            this.createItemsList(20);
        }
        this.items.add(value);
    }

    public boolean hasItem(String item) {
        return this.items.contains(item);
    }

    protected void enforceTypeChecking(String enforcedType) {
        this.enforcedType = enforcedType;
    }
}

