/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.stax.utils;

import com.cognos.pogo.stax.utils.StaxEntryLocalName;
import com.cognos.pogo.stax.utils.StaxMapEntry;
import com.cognos.pogo.stax.utils.StaxUtils;
import java.util.Collection;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public abstract class StaxVars
extends StaxEntryLocalName {
    protected static final int DEFAULT_SIZE = 10;

    protected abstract StaxMapEntry createMapEntry();

    protected abstract StaxMapEntry cloneMapEntry(StaxMapEntry var1);

    protected abstract void createCollection(int var1);

    protected abstract void saveEntry(StaxMapEntry var1);

    protected abstract int size();

    protected abstract Collection<StaxMapEntry> getValues();

    @Override
    public void parse(XMLStreamReader xsr, String entryName) throws XMLStreamException {
        this.createCollection(StaxVars.parseArraySize(xsr));
        if (this.parseFirstItem(xsr, entryName)) {
            super.parse(xsr, entryName);
        }
    }

    private boolean parseFirstItem(XMLStreamReader xsr, String entryName) throws XMLStreamException {
        if (StaxUtils.moveToNextElementWithinParent(entryName, xsr)) {
            this.setEntryLocalName(xsr.getLocalName());
            this.parseElement(xsr, null);
            return true;
        }
        return false;
    }

    @Override
    protected void parseElement(XMLStreamReader xsr, String ignore) throws XMLStreamException {
        StaxMapEntry entry = this.createMapEntry();
        entry.parse(xsr, this.getEntryLocalName());
        if (entry.getName() != null) {
            this.saveEntry(entry);
        }
    }

    protected void writeXML(XMLStreamWriter xsw, String type, boolean writeNamespace) throws XMLStreamException {
        String itemType = this.convertPluralToSingular(type);
        StaxVars.writeStartArrayElement(type, itemType, this.size(), writeNamespace, xsw);
        this.writeAllEntries(xsw, itemType);
        xsw.writeEndElement();
        xsw.flush();
    }

    protected void writeAllEntries(XMLStreamWriter xsw, String itemType) throws XMLStreamException {
        for (StaxMapEntry entry : this.getValues()) {
            this.writeEntry(xsw, itemType, entry);
        }
    }

    protected void writeEntry(XMLStreamWriter xsw, String itemType, StaxMapEntry entry) throws XMLStreamException {
        StaxVars.writeStartBusElement(this.getEntryLocalName(), itemType, false, xsw);
        StaxVars.writeStringElement("name", entry.getName(), xsw);
        entry.writeXML(xsw);
        xsw.writeEndElement();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }
}

