/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.transport;

import com.cognos.p2plb.model.NodeID;
import com.cognos.pogo.contentmanager.PogoConnectionFactory;
import com.cognos.pogo.http.ConnectionPool;
import com.cognos.pogo.http.ServerConnection;
import com.cognos.pogo.http.SimpleHttpConnection;
import com.cognos.pogo.http.StandaloneServerConnection;
import com.cognos.pogo.http.inprocess.LocalServerConnection;
import com.cognos.pogo.http.inprocess.config.LocalServerConnectionConfig;
import com.cognos.pogo.transport.RemoteDispatcherPool;
import com.cognos.pogo.util.CAMUtils;
import com.cognos.pogo.util.PogoLogger;
import java.lang.reflect.Constructor;
import org.apache.commons.lang.StringUtils;

public class DispatcherConnectionManager {
    private static final PogoLogger log = PogoLogger.getLogger();
    private static ConnectionPool dispatcherPool;
    private static ServerConnection serverConnectionForTesting;
    private static SimpleHttpConnection httpConnectionForTesting;
    private static RemoteDispatcherPool remoteDispatcherPool;

    DispatcherConnectionManager() {
        this.createConnetionPool();
        this.loadTestConnections();
    }

    private void createConnetionPool() {
        NodeID myID = NodeID.getSelf();
        if (myID != null) {
            dispatcherPool = new ConnectionPool(myID.getHost(), myID.getPort(), "https".equals(myID.getProtocol()), 0);
        }
    }

    private void loadTestConnections() {
        this.loadServerConnectionForTesting();
        this.loadHttpConnectionForTesting();
    }

    private void loadServerConnectionForTesting() {
        String classname = System.getProperty("DispatcherConnectionManager.serverConnectionForTesting");
        if (StringUtils.isNotEmpty((String)classname)) {
            this.loadServerConnectionForTesting(classname);
        }
    }

    private void loadServerConnectionForTesting(String classname) {
        try {
            Object connection = Class.forName(classname).newInstance();
            DispatcherConnectionManager.setConnectionForTesting((ServerConnection)connection);
        }
        catch (Exception x) {
            log.error("Cannot create connection for testing " + classname, x);
        }
    }

    private void loadHttpConnectionForTesting() {
        String classname = System.getProperty("DispatcherConnectionManager.httpConnectionForTesting");
        if (StringUtils.isNotEmpty((String)classname)) {
            this.loadHttpConnectionForTesting(classname);
        }
    }

    private void loadHttpConnectionForTesting(String classname) {
        try {
            Object connection = Class.forName(classname).newInstance();
            DispatcherConnectionManager.setHttpConnectionForTesting((SimpleHttpConnection)connection);
        }
        catch (Exception x) {
            log.error("Cannot create connection for testing " + classname, x);
        }
    }

    private static SimpleHttpConnection reloadHttpConnectionForTesting(String uri) throws Exception {
        try {
            SimpleHttpConnection newConnection = DispatcherConnectionManager.recreateConnectionFor(uri);
            DispatcherConnectionManager.setHttpConnectionForTesting(newConnection);
            return newConnection;
        }
        catch (Exception x) {
            log.error("Cannot reload http connection for testing ", x);
            throw x;
        }
    }

    private static SimpleHttpConnection recreateConnectionFor(String newURI) throws Exception {
        SimpleHttpConnection currentConnection = DispatcherConnectionManager.getHttpConnectionForTesting();
        Constructor<?> constructor = currentConnection.getClass().getDeclaredConstructor(String.class, CAMUtils.class);
        Object newConnection = constructor.newInstance(newURI, currentConnection.getCamUtils());
        return (SimpleHttpConnection)newConnection;
    }

    public static ServerConnection getLocalDispatcherConnection() {
        if (DispatcherConnectionManager.hasServerConnectionForTesting()) {
            return DispatcherConnectionManager.getConnectionForTesting();
        }
        if (LocalServerConnectionConfig.isEnabled()) {
            return DispatcherConnectionManager.getLocalServerConnection();
        }
        return DispatcherConnectionManager.getRegularServerConnection();
    }

    private static ServerConnection getLocalServerConnection() {
        log.debug("Using local server connection");
        return new LocalServerConnection();
    }

    private static ServerConnection getRegularServerConnection() {
        log.debug("Using regular server connection");
        return dispatcherPool.getConnection();
    }

    public static ServerConnection getContentManagerConnection() {
        if (DispatcherConnectionManager.hasServerConnectionForTesting()) {
            return DispatcherConnectionManager.getConnectionForTesting();
        }
        return PogoConnectionFactory.getInstance().getContentManagerConnection();
    }

    public static ServerConnection getStandaloneConnection(String host, int port, boolean requiresSSL) {
        if (DispatcherConnectionManager.hasServerConnectionForTesting()) {
            return DispatcherConnectionManager.getConnectionForTesting();
        }
        return new StandaloneServerConnection(host, port, requiresSSL);
    }

    public static void setConnectionForTesting(ServerConnection serverConnection) {
        log.info("Using a static server connection for testing: ", serverConnection);
        serverConnectionForTesting = serverConnection;
    }

    private static ServerConnection getConnectionForTesting() {
        return serverConnectionForTesting;
    }

    private static boolean hasServerConnectionForTesting() {
        return serverConnectionForTesting != null;
    }

    public static ServerConnection getRemoteDispatcherConnection(NodeID nodeID) {
        log.debug("Creating connection to ", nodeID);
        return remoteDispatcherPool != null ? remoteDispatcherPool.getConnection(nodeID) : null;
    }

    public static void registerRemoteDispatcherPool(RemoteDispatcherPool remoteDispatcherPool) {
        DispatcherConnectionManager.remoteDispatcherPool = remoteDispatcherPool;
    }

    public static SimpleHttpConnection createSimpleHttpConnection(String uri) throws Exception {
        if (DispatcherConnectionManager.hasHttpConnectionForTesting()) {
            return DispatcherConnectionManager.reloadHttpConnectionForTesting(uri);
        }
        return SimpleHttpConnection.getNewConnection(uri);
    }

    private static boolean hasHttpConnectionForTesting() {
        return httpConnectionForTesting != null;
    }

    public static SimpleHttpConnection getHttpConnectionForTesting() {
        return httpConnectionForTesting;
    }

    public static void setHttpConnectionForTesting(SimpleHttpConnection httpConnection) {
        log.info("Using a static http connection for testing: ", httpConnection);
        httpConnectionForTesting = httpConnection;
    }
}

