/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.transport;

import com.cognos.pogo.transport.MethodDispatcherCacheExtractor;
import com.cognos.pogo.transport.ParamBucket;
import com.cognos.pogo.util.CAMUtils;
import com.cognos.pogo.util.PogoLogger;

public class MethodDispatcherCacheExtractorParams
extends MethodDispatcherCacheExtractor {
    private static final PogoLogger log = PogoLogger.getLogger();

    public MethodDispatcherCacheExtractorParams(ParamBucket paramBucket, CAMUtils cam) {
        super(cam);
        this.handleDCParameters(paramBucket);
    }

    public MethodDispatcherCacheExtractorParams(ParamBucket paramBucket) {
        this(paramBucket, null);
    }

    private void handleDCParameters(ParamBucket aParamBucket) {
        this.dc_web64filename = aParamBucket.getValue("f");
        this.dc_web64fileHmac = aParamBucket.getValue("k");
        this.dc_web64fileuserHmac = aParamBucket.getValue("s");
        this.dc_dispGUID = aParamBucket.getValue("did");
        this.dc_rsvpPID = aParamBucket.getValue("rsid");
    }

    @Override
    public boolean validateURLValues(CAMUtils cam, String base64usid) throws Exception {
        String fileValue = this.getFileName();
        byte[] kValue = this.getHmacFileName();
        byte[] sValue = this.getHmacFileUserId();
        if (fileValue == null || kValue == null || sValue == null) {
            throw new Exception("Failed to read dispatcher cache URL values");
        }
        if (cam.verifyCryptoHMAC(kValue, fileValue)) {
            if (cam.verifyCryptoHMAC(sValue, fileValue + base64usid)) {
                return true;
            }
            log.error("verifyCryptoHMAC(sValue, fileValue + base64usid) failed");
            return false;
        }
        log.error("verifyCryptoHMAC(kValue, fileValue) failed");
        return false;
    }
}

