/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.transport;

import javax.servlet.http.HttpServletRequest;

public class MethodParameterExtractor {
    private static final String METHOD_START1 = "&SM=";
    private static final String METHOD_START2 = "SM=";
    private static final String METHOD_END = "&EM=";
    private String methodParams;
    private String otherParams;

    public MethodParameterExtractor(HttpServletRequest httpRequest) throws Exception {
        String queryString = this.normalizeNewlines(httpRequest.getQueryString());
        if (queryString == null) {
            this.methodParams = "";
            this.otherParams = "";
            return;
        }
        int methodStartPos = -1;
        methodStartPos = queryString.startsWith(METHOD_START2) ? 0 : queryString.indexOf(METHOD_START1);
        if (methodStartPos == -1) {
            this.otherParams = queryString;
            this.methodParams = "";
            return;
        }
        int methodEndPos = queryString.indexOf(METHOD_END, methodStartPos);
        if (methodEndPos == -1) {
            this.otherParams = queryString;
            this.methodParams = "";
            return;
        }
        int endPos = methodEndPos + METHOD_END.length();
        this.methodParams = queryString.charAt(methodStartPos) == '&' ? queryString.substring(methodStartPos + 1, endPos) : queryString.substring(methodStartPos, endPos);
        if ((endPos = queryString.indexOf(38, endPos)) == -1) {
            endPos = queryString.length();
        }
        this.otherParams = methodStartPos == 0 ? queryString.substring(endPos, queryString.length()) : queryString.substring(0, methodStartPos) + queryString.substring(endPos, queryString.length());
    }

    private String normalizeNewlines(String queryString) {
        int crnlpos;
        if (queryString == null) {
            return null;
        }
        StringBuffer cleaned = new StringBuffer(queryString.length());
        int pos = 0;
        while ((crnlpos = queryString.indexOf("%0D", pos)) > 0) {
            cleaned.append(queryString.substring(pos, crnlpos));
            cleaned.append("%0A");
            if (queryString.substring(crnlpos + 3, crnlpos + 6).equals("%0A")) {
                pos = crnlpos + 6;
                continue;
            }
            pos = crnlpos + 3;
        }
        cleaned.append(queryString.substring(pos));
        return cleaned.toString();
    }

    public String getMethodParams() {
        return this.methodParams;
    }

    public String getOtherParams() {
        return this.otherParams;
    }
}

