/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.transport;

import com.cognos.i18n.ToolkitResources;
import com.cognos.indications.LogIPFControl;
import com.cognos.p2pd.httptools.MimeHeaderUtil;
import com.cognos.p2pd.util.PropertyInserter;
import com.cognos.p2plb.clerver.LoadBalanceHandler;
import com.cognos.p2plb.clerver.balancer.RequestForwarder;
import com.cognos.p2plb.model.NodeID;
import com.cognos.pogo.auth.CheckForPassportIDhandler;
import com.cognos.pogo.config.ConfigurationImpl;
import com.cognos.pogo.config.XMLConfigurator;
import com.cognos.pogo.http.inprocess.LocalServletResponse;
import com.cognos.pogo.impl.CAFFactoryNoOpImpl;
import com.cognos.pogo.impl.MessageContextImpl;
import com.cognos.pogo.impl.PogoCleanupManager;
import com.cognos.pogo.impl.PogoEngineImpl;
import com.cognos.pogo.impl.PogoHttpServletRequestWrapper;
import com.cognos.pogo.impl.PogoResponder;
import com.cognos.pogo.impl.PogoSOAPAttachmentResponder;
import com.cognos.pogo.impl.PogoSOAPMessageResponder;
import com.cognos.pogo.logging.LoggingContext;
import com.cognos.pogo.logging.LoggingRealm;
import com.cognos.pogo.logging.LoggingRealmFactory;
import com.cognos.pogo.logging.SystemEventLogger;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.CAFConfigurationException;
import com.cognos.pogo.pdk.CAFFactory;
import com.cognos.pogo.pdk.CAFHandler;
import com.cognos.pogo.pdk.CAFRuntimeException;
import com.cognos.pogo.pdk.Handler;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoConfigException;
import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.pdk.Tracking;
import com.cognos.pogo.pdk.common.EnvelopeFactorySelector;
import com.cognos.pogo.pdk.performance.servlet.PerformanceIndicatorWrappedServlet;
import com.cognos.pogo.services.DispatcherServices;
import com.cognos.pogo.transport.DispatcherConnectionManager;
import com.cognos.pogo.transport.GenerateErrorPage;
import com.cognos.pogo.transport.HopCountChecker;
import com.cognos.pogo.transport.RequestProcessor;
import com.cognos.pogo.transport.RequestProcessorFactory;
import com.cognos.pogo.transport.ServletEngineContext;
import com.cognos.pogo.util.DefaultLocalSoapActions;
import com.cognos.pogo.util.PogoIPFLog;
import com.cognos.pogo.util.PogoLogger;
import com.cognos.pogo.util.StringUtils;
import com.cognos.pogo.util.threads.SafeThread;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import javax.mail.internet.InternetHeaders;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PogoServlet
extends PerformanceIndicatorWrappedServlet {
    private static final long serialVersionUID = 7092255286917818313L;
    private static final PogoLogger cat = PogoLogger.getLogger();
    private static final PogoLogger perf_cat = PogoLogger.getLoggerFor("perf." + PogoServlet.class.getName());
    private static final LoggingRealm loggingRealm = LoggingRealmFactory.getInstance("DISP");
    private PogoEngine pogo_engine;
    private PogoCleanupManager pogo_cleanup;
    public static Date starttime;
    private static String[][] extraHeaders;
    private CAFFactory aCAFFactory;
    private DispatcherConnectionManager connectionManager;
    private static PogoServlet servlet;
    private LoadBalanceHandler loadBalanceHandler;
    private HopCountChecker hopCountChecker;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.hopCountChecker = new HopCountChecker(config);
        this.exposeServletToJython();
        this.prepareExtraHeaderList();
        this.connectionManager = new DispatcherConnectionManager();
        try {
            this.pogo_cleanup = new PogoCleanupManager();
            this.configureServices(config);
            starttime = new Date();
        }
        catch (Exception x) {
            cat.fatalError("Pogo config error.", x);
            throw new ServletException("Pogo config error", (Throwable)x);
        }
        if (PogoServlet.isCafDisabled()) {
            this.setCafFactory(new CAFFactoryNoOpImpl());
            cat.info("Application firewall disabled by system property.");
            return;
        }
        try {
            Class<?> CAFFactoryClass = Class.forName("com.cognos.caf.CAFFactoryImpl");
            this.setCafFactory((CAFFactory)CAFFactoryClass.newInstance());
            this.aCAFFactory.configure();
            config.getServletContext().setAttribute("caf.CAFFactory", (Object)this.aCAFFactory);
        }
        catch (CAFConfigurationException cafException) {
            cat.error("CAFFactory threw exception while being configured.", cafException);
        }
        catch (Exception e) {
            this.setCafFactory(new CAFFactoryNoOpImpl());
            cat.error("CAFFactory implementation not found.  Disabling the firewall.", e);
        }
    }

    void setCafFactory(CAFFactory cafFactory) {
        this.aCAFFactory = cafFactory;
    }

    public static boolean isCafDisabled() {
        return Boolean.valueOf(System.getProperty("caf.disable"));
    }

    private void exposeServletToJython() {
        servlet = this;
    }

    public static PogoServlet getInstance() {
        if (servlet == null) {
            servlet = new PogoServlet();
            ServletEngineContext context = new ServletEngineContext(null);
            DispatcherServices dispatcherServices = new DispatcherServices();
            PogoServlet.servlet.pogo_engine = new PogoEngineImpl(context, dispatcherServices);
        }
        return servlet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void prepareExtraHeaderList() {
        InputStream is;
        Properties extra;
        block14: {
            extra = new Properties();
            is = null;
            is = this.getServletContext().getResourceAsStream("/WEB-INF/extraheaders.properties");
            if (is != null) break block14;
            cat.error("can't find resource extraheaders.properties");
            extraHeaders = new String[0][2];
            if (is == null) return;
            try {
                is.close();
                return;
            }
            catch (IOException e) {
                cat.error("failed to close stream for com/cognos/pogo/transport/extraheaders.properties.");
            }
            return;
        }
        extra.load(is);
        extraHeaders = new String[extra.size()][2];
        int i = 0;
        Enumeration<Object> ekeys = extra.keys();
        while (ekeys.hasMoreElements()) {
            String headerName = (String)ekeys.nextElement();
            String envVarName = extra.getProperty(headerName);
            PogoServlet.extraHeaders[i][0] = headerName;
            PogoServlet.extraHeaders[i][1] = envVarName;
            cat.debug("Added extra http header info, will copy header ", headerName, " to the BIBus env vars as ", envVarName);
            ++i;
        }
        if (is == null) return;
        try {
            is.close();
            return;
        }
        catch (IOException e) {
            cat.error("failed to close stream for com/cognos/pogo/transport/extraheaders.properties.");
        }
        return;
        catch (IOException e) {
            try {
                cat.error("failed to load com/cognos/pogo/transport/extraheaders.properties");
                if (is == null) return;
            }
            catch (Throwable throwable) {
                if (is == null) throw throwable;
                try {
                    is.close();
                    throw throwable;
                }
                catch (IOException e2) {
                    cat.error("failed to close stream for com/cognos/pogo/transport/extraheaders.properties.");
                }
                throw throwable;
            }
            try {
                is.close();
                return;
            }
            catch (IOException e3) {
                cat.error("failed to close stream for com/cognos/pogo/transport/extraheaders.properties.");
            }
            return;
        }
    }

    private void configureServices(ServletConfig config) throws PogoConfigException {
        PogoStartup startup = new PogoStartup(config);
        SafeThread startupThread = new SafeThread(startup);
        cat.debug("Starting startup thread: ", startupThread);
        startupThread.start();
    }

    public void destroy() {
        SystemEventLogger.logSystemShutdown();
        LogIPFControl.openFeedbackLoop();
        LoggingContext loggingContext = loggingRealm.getLoggingContext();
        loggingContext.setSessionID("shutdown");
        loggingContext.setStepID("0");
        loggingContext.setRequestID("na");
        loggingContext.setSubRequestID("na");
        this.pogo_cleanup.cleanupTimedTask();
        this.pogo_cleanup.shutdownThreads();
        try {
            this.pogo_engine.getDispatcherServices().stop();
            this.pogo_engine.getDispatcherServices().dispose();
        }
        catch (RuntimeException e) {
            System.out.println("RuntimeException while stopping services!");
            e.printStackTrace();
        }
        this.aCAFFactory.terminate();
        cat.debug("finished cleanup in PogoServlet");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processRequest(HttpServletRequest request, HttpServletResponse response, boolean doGet) throws ServletException, IOException {
        perf_cat.info("--Start-- Received Request");
        long arrival_time = System.currentTimeMillis();
        this.logServletRequest(request);
        MessageContextImpl mc = new MessageContextImpl();
        this.copyRequestHeaders(mc, request);
        try {
            if (this.pogo_engine == null || !this.pogo_engine.getReadyToProcess()) {
                this.setupForErrorPage(request, response, mc, doGet);
                this.redirectToNotReadyPage(mc);
            } else {
                boolean isRequestSupportedLocally = this.isRequestSupportedLocally(request, mc);
                cat.debug("isRequestSupportedLocally: ", isRequestSupportedLocally);
                mc.setProperty("soapActionIsNotSupportedLocally", String.valueOf(!isRequestSupportedLocally));
                CAFHandler cafHandler = this.aCAFFactory.createCAFHandler(doGet, request.getServletPath());
                mc.setArrivalTime(arrival_time);
                mc.setProperty("caf.CAFHandler", cafHandler);
                String pathInfo = request.getPathInfo();
                if (isRequestSupportedLocally) {
                    pathInfo = cafHandler.updatePathInfo(pathInfo);
                }
                pathInfo = this.resolvePathInfo(pathInfo, request, mc);
                cat.debug("PATH_INFO set to: ", pathInfo);
                mc.setProperty("path_info", pathInfo);
                this.receiveRequest(request, mc, doGet);
                mc.setProperty("servlet.requestURI", request.getRequestURI());
                mc.setProperty("servlet.response", response);
                this.pogo_engine.service(mc);
                this.updateResponse(response, mc);
                this.logRequestTime(mc);
                perf_cat.info("--End-- Completed Request");
            }
        }
        catch (CAFRuntimeException cafRuntime) {
            PogoIPFLog.getInstance();
            try {
                String scriptName = request.getHeader("Original-Script-Name");
                if (scriptName == null || scriptName.length() == 0) {
                    scriptName = request.getContextPath() + request.getServletPath();
                }
                String webContentRoot = RequestProcessor.deduceWebContentRoot(scriptName);
                mc.setProperty("WEB_CONTENT_ROOT", webContentRoot);
                this.generateCAFErrorResponse(cafRuntime, request, response, mc, doGet);
            }
            catch (PogoException pogoException) {
                cat.error("Failed to render CAF error page", pogoException);
                throw new ServletException((Throwable)pogoException);
            }
        }
        catch (Exception x) {
            cat.error("error occured processing pogo request", x);
            this.setupForErrorPage(request, response, mc, doGet);
            GenerateErrorPage errorPage = new GenerateErrorPage("NOT_FOUND");
            try {
                errorPage.invokeImpl(mc);
            }
            catch (PogoException pogoException) {
                cat.error("Failed to render error page", pogoException);
                throw new ServletException((Throwable)pogoException);
            }
        }
        finally {
            loggingRealm.clearLoggingContext();
        }
    }

    private void logServletRequest(HttpServletRequest request) {
        if (!cat.isDebugEnabled() || request == null) {
            return;
        }
        cat.debug("New servlet request (", request.getClass().getSimpleName(), "):");
        cat.debug("   CharacterEncoding: ", request.getCharacterEncoding());
        cat.debug("   ContentLength: ", request.getContentLength());
        cat.debug("   ContentType: ", request.getContentType());
        cat.debug("   Protocol: ", request.getProtocol());
        cat.debug("   Scheme: ", request.getScheme());
        cat.debug("   ServerName: ", request.getServerName());
        cat.debug("   ServerPort: ", request.getServerPort());
        cat.debug("   RemoteAddr: ", request.getRemoteAddr());
        cat.debug("   RemoteHost: ", request.getRemoteHost());
        cat.debug("   Locale: ", request.getLocale());
        cat.debug("   isSecure: ", request.isSecure());
        cat.debug("   RemotePort: ", request.getRemotePort());
        cat.debug("   LocalName: ", request.getLocalName());
        cat.debug("   LocalAddr: ", request.getLocalAddr());
        cat.debug("   LocalPort: ", request.getLocalPort());
        cat.debug("   AuthType: ", request.getAuthType());
        cat.debug("   Method: ", request.getMethod());
        cat.debug("   PathInfo: ", request.getPathInfo());
        cat.debug("   PathTranslated: ", request.getPathTranslated());
        cat.debug("   ContextPath: ", request.getContextPath());
        cat.debug("   QueryString: ", request.getQueryString());
        cat.debug("   RemoteUser: ", request.getRemoteUser());
        cat.debug("   RequestedSessionId: ", request.getRequestedSessionId());
        cat.debug("   RequestURI: ", request.getRequestURI());
        cat.debug("   RequestURL: ", request.getRequestURL());
        cat.debug("   ServletPath: ", request.getServletPath());
        cat.debug("   isRequestedSessionIdValid: ", request.isRequestedSessionIdValid());
        cat.debug("   isRequestedSessionIdFromCookie: ", request.isRequestedSessionIdFromCookie());
        cat.debug("   isRequestedSessionIdFromURL: ", request.isRequestedSessionIdFromURL());
        this.logRequestAttributes(request);
        this.logRequestCookies(request);
        this.logRequestHeaders(request);
    }

    private void logRequestAttributes(HttpServletRequest request) {
        cat.debug("   Attributes: ");
        Enumeration attributeNames = request.getAttributeNames();
        if (attributeNames != null) {
            while (attributeNames.hasMoreElements()) {
                this.logRequestAttribute(request, attributeNames.nextElement());
            }
        }
    }

    private void logRequestAttribute(HttpServletRequest request, Object attributeName) {
        cat.debug("      ", attributeName, " = ", request.getAttribute(attributeName.toString()));
    }

    private void logRequestCookies(HttpServletRequest request) {
        cat.debug("   Cookies: ");
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                cat.debug("      ", cookie.getName(), "=", cookie.getValue());
            }
        }
    }

    private void logRequestHeaders(HttpServletRequest request) {
        cat.debug("   Headers: ");
        Enumeration headerNames = request.getHeaderNames();
        if (headerNames != null) {
            while (headerNames.hasMoreElements()) {
                this.logRequestHeader(request, headerNames.nextElement());
            }
        }
    }

    private void logRequestHeader(HttpServletRequest request, Object headerName) {
        Enumeration values = request.getHeaders(headerName.toString());
        if (values != null) {
            while (values.hasMoreElements()) {
                cat.debug("      ", headerName, " = ", values.nextElement());
            }
        }
    }

    private void updateResponse(HttpServletResponse response, MessageContext mc) {
        LocalServletResponse.saveMessageContext(response, mc);
    }

    protected String resolvePathInfo(String pathInfo, HttpServletRequest request, MessageContext mc) {
        String resolvedPathInfo = pathInfo;
        if (request == null || mc == null) {
            return resolvedPathInfo;
        }
        String value = PropertyInserter.getProperty("pathInfoChecking.enabled");
        if (value == null || !value.equalsIgnoreCase("false")) {
            String scriptName = request.getHeader("Original-Script-Name");
            cat.debug("resolvePathInfo() - Check path info and script name.");
            if (pathInfo != null && scriptName != null && pathInfo.startsWith(scriptName)) {
                resolvedPathInfo = pathInfo.substring(scriptName.length());
                if (resolvedPathInfo.isEmpty()) {
                    resolvedPathInfo = null;
                }
                mc.setProperty("pathInfoIsModified", Boolean.TRUE);
                cat.debug("Found path info begins with Original-Script-Name, set path info to ", pathInfo);
            }
        }
        return resolvedPathInfo;
    }

    private RequestProcessor createRequestProcessor(HttpServletRequest request, boolean doGet) {
        String content_type = request.getContentType();
        return RequestProcessorFactory.createRequestProcessor(doGet, content_type, extraHeaders);
    }

    private boolean isRequestSupportedLocally(HttpServletRequest request, MessageContext mc) {
        String soapAction = this.getSoapAction(request);
        return soapAction == null || this.isSoapActionADefaultSoapAction(soapAction) || this.isSoapActionSupportedLocally(soapAction);
    }

    protected boolean isSoapActionADefaultSoapAction(String soapAction) {
        return DefaultLocalSoapActions.contains(soapAction);
    }

    private String getSoapAction(HttpServletRequest request) {
        return request.getHeader("SOAPAction");
    }

    private boolean isSoapActionSupportedLocally(String soapAction) {
        LoadBalanceHandler loadBalanceHandler = this.getLoadBalanceHandler();
        return loadBalanceHandler == null || loadBalanceHandler.isSoapActionSupported(soapAction, NodeID.getSelf());
    }

    protected LoadBalanceHandler getLoadBalanceHandler() {
        if (this.loadBalanceHandler == null) {
            this.loadBalanceHandler = (LoadBalanceHandler)PogoServlet.getHandler("bal.lb_forwarder");
        }
        return this.loadBalanceHandler;
    }

    private void generateCAFErrorResponse(CAFRuntimeException cafRuntime, HttpServletRequest request, HttpServletResponse response, MessageContext mc, boolean doGet) throws PogoException {
        GenerateErrorPage errorPage = new GenerateErrorPage(cafRuntime.getMessageID());
        String detailMessage = cafRuntime.getDetailMessage();
        if (detailMessage != null && !"".equals(detailMessage)) {
            errorPage.setErrorDetail(cafRuntime.getDetailMessage());
        }
        errorPage.setContactAdmin("CAF_ERRPAGE_CONTACTADMIN");
        this.setupForErrorPage(request, response, mc, doGet);
        errorPage.invokeImpl(mc);
    }

    private void setupForErrorPage(HttpServletRequest request, HttpServletResponse response, MessageContext mc, boolean doGet) {
        PogoResponder responder;
        BIBusEnvelope requestEnvelope = (BIBusEnvelope)mc.getProperty("request.envelope");
        if (requestEnvelope == null) {
            requestEnvelope = new BIBusEnvelope();
            mc.setProperty("request.envelope", requestEnvelope);
        }
        if ((responder = (PogoResponder)mc.getProperty("pogo.responder")) == null) {
            String contentType = request.getContentType();
            if (doGet || contentType == null) {
                requestEnvelope.setDispatcherTransport("html", "true");
                responder = new PogoSOAPAttachmentResponder();
            } else if (contentType.startsWith("text/xml") || contentType.startsWith("multipart")) {
                requestEnvelope.setDispatcherTransport("html", "false");
                responder = new PogoSOAPMessageResponder();
            } else {
                requestEnvelope.setDispatcherTransport("html", "true");
                responder = new PogoSOAPAttachmentResponder();
            }
            mc.setProperty("pogo.responder", responder);
        }
        if (mc.getProperty("servlet.response") == null) {
            mc.setProperty("servlet.response", response);
        }
        if (mc.getProperty("locale") == null) {
            mc.setProperty("locale", PogoServlet.getUserLocale(request));
        }
        if (mc.getProperty("WEB_CONTENT_ROOT") == null) {
            String scriptName = request.getHeader("Original-Script-Name");
            if (scriptName != null && scriptName.length() > 0) {
                String webContentRoot = RequestProcessor.deduceWebContentRoot(scriptName);
                mc.setProperty("WEB_CONTENT_ROOT", webContentRoot);
            } else {
                mc.setProperty("WEB_CONTENT_ROOT", "..");
            }
        }
    }

    private void redirectToNotReadyPage(MessageContext mc) throws IOException, PogoException {
        GenerateErrorPage errorPage = new GenerateErrorPage("DISPATCHER_NOT_YET");
        errorPage.invokeImpl(mc);
    }

    private void logRequestTime(MessageContext mc) {
        long departure_time = System.currentTimeMillis();
        long arrival_time = mc.getArrivalTime();
        PogoIPFLog.getInstance().logRequestTime(mc, departure_time - arrival_time);
    }

    public void receiveRequest(HttpServletRequest request, MessageContext mc, boolean doGet) throws Exception {
        Locale userLocale = PogoServlet.getUserLocale(request);
        mc.setProperty("locale", userLocale);
        request.setAttribute("tc4", (Object)Boolean.TRUE);
        String soap_action = this.getSoapAction((HttpServletRequest)request);
        if (soap_action != null) {
            cat.info("Received request for SOAPACTION ", soap_action);
        }
        boolean soapActionIsSupportedLocally = !"true".equals(mc.getProperty("soapActionIsNotSupportedLocally"));
        RequestProcessor requestProcessor = this.createRequestProcessor((HttpServletRequest)request, doGet);
        CAFHandler cafHandler = (CAFHandler)mc.getProperty("caf.CAFHandler");
        String queryString = requestProcessor.getQueryString((HttpServletRequest)request);
        if (soapActionIsSupportedLocally) {
            queryString = cafHandler.updateQueryString(queryString);
        }
        String formRequestString = requestProcessor.getFormRequestBody((HttpServletRequest)request, queryString);
        String pathInfo = mc.getStrProperty("path_info");
        Boolean pathInfoModified = (Boolean)mc.getProperty("pathInfoIsModified");
        request = new PogoHttpServletRequestWrapper((HttpServletRequest)request, formRequestString, pathInfo, userLocale, pathInfoModified == null ? false : pathInfoModified);
        mc.setProperty("http_servlet_request", request);
        this.selectEnvelopeFactory(mc, requestProcessor.getAction((HttpServletRequest)request, mc));
        BIBusEnvelope request_env = (BIBusEnvelope)requestProcessor.createRequestEnvelope((HttpServletRequest)request, mc);
        String webContentRoot = request_env.getEnvironmentValue("WEB_CONTENT_ROOT");
        if (webContentRoot == null) {
            webContentRoot = "..";
        }
        mc.setProperty("WEB_CONTENT_ROOT", webContentRoot);
        soap_action = requestProcessor.getSOAPAction(soap_action);
        cafHandler.setAction(soap_action);
        boolean isXMLRequest = requestProcessor.isXMLRequest();
        if (soapActionIsSupportedLocally) {
            cafHandler.updateSOAPEnvelope(request_env, isXMLRequest);
        }
        long hopCount = request_env.getBiBusHeader().getTracking().incrementHopCount();
        this.hopCountChecker.checkHopCount(hopCount, request_env);
        this.getDispatcherTransportValues(mc, request_env);
        boolean preserveReqId = soap_action != null && soap_action.equals(RequestForwarder.SOAP_ACTION);
        String passportid = CheckForPassportIDhandler.checkAuthenticated(request_env);
        String requestID = Tracking.getInstance().createOrPreserveRequestContext(request_env, passportid, preserveReqId);
        mc.setProperty("requestID", requestID);
        CheckForPassportIDhandler.copyClientTokens(request_env);
        loggingRealm.setLoggingContext(new LoggingContext(requestID, hopCount));
        mc.setProperty("pogo.responder", requestProcessor.createPogoResponder());
        mc.setProperty("request.envelope", request_env);
        mc.setProperty("request.soapaction", StringUtils.stripQuotes(soap_action));
        cat.debug("Dispatcher received the SOAP request: ", request_env);
        String acceptEncoding = request.getHeader("Accept-Encoding");
        if (acceptEncoding != null && acceptEncoding.toLowerCase().indexOf("gzip") != -1) {
            mc.setProperty("clientUnderstandsGZip", Boolean.TRUE);
        }
    }

    private void copyRequestHeaders(MessageContext mc, HttpServletRequest request) {
        InternetHeaders request_headers = new InternetHeaders();
        MimeHeaderUtil.copyHeaders(request, request_headers);
        this.updateGatewayHeaderName(request_headers);
        mc.setProperty("request.headers", request_headers);
    }

    private void updateGatewayHeaderName(InternetHeaders request_headers) {
        String gatewayHeader = request_headers.getHeader("Cognos-Gateway", null);
        if (gatewayHeader != null) {
            request_headers.setHeader("Cognos-Gateway", "false");
        }
    }

    private void selectEnvelopeFactory(MessageContext mc, String soapAction) {
        soapAction = StringUtils.stripQuotes(soapAction);
        this.setEnvelopeFactory(mc, soapAction);
        this.setBodyHandlerFactory(mc, soapAction);
    }

    private void setEnvelopeFactory(MessageContext mc, String soapAction) {
        String parserType = this.getParserType(mc, soapAction);
        EnvelopeFactorySelector.setFactory(mc, parserType);
        cat.debug("Parser type [", parserType, "] specified to handle [", soapAction, "].");
    }

    private String getParserType(MessageContext mc, String soapAction) {
        String parserType = this.getParserType(mc);
        if (parserType == null) {
            parserType = this.getParserType(soapAction);
        }
        return parserType;
    }

    private String getParserType(MessageContext mc) {
        String originalSoapAction = this.getOriginalSoapAction(mc);
        return originalSoapAction != null ? this.getParserType(originalSoapAction) : null;
    }

    private String getOriginalSoapAction(MessageContext mc) {
        InternetHeaders requestHeaders = (InternetHeaders)mc.getProperty("request.headers");
        String[] originalSoapActions = requestHeaders != null ? requestHeaders.getHeader("OriginalSOAPAction") : null;
        return originalSoapActions != null && originalSoapActions.length > 0 ? originalSoapActions[0] : null;
    }

    private String getParserType(String soapAction) {
        return this.getDispatcherServices().getServiceParameter(soapAction, "parser");
    }

    private void setBodyHandlerFactory(MessageContext mc, String soapAction) {
        Handler bodyHandlerFactory = this.getBodyHandlerFactoryFor(soapAction);
        if (bodyHandlerFactory != null) {
            mc.setProperty("envelope.bodyHandlerFactory", bodyHandlerFactory);
        }
    }

    private Handler getBodyHandlerFactoryFor(String soapAction) {
        Handler handler;
        String handlerName = this.getDispatcherServices().getServiceParameter(soapAction, "bodyHandlerFactory");
        if (this.isBodyHandlerMisconfigured(handlerName, handler = PogoServlet.getHandler(handlerName))) {
            cat.warn("Cannot find [", handlerName, "] specified as a body handler factory for [", soapAction, "].");
        }
        return handler;
    }

    private boolean isBodyHandlerMisconfigured(String handlerName, Handler handler) {
        return handlerName != null && handler == null;
    }

    private void getDispatcherTransportValues(MessageContext mc, BIBusEnvelope request_env) {
        String frontValue = request_env.getDispatcherTransportValue("front");
        if (frontValue == null) {
            mc.setProperty("setCookieInThisDispatcher", Boolean.TRUE);
            request_env.setDispatcherTransport("front", "false");
            cat.debug("Setting cookies in this dispatcher because it is the 'front' one");
        } else {
            mc.setProperty("setCookieInThisDispatcher", Boolean.FALSE);
            cat.debug("Not setting cookies in this dispatcher because it is not the 'front' one");
        }
        String balancedValue = request_env.getDispatcherTransportValue("balancedRequest");
        if (balancedValue == null) {
            mc.setProperty("balancedRequest", Boolean.FALSE);
        } else {
            mc.setProperty("balancedRequest", Boolean.TRUE);
            request_env.removeDispatcherTransport("balancedRequest");
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response, true);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response, false);
    }

    public void doPatch(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response, false);
    }

    public void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response, false);
    }

    public void doDelete(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response, false);
    }

    protected void doHead(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setHeader("Allow", "GET, POST");
        resp.setStatus(405);
        resp.setContentLength(0);
    }

    public String getServletInfo() {
        return "IBM Cognos Dispatcher servlet";
    }

    private static Locale getUserLocale(HttpServletRequest request) {
        String acceptLang = request.getHeader("accept-language");
        if (acceptLang == null || acceptLang.length() == 0) {
            return Locale.getDefault();
        }
        String normalizedLocaleString = ToolkitResources.normalizeLocaleIdentifier((String)acceptLang);
        if (normalizedLocaleString == null || normalizedLocaleString.length() == 0) {
            return Locale.getDefault();
        }
        return StringUtils.getLocale(normalizedLocaleString);
    }

    PogoEngine getPogoEngine() {
        return this.pogo_engine;
    }

    DispatcherServices getDispatcherServices() {
        return this.getPogoEngine().getDispatcherServices();
    }

    protected DispatcherServices createDispatcherServices() {
        return new DispatcherServices();
    }

    public static Handler getHandler(String handlerName) {
        return PogoServlet.getInstance().getPogoEngine().lookupHandler(handlerName);
    }

    public static DispatcherServices getDispatcherServicesStatic() {
        return PogoServlet.getInstance().getDispatcherServices();
    }

    public static PogoEngine getPogoEngineStatic() {
        return PogoServlet.getInstance().getPogoEngine();
    }

    public class PogoStartup
    implements Runnable {
        private ServletConfig config;

        @Override
        public void run() {
            this.runWithDispatcherServices(PogoServlet.this.createDispatcherServices());
        }

        public void runWithDispatcherServices(DispatcherServices dispatcherServices) {
            LoggingContext loggingContext = loggingRealm.getLoggingContext();
            loggingContext.setSessionID("pogoStartup");
            loggingContext.setStepID("0");
            loggingContext.setRequestID("na");
            loggingContext.setSubRequestID("na");
            ServletEngineContext context = new ServletEngineContext(this.config.getServletContext());
            PogoServlet.this.pogo_engine = new PogoEngineImpl(context, dispatcherServices);
            XMLConfigurator configger = new XMLConfigurator();
            context.setAttribute("com.cognos.pogo.thePogoEngine", PogoServlet.this.pogo_engine);
            cat.debug("Loading services from services XML files");
            configger.configure(PogoServlet.this.pogo_engine, this.config);
            cat.debug("Initializing services");
            dispatcherServices.startInititalServices(PogoServlet.this.pogo_engine);
            if (Boolean.getBoolean("com.ibm.cognos.pogo.noCM")) {
                cat.debug("********************* NO CM *********************");
                dispatcherServices.compose(PogoServlet.this.pogo_engine);
                ConfigurationImpl configuration = new ConfigurationImpl();
                dispatcherServices.configure(configuration);
            }
        }

        public PogoStartup(ServletConfig config) {
            this.config = config;
        }
    }
}

