/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.transport;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.CAMFactory;
import com.cognos.cclcfgapi.base64;
import com.cognos.pogo.auth.CookieQuoter;
import com.cognos.pogo.handlers.util.AdvancedSettingParameterHandler;
import com.cognos.pogo.http.mime.CachedFileInputStream;
import com.cognos.pogo.http.mime.MIMEPartParser;
import com.cognos.pogo.impl.PogoResponder;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.SOAPEnvelope;
import com.cognos.pogo.pdk.common.BodyHandler;
import com.cognos.pogo.pdk.common.BodyHandlerFactory;
import com.cognos.pogo.pdk.common.EnvelopeFactory;
import com.cognos.pogo.pdk.common.EnvelopeFactorySelector;
import com.cognos.pogo.util.CAMUtils;
import com.cognos.pogo.util.PogoLogger;
import com.cognos.pogo.util.URLEncoderDecoder;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;

public abstract class RequestProcessor {
    protected static final PogoLogger cat = PogoLogger.getLogger();
    private static final String ASSWORD = "assword=";
    private static final String AZZWORD = "azzword=";
    private static final int EXTRA_HEADER_NAME = 0;
    private static final int ENVIRONMENT_VAR_NAME = 1;
    static final String COGNOS_GATEWAY_HEADER_NAME = "Cognos-Gateway";
    public static final String CHECK_CAPABILITIES_PROPERTY_NAME = "checkCapabilities";
    public static final String WEB_CONTENT_ROOT = "WEB_CONTENT_ROOT";
    private static CAMUtils camUtils = new CAMUtils();
    public static final String COPY_STREAM_PROPERTY = "MimeParseInputStream.CopyStream.enabled";
    public static final String COPY_STREAM_DEFAULT = "true";
    private static final String CACHE_LIMIT_PROPERTY = "MimeParseInputStream.CopyStream.limit";
    private static final String CACHE_LIMIT_DEFAULT = "1024";
    private static final long KB = 1024L;
    public static final String CA_ROUTING_HEADER = "X-CA-Routing";
    String[][] extraHeaders;

    protected RequestProcessor(String[][] extraHeaders) {
        this.extraHeaders = extraHeaders;
    }

    abstract SOAPEnvelope createRequestEnvelope(HttpServletRequest var1, MessageContext var2) throws Exception;

    abstract PogoResponder createPogoResponder();

    protected abstract String getAction(HttpServletRequest var1, MessageContext var2);

    abstract String getSOAPAction(String var1);

    boolean isGatewayRequest(HttpServletRequest request) {
        return request.getHeader(COGNOS_GATEWAY_HEADER_NAME) != null;
    }

    @Deprecated
    public Element addUnquotedItemElementForTest(String name, String value) {
        return this.addUnquotedItemElement(name, value);
    }

    @Deprecated
    Element addUnquotedItemElement(String name, String value) {
        return this.addItemElement(name, CookieQuoter.maybeUnquotedValue(value));
    }

    @Deprecated
    Element addItemElement(String name, String value) {
        int azzwordPos;
        Element itemElement = DocumentHelper.createElement((String)"item");
        Element nameElement = itemElement.addElement("name");
        nameElement.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.XSD_STRING);
        Element valueElement = itemElement.addElement("value");
        valueElement.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.XSD_STRING);
        if (value == null) {
            value = "";
        }
        if ((azzwordPos = name.indexOf("azzword")) != -1) {
            StringBuffer strBuffer = new StringBuffer(name);
            name = strBuffer.replace(azzwordPos, azzwordPos + 7, "assword").toString();
            Element formatElement = itemElement.addElement("format");
            formatElement.addAttribute(SOAPEnvelope.XSI_TYPE, BIBusEnvelope.XSD_FORMAT_ENCODING_ENUM);
            formatElement.addText("encrypted");
        }
        nameElement.addText(name);
        valueElement.addText(value);
        return itemElement;
    }

    abstract String getFormRequestBody(HttpServletRequest var1, String var2) throws IOException;

    String getQueryString(HttpServletRequest request) throws IOException {
        return request.getQueryString();
    }

    public static String deduceWebContentRoot(String scriptName) {
        int slashPos = scriptName.lastIndexOf(47);
        if (slashPos < 1) {
            return "/..";
        }
        if ((slashPos = (scriptName = scriptName.substring(0, slashPos)).lastIndexOf(47)) == 1) {
            return "/..";
        }
        if (slashPos == 0) {
            return "";
        }
        return scriptName.substring(0, slashPos);
    }

    void setWebContentRoot(HttpServletRequest request, BIBusEnvelope envelope) {
        String value = envelope.getEnvironmentValue(WEB_CONTENT_ROOT);
        if (value != null) {
            return;
        }
        String scriptName = request.getHeader("Original-Script-Name");
        if (scriptName == null || scriptName.length() == 0) {
            scriptName = request.getContextPath() + request.getServletPath();
        }
        String webContentRoot = RequestProcessor.deduceWebContentRoot(scriptName);
        envelope.setEnvironment(WEB_CONTENT_ROOT, webContentRoot);
    }

    protected void addExtraHeaders(HttpServletRequest request, BIBusEnvelope envelope) {
        for (String[] extraHeader : this.extraHeaders) {
            this.addExtraHeader(extraHeader, request, envelope);
        }
    }

    private void addExtraHeader(String[] extraHeader, HttpServletRequest request, BIBusEnvelope envelope) {
        String value = request.getHeader(extraHeader[0]);
        if (value != null) {
            envelope.setEnvironment(extraHeader[1], value);
        }
    }

    @Deprecated
    protected void addExtraHeaders(HttpServletRequest request, Element environmentElement) {
        for (int ih = 0; ih < this.extraHeaders.length; ++ih) {
            String headerName = this.extraHeaders[ih][0];
            String value = this.getHeaderFromRequest(request, headerName);
            if (value == null) continue;
            String envVarName = this.extraHeaders[ih][1];
            this.addUniqueEnvironmentVar(environmentElement, headerName, value, envVarName);
        }
    }

    protected String getHeaderFromRequest(HttpServletRequest request, String headerName) {
        return request.getHeader(headerName);
    }

    void addUniqueEnvironmentVar(Element environmentElement, String headerName, String value, String envVarName) {
        this.removeEnvVarIfPresent(environmentElement, envVarName);
        BIBusEnvelope.setEnvironmentVar(environmentElement, envVarName, value);
        cat.debug("Added extra header named ", headerName, " as env var ", envVarName, " value is: ", value);
    }

    private void removeEnvVarIfPresent(Element environmentElement, String envVarName) {
        Node envNode = environmentElement.selectSingleNode("item[name='" + envVarName + "']");
        if (envNode != null) {
            environmentElement.remove(envNode);
        }
    }

    public static boolean isCopyStreamEnabled() {
        return RequestProcessor.getCopyStreamProperty();
    }

    private static Boolean getCopyStreamProperty() {
        boolean propertyValue = Boolean.valueOf(AdvancedSettingParameterHandler.getValue(COPY_STREAM_PROPERTY, COPY_STREAM_DEFAULT));
        cat.info(COPY_STREAM_PROPERTY, "=", propertyValue);
        return propertyValue;
    }

    private static String encryptPassword(String password, CAMFactory camFactory) throws CAMCryptoException, UnsupportedEncodingException {
        byte[] encryptedData = camUtils.encryptData(camFactory, password.getBytes("UTF-8"));
        return base64.encode((int)0, (byte[])encryptedData);
    }

    public static String encryptPasswordsInQueryString(String queryString, CAMFactory camFactory) throws CAMCryptoException, UnsupportedEncodingException {
        if (queryString == null || queryString.length() == 0) {
            return queryString;
        }
        int currentIndex = queryString.indexOf(ASSWORD);
        if (currentIndex == -1) {
            return queryString;
        }
        StringBuffer buffer = new StringBuffer((int)((double)queryString.length() * 1.5));
        buffer.append(queryString.substring(0, currentIndex));
        int indexOfAmp = -1;
        while (true) {
            String plainTextPassword;
            if ((currentIndex += 8) >= queryString.length()) {
                plainTextPassword = "";
                indexOfAmp = -1;
            } else {
                indexOfAmp = queryString.indexOf("&", currentIndex);
                plainTextPassword = indexOfAmp == -1 ? URLEncoderDecoder.decode(queryString.substring(currentIndex), "UTF-8") : URLEncoderDecoder.decode(queryString.substring(currentIndex, indexOfAmp), "UTF-8");
            }
            buffer.append(AZZWORD);
            String encryptedPassword = RequestProcessor.encryptPassword(plainTextPassword, camFactory);
            buffer.append(URLEncoderDecoder.encode(encryptedPassword, "UTF-8"));
            if (indexOfAmp == -1) break;
            currentIndex = queryString.indexOf(ASSWORD, indexOfAmp);
            if (currentIndex == -1) {
                buffer.append(queryString.substring(indexOfAmp));
                break;
            }
            buffer.append(queryString.substring(indexOfAmp, currentIndex));
        }
        return buffer.toString();
    }

    public abstract boolean isXMLRequest();

    protected Iterator<?> getMIMEPartIterator(HttpServletRequest request, MessageContext mc) throws IOException {
        String contentTypeValue = request.getContentType();
        String boundary = MIMEPartParser.getBoundaryFromContentType(contentTypeValue);
        Object inStream = request.getInputStream();
        if (RequestProcessor.isCopyStreamEnabled()) {
            inStream = new CachedFileInputStream((InputStream)inStream, RequestProcessor.getCacheLimit());
        }
        MIMEPartParser it = new MIMEPartParser((InputStream)inStream, boundary);
        mc.setProperty("request.attachments", it);
        mc.setProperty("request.boundary", boundary);
        return it;
    }

    static long getCacheLimit() {
        long cacheLimit = Long.valueOf(AdvancedSettingParameterHandler.getValue(CACHE_LIMIT_PROPERTY, CACHE_LIMIT_DEFAULT));
        cat.info(CACHE_LIMIT_PROPERTY, "=", cacheLimit);
        return cacheLimit == -1L ? -1L : cacheLimit * 1024L;
    }

    static void setCAMUtilsForTesting(CAMUtils camUtils) {
        RequestProcessor.camUtils = camUtils;
    }

    protected BIBusEnvelope createEnvelope(MessageContext mc) {
        EnvelopeFactory envelopeFactory = EnvelopeFactorySelector.getFactoryFor(mc);
        BodyHandler bodyHandler = this.getBodyHandler(mc);
        return (BIBusEnvelope)envelopeFactory.createEnvelope(bodyHandler);
    }

    protected BIBusEnvelope createEnvelope(MessageContext mc, Reader reader) throws Exception {
        EnvelopeFactory envelopeFactory = EnvelopeFactorySelector.getFactoryFor(mc);
        BodyHandler bodyHandler = this.getBodyHandler(mc);
        return (BIBusEnvelope)envelopeFactory.createEnvelope(reader, bodyHandler);
    }

    protected BIBusEnvelope createEnvelope(MessageContext mc, InputStream stream) throws Exception {
        EnvelopeFactory envelopeFactory = EnvelopeFactorySelector.getFactoryFor(mc);
        BodyHandler bodyHandler = this.getBodyHandler(mc);
        return (BIBusEnvelope)envelopeFactory.createEnvelope(stream, bodyHandler);
    }

    protected BodyHandler getBodyHandler(MessageContext mc) {
        Object handler = mc.getProperty("envelope.bodyHandlerFactory");
        if (handler instanceof BodyHandlerFactory) {
            return ((BodyHandlerFactory)handler).createBodyHandler();
        }
        if (handler != null) {
            cat.warn("Handler [", handler, "] does not implement the BodyHandlerFactory interface.");
        }
        return null;
    }

    protected void copyRoutingHeaderToEnvelope(BIBusEnvelope requestEnvelope, HttpServletRequest httpRequest) {
        String routingHeader;
        String routingServerGroup = requestEnvelope.getRoutingServerGroup();
        if (routingServerGroup == null && (routingHeader = httpRequest.getHeader(CA_ROUTING_HEADER)) != null) {
            String[] routing = routingHeader.split("=");
            if (routing.length == 2) {
                requestEnvelope.setRoutingServerGroup(routing[1]);
            } else if (routing.length == 1) {
                requestEnvelope.setRoutingServerGroup(routing[0]);
            }
        }
    }
}

