/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.transport;

import com.cognos.pogo.auth.CookieDecoder;
import com.cognos.pogo.auth.CookieQuoter;
import com.cognos.pogo.http.inprocess.LocalServerConnection;
import com.cognos.pogo.http.inprocess.LocalServletRequest;
import com.cognos.pogo.impl.PogoHttpServletRequestWrapper;
import com.cognos.pogo.impl.PogoResponder;
import com.cognos.pogo.impl.PogoSOAPMessageResponder;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.SOAPEnvelope;
import com.cognos.pogo.pdk.common.EnvelopeFactory;
import com.cognos.pogo.pdk.common.EnvelopeFactorySelector;
import com.cognos.pogo.transport.RequestProcessor;
import com.cognos.pogo.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

public class SOAPRequestProcessor
extends RequestProcessor {
    private static final int PUSHBACK_BUFFER_SIZE = 3;

    protected SOAPRequestProcessor(String[][] extraHeaders) {
        super(extraHeaders);
    }

    @Override
    SOAPEnvelope createRequestEnvelope(HttpServletRequest request, MessageContext mc) throws Exception {
        BIBusEnvelope requestEnvelope = this.getRequestEnvelope(request, mc);
        cat.debug("Original SOAP request received: ", requestEnvelope);
        if (this.hasNoCamProtect(requestEnvelope)) {
            this.modifyEnvelope(requestEnvelope, request);
        }
        if (this.isGatewayRequest(request)) {
            mc.setProperty("checkCapabilities", Boolean.TRUE);
        }
        Cookie[] cookies = CookieDecoder.getCookies(request);
        this.copyHttpCookiesToBIBusCookieVars(cookies, requestEnvelope);
        String sCAMNamespace = request.getHeader("CAM-Namespace");
        if (sCAMNamespace != null && sCAMNamespace.length() > 0) {
            requestEnvelope.setEnvironment("CAMNamespace", sCAMNamespace);
        }
        this.copyAuthTypeHeaderIfAvailable(requestEnvelope, request);
        this.copyRoutingHeaderToEnvelope(requestEnvelope, request);
        mc.setProperty("SCRIPT_NAME", this.createScriptPath(request));
        mc.setProperty("HTTP_HOST", request.getHeader("host"));
        this.setWebContentRoot(request, requestEnvelope);
        cat.debug("SOAP request after being modified by SOAPRequestProcessor: ", requestEnvelope);
        return requestEnvelope;
    }

    private boolean hasNoCamProtect(BIBusEnvelope envelope) {
        return !envelope.getBiBusHeader().getCamProtect().isPresent();
    }

    private BIBusEnvelope getRequestEnvelope(HttpServletRequest request, MessageContext mc) throws Exception {
        if (this.isLocal(request)) {
            return this.getLocalRequestEnvelope(request, mc);
        }
        return this.parseRequestEnvelope(request, mc);
    }

    protected boolean isLocal(HttpServletRequest request) {
        return request.isUserInRole(LocalServletRequest.class.getName());
    }

    private BIBusEnvelope getLocalRequestEnvelope(HttpServletRequest request, MessageContext mc) throws Exception {
        PogoHttpServletRequestWrapper wrapper = (PogoHttpServletRequestWrapper)request;
        LocalServerConnection.setLocalServerConnection(mc, wrapper.getLocalServerConnection());
        BIBusEnvelope localRequestEnvelope = wrapper.getLocalRequestEnvelope();
        if (localRequestEnvelope == null) {
            wrapper.useLocalRequestStream();
            return this.parseRequestEnvelope(request, mc);
        }
        if (this.isCompatibleWith(localRequestEnvelope, mc)) {
            cat.debug("Reusing request envelope from local servlet client. ***No parsing required***.");
            return localRequestEnvelope;
        }
        return this.convertEnvelope(localRequestEnvelope, mc);
    }

    private boolean isCompatibleWith(BIBusEnvelope localRequestEnvelope, MessageContext mc) {
        EnvelopeFactory envelopeFactory = EnvelopeFactorySelector.getFactoryFor(mc);
        return envelopeFactory.isCompatibleWith(localRequestEnvelope);
    }

    private BIBusEnvelope convertEnvelope(BIBusEnvelope localRequestEnvelope, MessageContext mc) throws Exception {
        EnvelopeFactory envelopeFactory = EnvelopeFactorySelector.getFactoryFor(mc);
        return (BIBusEnvelope)envelopeFactory.convertEnvelope(localRequestEnvelope, this.getBodyHandler(mc), null);
    }

    private BIBusEnvelope parseRequestEnvelope(HttpServletRequest request, MessageContext mc) throws Exception {
        ServletInputStream ris = request.getInputStream();
        InputStream pis = this.getStreamWithBOMRemoved((InputStream)ris);
        InputStreamReader utf8Reader = new InputStreamReader(pis, this.getCharset(request));
        return this.createEnvelope(mc, utf8Reader);
    }

    InputStream getStreamWithBOMRemoved(InputStream ris) throws IOException {
        PushbackInputStream pis = new PushbackInputStream(ris, 3);
        byte[] b = new byte[3];
        int len = pis.read(b);
        if (!this.isByteOrderMark(b) && len != -1) {
            pis.unread(b, 0, len);
        }
        return pis;
    }

    public boolean isByteOrderMark(byte[] b) {
        return b[0] == -17 && b[1] == -69 && b[2] == -65;
    }

    private String getCharset(HttpServletRequest request) {
        String characterEncoding = request.getCharacterEncoding();
        if (characterEncoding != null) {
            return characterEncoding;
        }
        return "UTF-8";
    }

    private void modifyEnvelope(BIBusEnvelope requestEnvelope, HttpServletRequest httpRequest) {
        requestEnvelope.setDispatcherTransport("html", "false");
        if (this.isFrontDispatcher(requestEnvelope)) {
            this.setRemoteUser(requestEnvelope, httpRequest);
            this.dropSetCookie(requestEnvelope);
            this.addExtraHeaders(httpRequest, requestEnvelope);
        }
    }

    private boolean isFrontDispatcher(BIBusEnvelope requestEnvelope) {
        String frontValue = requestEnvelope.getDispatcherTransportValue("front");
        return frontValue == null || frontValue.equalsIgnoreCase("true");
    }

    private void dropSetCookie(BIBusEnvelope requestEnvelope) {
        requestEnvelope.getBiBusHeader().getHdrSession().getSetCookieVars().clear();
    }

    private void setRemoteUser(BIBusEnvelope request_env, HttpServletRequest request) {
        String remoteUser = request.getHeader("Original-Remote-User");
        if (remoteUser == null || remoteUser.length() == 0) {
            remoteUser = request.getRemoteUser();
        }
        if (remoteUser != null && remoteUser.length() > 0) {
            request_env.setEnvironment("REMOTE_USER", remoteUser);
        }
    }

    private void copyAuthTypeHeaderIfAvailable(BIBusEnvelope requestEnvelope, HttpServletRequest request) {
        String origAuthType = request.getHeader("Original-Auth-Type");
        if (StringUtils.isNotEmpty(origAuthType)) {
            requestEnvelope.setEnvironment("AUTH_TYPE", origAuthType);
        } else {
            String authType = request.getAuthType();
            if (StringUtils.isNotEmpty(authType)) {
                requestEnvelope.setEnvironment("AUTH_TYPE", authType);
            }
        }
    }

    @Override
    PogoResponder createPogoResponder() {
        return new PogoSOAPMessageResponder();
    }

    @Override
    String getSOAPAction(String soapAction) {
        return soapAction;
    }

    void copyHttpCookiesToBIBusCookieVars(Cookie[] cookies, BIBusEnvelope envelope) {
        if (this.areValid(envelope, cookies)) {
            for (Cookie cookie : cookies) {
                this.copyHttpCookieToCookieVars(envelope, cookie);
            }
        }
    }

    private boolean areValid(BIBusEnvelope envelope, Cookie[] cookies) {
        return envelope != null && cookies != null && cookies.length > 0;
    }

    private void copyHttpCookieToCookieVars(BIBusEnvelope envelope, Cookie cookie) {
        this.logCookieChange(envelope, cookie);
        envelope.setCookie(cookie.getName(), CookieQuoter.maybeUnquotedValue(cookie.getValue()));
    }

    private void logCookieChange(BIBusEnvelope envelope, Cookie cookie) {
        if (cat.isInfoEnabled() && this.isChangingCookieValue(envelope, cookie)) {
            cat.info("Overriding header cookie [", cookie.getName(), "] with HTTP cookie.");
        }
    }

    private boolean isChangingCookieValue(BIBusEnvelope envelope, Cookie cookie) {
        String currentValue = envelope.getCookieValue(cookie.getName());
        return currentValue != null && !currentValue.equals(cookie.getValue());
    }

    String createScriptPath(HttpServletRequest request) {
        String originalScriptName = request.getHeader("Original-Script-Name");
        if (originalScriptName == null || originalScriptName.length() == 0) {
            StringBuffer sb = new StringBuffer(request.getContextPath());
            sb.append(request.getServletPath());
            return sb.toString();
        }
        return originalScriptName;
    }

    @Override
    String getFormRequestBody(HttpServletRequest request, String cafModifiedQueryString) throws IOException {
        return cafModifiedQueryString;
    }

    @Override
    public boolean isXMLRequest() {
        return true;
    }

    @Override
    protected String getAction(HttpServletRequest request, MessageContext mc) {
        return request.getHeader("SOAPAction");
    }
}

