/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.util;

import com.cognos.pogo.util.CMByteRange;
import java.util.ArrayList;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class ByteRangeParser {
    private static final String BYTE_PREFIX = "bytes=";
    static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(ByteRangeParser.class.getName());

    public CMByteRange parseRange(String aRange) {
        if (aRange.indexOf(45) == -1) {
            return null;
        }
        CMByteRange aByteRange = new CMByteRange();
        String[] ranges = aRange.split("-", 2);
        try {
            aByteRange.skipDataBytes = this.getSkipDataBytes(ranges[0]);
            aByteRange.maxDataBytes = this.getMaxDataBytes(ranges[1], aByteRange.skipDataBytes);
        }
        catch (Exception ex) {
            if (cat.isDebugEnabled()) {
                cat.debug("Failed to parse ByteRange" + ex.getMessage());
            }
            return null;
        }
        return aByteRange;
    }

    public ArrayList<CMByteRange> parseRangeHeader(String byteRangeHeader) {
        if (byteRangeHeader == null || !byteRangeHeader.startsWith(BYTE_PREFIX)) {
            return null;
        }
        ArrayList<CMByteRange> ranges = new ArrayList<CMByteRange>();
        String byteRange = byteRangeHeader.substring(BYTE_PREFIX.length());
        if ("".equals(byteRange)) {
            return null;
        }
        this.getCMByteRangeArray(byteRange, ranges);
        return ranges;
    }

    private void addParsedToList(ArrayList<CMByteRange> ranges, String single) {
        CMByteRange range = this.parseRange(single.trim());
        if (range != null) {
            ranges.add(range);
        }
    }

    private long getSkipDataBytes(String astring) throws Exception {
        long startByte = this.parseLong(astring);
        if (startByte < 0L) {
            throw new Exception("Unexpected negative number");
        }
        return startByte;
    }

    private long getMaxDataBytes(String astring, long startByte) throws Exception {
        long endByte = this.parseLong(astring);
        if (endByte == 0L) {
            return endByte;
        }
        if (endByte < 0L) {
            throw new Exception("Unexpected negative number");
        }
        if (endByte < startByte) {
            throw new Exception("Start byte range greater than end byte range");
        }
        return endByte - startByte + 1L;
    }

    private long parseLong(String aLongStr) throws Exception {
        if (aLongStr == null || aLongStr.length() == 0) {
            return 0L;
        }
        return Long.parseLong(aLongStr);
    }

    private void getCMByteRangeArray(String byteRange, ArrayList<CMByteRange> ranges) {
        int commaPosition;
        int startPosition = 0;
        while ((commaPosition = byteRange.indexOf(44, startPosition)) != -1) {
            String single = byteRange.substring(startPosition, commaPosition);
            this.addParsedToList(ranges, single);
            startPosition = commaPosition + 1;
        }
        this.addParsedToList(ranges, byteRange.substring(startPosition));
    }
}

