/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.util;

import com.cognos.pogo.util.PogoLogger;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Element;

public class RuntimeEnvironment {
    private static final PogoLogger log = PogoLogger.getLogger();
    private static final String[] NO_REPLACEMENT = new String[]{"", ""};
    private static final String SEPARATOR = "%";
    private String environmentReplacement;
    private String expr;
    private String substitute;
    private final Element targetConfig;

    public RuntimeEnvironment() {
        this(null);
    }

    public RuntimeEnvironment(Element targetConfig) {
        this.targetConfig = targetConfig != null ? targetConfig.createCopy() : null;
    }

    public Process startProcess(String[] commandLineArguments, String[] environment, String workingDirectory) throws IOException {
        File dir = workingDirectory != null ? new File(workingDirectory) : null;
        return this.startProcess(commandLineArguments, environment, dir);
    }

    protected Process startProcess(String[] commandLineArguments, String[] environment, File dir) throws IOException {
        return Runtime.getRuntime().exec(commandLineArguments, environment, dir);
    }

    public void setEnvironmentReplacement(String environmentReplacement) {
        this.environmentReplacement = environmentReplacement;
    }

    public boolean hasNoEnvironmentReplacement() {
        return this.environmentReplacement == null;
    }

    public String[] getEnvironment() {
        ArrayList<String> envList = new ArrayList<String>();
        this.prepareEnvironment();
        this.addEnvironmentToList(envList);
        return envList.isEmpty() ? null : this.toArray(envList);
    }

    private void prepareEnvironment() {
        if (this.hasNoEnvironmentReplacement()) {
            return;
        }
        String[] split = this.splitIntoExpressionAndSubstitute(this.environmentReplacement);
        this.expr = split[0];
        this.substitute = split[1];
    }

    private String[] splitIntoExpressionAndSubstitute(String environmentReplacement) {
        String[] split = environmentReplacement.split(SEPARATOR);
        if (this.isValid(split)) {
            return split;
        }
        log.warn("Ignoring environment replacement string: ", environmentReplacement);
        return NO_REPLACEMENT;
    }

    private boolean isValid(String[] split) {
        return split != null && split.length == 2;
    }

    private void addEnvironmentToList(List<String> envList) {
        Map<String, String> environmentVariables = this.getEnvironmentVariables();
        for (Map.Entry<String, String> environmentVariable : environmentVariables.entrySet()) {
            this.addToList(envList, environmentVariable);
        }
    }

    protected Map<String, String> getEnvironmentVariables() {
        HashMap<String, String> varsMap = new HashMap<String, String>();
        varsMap.putAll(System.getenv());
        this.addTargetEnvironmentVariables(varsMap);
        return varsMap;
    }

    private void addTargetEnvironmentVariables(Map<String, String> varsMap) {
        if (this.targetConfig != null) {
            for (Element envVar : this.targetConfig.elements("env-var")) {
                this.addTargetEnvirontmentVariable(envVar, varsMap);
            }
        }
    }

    private String getChildElementText(Element element, String name) {
        Element child = element.element(name);
        String text = child.getTextTrim();
        if (child == null || text.length() == 0) {
            return null;
        }
        return text;
    }

    private void addTargetEnvirontmentVariable(Element envVar, Map<String, String> varsMap) {
        String mode;
        String name = this.getChildElementText(envVar, "env-name");
        String value = this.getChildElementText(envVar, "env-value");
        if (name == null || value == null) {
            return;
        }
        String envValue = varsMap.get(name);
        if (envValue != null && envValue.trim().length() > 0 && "prepend".equals(mode = this.getChildElementText(envVar, "env-mode"))) {
            String separator = this.getChildElementText(envVar, "env-separator");
            String oldValue = envValue.trim();
            value = separator != null ? value + separator + oldValue : value + oldValue;
        }
        varsMap.put(name, value);
    }

    private void addToList(List<String> envList, Map.Entry<String, String> environmentVariable) {
        String name = environmentVariable.getKey();
        String value = environmentVariable.getValue();
        String newValue = this.maybeReplace(value);
        if (log.isDebugEnabled()) {
            this.logEnvironment(name, value, newValue);
        }
        envList.add(name + "=" + newValue);
    }

    private String maybeReplace(String value) {
        return this.hasNoEnvironmentReplacement() ? value : value.replaceAll(this.expr, this.substitute);
    }

    private void logEnvironment(String name, String value, String newValue) {
        if (value.equals(newValue)) {
            log.debug(name, "=", value);
        } else {
            log.debug(name, " changed from [", value, "] to [", newValue, "]");
        }
    }

    private String[] toArray(List<String> envList) {
        String[] environment = new String[envList.size()];
        envList.toArray(environment);
        return environment;
    }

    public String getEnvironmentReplacementForTesting() {
        return this.environmentReplacement;
    }
}

