/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.util;

import com.cognos.pogo.util.PogoLogger;
import java.util.Locale;
import java.util.Random;
import java.util.zip.Adler32;

public class StringUtils {
    private static final PogoLogger log = PogoLogger.getLogger();
    private static Random rand = new Random();
    private static String ellipsis = " ... ";
    private static final char[] hex_chars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static String stripQuotes(String s) {
        int ie;
        int is;
        if (s == null || s.length() == 0) {
            return s;
        }
        for (is = 0; is < s.length() && s.charAt(is) == '\"'; ++is) {
        }
        for (ie = s.length(); ie > is && s.charAt(ie - 1) == '\"'; --ie) {
        }
        return s.substring(is, ie);
    }

    public static Locale getLocale(String localeString) {
        String language = null;
        String country = null;
        int dash = localeString.indexOf(45);
        if (dash < 0) {
            language = localeString;
            country = "";
        } else {
            language = localeString.substring(0, dash);
            country = localeString.substring(dash + 1);
        }
        return new Locale(language, country);
    }

    public static String getUniqueValue() {
        StringBuffer s = new StringBuffer(128);
        s.append(System.currentTimeMillis()).append('.').append(rand.nextLong()).append('.').append(s.hashCode());
        return s.toString();
    }

    public static String hexify(byte[] bytes) {
        StringBuffer sb = new StringBuffer(bytes.length * 2);
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            sb.append(hex_chars[b & 0xF]).append(hex_chars[(b & 0xF0) >> 4]);
        }
        return sb.toString();
    }

    public static String shorten(String s, int maxLength) {
        if (maxLength < 0) {
            return s;
        }
        if (StringUtils.isShorterThanMax(s, maxLength)) {
            return s;
        }
        if (StringUtils.isShorterThanEllipsis(maxLength)) {
            return StringUtils.getPartialEllipsis(maxLength);
        }
        int visibleLength = maxLength - ellipsis.length();
        int firstPartLength = visibleLength / 2;
        int secondPartLength = visibleLength - firstPartLength;
        return StringUtils.getFirstPart(s, firstPartLength) + ellipsis + StringUtils.getSecondPart(s, secondPartLength);
    }

    private static boolean isShorterThanMax(String s, int maxLength) {
        return s == null || s.length() <= maxLength;
    }

    private static boolean isShorterThanEllipsis(int maxLength) {
        return maxLength < ellipsis.length();
    }

    private static String getPartialEllipsis(int maxLength) {
        return ellipsis.substring(0, maxLength);
    }

    private static String getFirstPart(String s, int firstPartLength) {
        return s.substring(0, firstPartLength);
    }

    private static String getSecondPart(String s, int secondPartLength) {
        return s.substring(s.length() - secondPartLength, s.length());
    }

    public static long getChecksum(String s) {
        Adler32 checksum = new Adler32();
        checksum.update(s.getBytes());
        return checksum.getValue();
    }

    public static int parseInt(String text) {
        Integer value = StringUtils.parseOptionalInteger(text);
        return value != null ? value : 0;
    }

    public static Integer parseOptionalInteger(String text) {
        try {
            return text != null ? Integer.parseInt(text) : 0;
        }
        catch (NumberFormatException e) {
            log.warn("Error parsing integer value: " + text, e);
            return null;
        }
    }

    public static Boolean parseOptionalBoolean(String text) {
        return org.apache.commons.lang.StringUtils.isNotEmpty((String)text) ? Boolean.valueOf(text) : null;
    }

    public static Long parseOptionalLong(String text) {
        try {
            return Long.parseLong(text);
        }
        catch (NumberFormatException e) {
            log.warn("Error parsing long value: " + text, e);
            return null;
        }
    }

    public static boolean isEmpty(String s) {
        return org.apache.commons.lang.StringUtils.isEmpty((String)s);
    }

    public static boolean isNotEmpty(String s) {
        return org.apache.commons.lang.StringUtils.isNotEmpty((String)s);
    }
}

