/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.util;

import com.cognos.pogo.util.PogoLogger;
import com.cognos.pogo.util.StreamFactory;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class XmlUtils {
    private static final PogoLogger log = PogoLogger.getLogger();
    private static final String ENCODING = "UTF-8";
    private static final String ENCODED_APOS = "&apos;";
    private static final String ENCODED_LT = "&lt;";
    private static final String ENCODED_GT = "&gt;";
    private static final String ENCODED_AMP = "&amp;";
    private static final String ENCODED_QUOT = "&quot;";
    private static final char APOS = '\'';
    private static final char LT = '<';
    private static final char GT = '>';
    private static final char AMP = '&';
    private static final char QUOT = '\"';
    public static final String NULL_XML = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\n<null_xml/>\n";

    public static String prettyPrint(String xml) throws Exception {
        if (xml == null) {
            return NULL_XML;
        }
        Document doc = DocumentHelper.parseText((String)xml);
        ByteArrayOutputStream stream = StreamFactory.createByteArrayOutputStream();
        XmlUtils.writeDocumentToStream(doc, stream);
        return stream.toString(ENCODING);
    }

    public static String prettyPrintAndCatchException(String xml) {
        try {
            return XmlUtils.prettyPrint(xml);
        }
        catch (Exception e) {
            log.debug("Exception caught while pretty-printing XML string: ", e);
            return e.getMessage();
        }
    }

    private static void writeDocumentToStream(Document doc, OutputStream stream) throws Exception {
        XMLWriter xmlWriter = XmlUtils.createXmlWriter(stream);
        xmlWriter.write(doc);
        xmlWriter.flush();
    }

    private static XMLWriter createXmlWriter(OutputStream stream) throws Exception {
        OutputStreamWriter writer = StreamFactory.createOutputStreamWriter(stream, ENCODING);
        return new XMLWriter((Writer)writer, OutputFormat.createPrettyPrint());
    }

    public static String xmlEncode(String source) {
        return XmlUtils.xmlEncodeAttribute(source);
    }

    public static StringBuilder xmlEncode(String source, StringBuilder dest) {
        return XmlUtils.xmlEncodeAttributeValue(source, dest);
    }

    public static String xmlEncodeAttribute(String source) {
        return source != null ? XmlUtils.encodeAttribute(source) : null;
    }

    public static StringBuilder xmlEncodeAttributeValue(String source, StringBuilder dest) {
        return source != null ? XmlUtils.encodeAttribute(source, dest) : null;
    }

    public static String xmlEncodeElement(String source) {
        return source != null ? XmlUtils.encodeElement(source) : null;
    }

    public static StringBuilder xmlEncodeElement(String source, StringBuilder dest) {
        return source != null ? XmlUtils.encodeElement(source, dest) : null;
    }

    private static String encodeAttribute(String source) {
        StringBuilder dest = XmlUtils.createRoomForEncodedString(source);
        return XmlUtils.encodeAttribute(source, dest).toString();
    }

    private static StringBuilder createRoomForEncodedString(String source) {
        int sizeEstimate = source.length() * ENCODED_AMP.length();
        return new StringBuilder(sizeEstimate);
    }

    private static StringBuilder encodeAttribute(String source, StringBuilder dest) {
        for (int i = 0; i < source.length(); ++i) {
            XmlUtils.encodeAttributeCharacter(source, dest, i, source.charAt(i));
        }
        return dest;
    }

    private static String encodeElement(String source) {
        StringBuilder dest = XmlUtils.createRoomForEncodedString(source);
        return XmlUtils.encodeElement(source, dest).toString();
    }

    private static StringBuilder encodeElement(String source, StringBuilder dest) {
        for (int i = 0; i < source.length(); ++i) {
            XmlUtils.encodeElementCharacter(source, dest, i, source.charAt(i));
        }
        return dest;
    }

    private static void encodeAttributeCharacter(String source, StringBuilder dest, int i, char x) {
        switch (x) {
            case '\'': {
                dest.append(ENCODED_APOS);
                break;
            }
            case '\"': {
                dest.append(ENCODED_QUOT);
                break;
            }
            default: {
                XmlUtils.encodeElementCharacter(source, dest, i, x);
            }
        }
    }

    private static void encodeElementCharacter(String source, StringBuilder dest, int i, char x) {
        switch (x) {
            case '<': {
                dest.append(ENCODED_LT);
                break;
            }
            case '>': {
                dest.append(ENCODED_GT);
                break;
            }
            case '&': {
                XmlUtils.encodeAmpersand(source, dest, i, x);
                break;
            }
            default: {
                dest.append(x);
            }
        }
    }

    private static void encodeAmpersand(String source, StringBuilder dest, int i, char x) {
        if (XmlUtils.isAlreadyEncoded(source, i)) {
            dest.append(x);
        } else {
            dest.append(ENCODED_AMP);
        }
    }

    private static boolean isAlreadyEncoded(String source, int pos) {
        return source.startsWith(ENCODED_APOS, pos) || source.startsWith(ENCODED_LT, pos) || source.startsWith(ENCODED_GT, pos) || source.startsWith(ENCODED_AMP, pos) || source.startsWith(ENCODED_QUOT, pos);
    }

    public static String xmlDecode(String source) {
        if (source == null) {
            return null;
        }
        StringBuffer sbuf = new StringBuffer(source.length());
        int i = 0;
        while (i < source.length()) {
            char x = source.charAt(i);
            if (x != '&') {
                sbuf.append(x);
                ++i;
                continue;
            }
            if (source.startsWith(ENCODED_APOS, i)) {
                sbuf.append('\'');
                i += ENCODED_APOS.length();
                continue;
            }
            if (source.startsWith(ENCODED_LT, i)) {
                sbuf.append('<');
                i += ENCODED_LT.length();
                continue;
            }
            if (source.startsWith(ENCODED_GT, i)) {
                sbuf.append('>');
                i += ENCODED_GT.length();
                continue;
            }
            if (source.startsWith(ENCODED_AMP, i)) {
                sbuf.append('&');
                i += ENCODED_AMP.length();
                continue;
            }
            if (source.startsWith(ENCODED_QUOT, i)) {
                sbuf.append('\"');
                i += ENCODED_QUOT.length();
                continue;
            }
            sbuf.append('&');
            ++i;
        }
        return sbuf.toString();
    }
}

