/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.util;

import java.io.ByteArrayOutputStream;

public class base64 {
    public static final int BASE64 = 0;
    public static final int WEB64 = 1;
    public static final int PP64 = 2;
    private static final String[] encTable = new String[]{"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/", "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789*-", "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789_~"};
    private static final char[] padchar = new char[]{'=', '_', '='};
    private static final byte[] base64DecodeTable = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 62, 0, 0, 0, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 0, 0, 0, 0, 0, 0, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 0, 0, 0, 0, 0};
    private static final byte[] web64DecodeTable = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 62, 0, 0, 63, 0, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 0, 0, 0, 0, 0, 0, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 0, 0, 0, 0, 0};
    private static final byte[] pp64DecodeTable = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 62, 62, 0, 63, 0, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 0, 0, 0, 0, 63, 0, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 0, 0, 0, 62, 0};
    private static final byte[][] decodeTables = new byte[][]{base64DecodeTable, web64DecodeTable, pp64DecodeTable};

    public static String encode(int mode, byte[] buf) {
        int c = 0;
        int size = buf.length;
        int rsize = (size / 3 + 1) * 4;
        StringBuffer ret = new StringBuffer(rsize);
        for (int i = 0; i < size; ++i) {
            c = buf[i] >> 2 & 0x3F;
            ret.append(encTable[mode].charAt(c));
            c = buf[i] << 4 & 0x30;
            if (++i < size) {
                c |= buf[i] >> 4 & 0xF;
            }
            ret.append(encTable[mode].charAt(c));
            if (i < size) {
                c = buf[i] << 2 & 0x3C;
                if (++i < size) {
                    c |= buf[i] >> 6 & 3;
                }
                ret.append(encTable[mode].charAt(c));
            } else {
                ++i;
                ret.append(padchar[mode]);
            }
            if (i < size) {
                c = buf[i] & 0x3F;
                ret.append(encTable[mode].charAt(c));
                continue;
            }
            ret.append(padchar[mode]);
        }
        return ret.toString();
    }

    public static byte[] decode(int mode, String str) {
        int len = str.length();
        if (len % 4 != 0) {
            return str.getBytes();
        }
        byte[] decodetable = decodeTables[mode];
        int rsize = (len / 4 + 1) * 3;
        ByteArrayOutputStream ret = new ByteArrayOutputStream(rsize);
        try {
            for (int i = 0; i < len; ++i) {
                int c = decodetable[(byte)str.charAt(i++)];
                int c1 = decodetable[(byte)str.charAt(i++)];
                c = c << 2 & 0xFC | c1 >> 4 & 3;
                ret.write((byte)c);
                if (str.charAt(i) == padchar[mode]) break;
                c = decodetable[(byte)str.charAt(i++)];
                c1 = c1 << 4 & 0xF0 | c >> 2 & 0xF;
                ret.write((byte)c1);
                if (str.charAt(i) == padchar[mode]) break;
                c1 = decodetable[(byte)str.charAt(i)];
                c = c << 6 & 0xC0 | c1 & 0x3F;
                ret.write((byte)c);
            }
            return ret.toByteArray();
        }
        catch (Exception e) {
            return str.getBytes();
        }
    }
}

