/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.util.capability;

import com.cognos.pogo.pdk.common.UserCapabilityCacheException;
import com.cognos.pogo.util.capability.UserCapabilityLoader;
import java.math.BigInteger;
import java.util.ArrayList;

public class UserCapabilityBitEncoder {
    private static final String SEPARATOR = ";";
    private static String[] sparseUse;
    private final String cookieValue;

    public UserCapabilityBitEncoder(String cookieValue) {
        this.cookieValue = cookieValue;
    }

    public ArrayList<String> decode() throws UserCapabilityCacheException {
        BigInteger bitArray = this.createBitArray();
        ArrayList<String> returnedCapabilities = new ArrayList<String>();
        for (int i = 0; i < bitArray.bitLength(); ++i) {
            if (!bitArray.testBit(i)) continue;
            this.addCapability(returnedCapabilities, i);
        }
        return returnedCapabilities;
    }

    private void addCapability(ArrayList<String> returnedCapabilities, int i) throws UserCapabilityCacheException {
        String capability = UserCapabilityBitEncoder.getCapabilityForIndex(i);
        if (capability != null) {
            returnedCapabilities.add(capability);
        }
    }

    static String getCapabilityForIndex(int i) throws UserCapabilityCacheException {
        UserCapabilityBitEncoder.checkInRange(i);
        return sparseUse[i];
    }

    private static void checkInRange(int i) throws UserCapabilityCacheException {
        if (i > UserCapabilityBitEncoder.getMaxCapabilityIndex()) {
            throw new UserCapabilityCacheException("Bit index out of range");
        }
    }

    public static int getMaxCapabilityIndex() {
        return sparseUse.length - 1;
    }

    BigInteger createBitArray() throws UserCapabilityCacheException {
        BigInteger result = new BigInteger("0");
        String[] split = this.cookieValue.split(SEPARATOR);
        if (!this.isEmpty(split)) {
            result = this.decodeChunks(result, split);
        }
        return result;
    }

    private boolean isEmpty(String[] split) {
        return split.length == 1 && split[0].length() == 0;
    }

    private BigInteger decodeChunks(BigInteger result, String[] split) throws UserCapabilityCacheException {
        for (int i = split.length - 1; i >= 0; --i) {
            BigInteger chunkInteger = this.createChunkInteger(split[i]);
            int shiftAmount = (split.length - i - 1) * 32;
            BigInteger shiftedChunk = chunkInteger.shiftLeft(shiftAmount);
            result = result.add(shiftedChunk);
        }
        return result;
    }

    private BigInteger createChunkInteger(String chunk) throws UserCapabilityCacheException {
        try {
            return new BigInteger(chunk, 16);
        }
        catch (NumberFormatException e) {
            throw new UserCapabilityCacheException(e.getMessage());
        }
    }

    static {
        UserCapabilityLoader userCapabilityLoader = new UserCapabilityLoader();
        sparseUse = userCapabilityLoader.getCapabilities();
    }
}

