/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.util.pool;

import com.cognos.pogo.util.PogoLogger;
import com.cognos.pogo.util.StringUtils;
import com.cognos.pogo.util.pool.MemoryUse;
import com.cognos.pogo.util.pool.StringPool;
import com.cognos.pogo.util.pool.StringPoolListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.log.Priority;

public class WeakHashPool
implements StringPool {
    static final int DEFAULT_INITIAL_CAPACITY = 65535;
    static final float DEFAULT_LOAD_FACTOR = 1.0f;
    private static PogoLogger log = PogoLogger.getLogger();
    private static int maxLengthForLogDump = 80;
    private final Map<String, WeakReference<String>> map;
    private long physicalSize;
    private long maxCapacity;
    private int warningLevelPercentage;
    private StringPoolListener listener;
    private boolean isAlarmRaised;

    public WeakHashPool() {
        this(65535, 1.0f);
    }

    public WeakHashPool(int initialCapacity) {
        this(initialCapacity, 1.0f);
    }

    public WeakHashPool(int initialCapacity, float loadFactor) {
        this.map = this.createMap(initialCapacity, loadFactor);
    }

    protected WeakHashMap<String, WeakReference<String>> createMap(int initialCapacity, float loadFactor) {
        return new WeakHashMap<String, WeakReference<String>>(initialCapacity, loadFactor);
    }

    @Override
    public synchronized void clear() {
        this.map.clear();
        this.physicalSize = 0L;
    }

    @Override
    public synchronized String intern(String s) {
        String internedString = null;
        WeakReference<String> weakRef = this.map.get(s);
        if (weakRef != null) {
            internedString = (String)weakRef.get();
        }
        if (internedString == null) {
            this.map.put(s, new WeakReference<String>(s));
            internedString = s;
            this.addToPhysicalSize(s);
        }
        return internedString;
    }

    private void addToPhysicalSize(String s) {
        this.physicalSize += (long)this.getLength(s);
        this.checkAlarmLevels();
        if (log.isDebugEnabled()) {
            log.debug(this.getClassName(), ": added to physicalSize = (", this.getLength(s), " bytes) ", StringUtils.shorten(s, maxLengthForLogDump), " (physicalSize: ", this.getPhysicalSize(), ", actual size: ", this.getActualSize(), ")");
        }
    }

    protected String getClassName() {
        return this.getClass().getSimpleName();
    }

    protected int getLength(String s) {
        return s != null ? s.length() : 0;
    }

    @Override
    public synchronized long getPhysicalSize() {
        return this.physicalSize;
    }

    @Override
    public synchronized long getActualSize() {
        long actualSize = 0L;
        for (String s : this.map.keySet()) {
            if (s == null) continue;
            actualSize += (long)s.length();
        }
        return actualSize;
    }

    private synchronized ArrayList<String> getInternedStrings() {
        return new ArrayList<String>(this.map.keySet());
    }

    @Override
    public void setWaterLevel(long maxCapacity, int warningLevelPercentage) {
        log.info("setWaterLevel(maxCapacity: ", maxCapacity, ", warningLevel: ", warningLevelPercentage, "%)");
        this.maxCapacity = maxCapacity;
        this.warningLevelPercentage = warningLevelPercentage;
    }

    @Override
    public void setListener(StringPoolListener listener) {
        this.listener = listener;
    }

    private void checkAlarmLevels() {
        if (this.isAllowedToSendAlarm() && this.needsToSendAlarm()) {
            this.sendAlarm();
        }
    }

    private boolean isAllowedToSendAlarm() {
        return this.listener != null && !this.isAlarmRaised;
    }

    private boolean needsToSendAlarm() {
        if (!this.hasCrossedWarningLevel()) {
            return false;
        }
        this.setPhysicalSizeToActualSize();
        return this.hasCrossedWarningLevel();
    }

    private boolean hasCrossedWarningLevel() {
        return this.getPercentFull() >= this.warningLevelPercentage;
    }

    @Override
    public int getPercentFull() {
        return this.maxCapacity > 0L ? (int)(100L * this.physicalSize / this.maxCapacity) : 0;
    }

    private void setPhysicalSizeToActualSize() {
        long estimated = this.physicalSize;
        this.physicalSize = this.getActualSize();
        if (this.physicalSize < estimated) {
            log.info("Estimated size was: ", estimated, " bytes. Now using actual size: ", this.physicalSize, " bytes.");
        }
    }

    protected void sendAlarm() {
        int percentFull = this.getPercentFull();
        this.logAlarm(percentFull);
        this.isAlarmRaised = true;
        this.listener.handleCapacityAlarm(percentFull);
    }

    private void logAlarm(int percentFull) {
        if (log.isInfoEnabled()) {
            log.info("String pool is ", percentFull, "% full, sending alarm. Java heap: current = ", MemoryUse.getCurrentSizeInBytes() / 1024L, " KB, max = ", MemoryUse.getMaxSizeInBytes() / 1024L, " KB.");
        }
    }

    @Override
    public void resetAlarm() {
        this.isAlarmRaised = false;
    }

    @Override
    public void dump(PogoLogger log, String indent) {
        ArrayList<String> strings = this.getInternedStrings();
        log.debug(indent, this.getClassName(), ": ", strings.size(), " strings");
        indent = indent + "   ";
        log.debug(indent, "Physical size: ", this.getPhysicalSize());
        log.debug(indent, "Actual size: ", this.getActualSize());
        for (String s : strings) {
            if (s == null) continue;
            log.debug(indent, "(", s.length(), " bytes) ", StringUtils.shorten(s, maxLengthForLogDump));
        }
    }

    public static void setMaxLogLength(int maxLengthForLogDump) {
        WeakHashPool.maxLengthForLogDump = maxLengthForLogDump;
    }

    public static void setLogPriority(Priority priority) {
        log.setPriority(priority);
    }
}

