/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.util.timer;

import com.cognos.pogo.util.PogoLogger;
import com.cognos.pogo.util.threads.SafeTimerTask;
import com.cognos.pogo.util.timer.NullPogoTimer;
import com.cognos.pogo.util.timer.PogoTimerOwner;
import java.util.Timer;
import java.util.TimerTask;

public class PogoTimer
extends SafeTimerTask {
    static final String USE_DAEMON_THREADS_PROPERTY = "com.ibm.cognos.disp.useDaemonThreads";
    private static PogoLogger log = PogoLogger.getLogger();
    private static Timer timer = PogoTimer.createNativeTimer(PogoTimer.class.getSimpleName());
    public static final PogoTimer NULL = NullPogoTimer.getInstance();
    private PogoTimerOwner owner;
    private Object parameter;
    private boolean isCancelled;
    private final boolean isPeriodic;

    public PogoTimer(PogoTimerOwner owner, Object parameter, long timeoutInMillis) {
        this.owner = owner;
        this.parameter = parameter;
        this.isPeriodic = false;
        timer.schedule((TimerTask)this, timeoutInMillis);
    }

    public PogoTimer(PogoTimerOwner owner, Object parameter, long delay, long period) {
        this.owner = owner;
        this.parameter = parameter;
        this.isPeriodic = true;
        timer.schedule((TimerTask)this, delay, period);
    }

    public static Timer createNativeTimer(String threadName) {
        boolean isDaemon = Boolean.valueOf(System.getProperties().getProperty(USE_DAEMON_THREADS_PROPERTY));
        log.debug("Timer ", threadName, " will run as a ", isDaemon ? "daemon" : "user", " thread");
        return new Timer(threadName, isDaemon);
    }

    @Override
    public boolean cancel() {
        this.isCancelled = true;
        this.cleanupReferenceToTimerParameter();
        return super.cancel();
    }

    private void cleanupReferenceToTimerParameter() {
        this.parameter = null;
    }

    @Override
    public void safeRun() {
        if (!this.isCancelled) {
            this.tryToNotifyOwner();
        }
        if (!this.isPeriodic) {
            this.cleanupReferenceToTimerParameter();
        }
    }

    private void tryToNotifyOwner() {
        try {
            this.owner.handleTimeoutEvent(this.parameter);
        }
        catch (Exception e) {
            log.warn("PogoTimer owner threw an exception while handling a timeout notification", e);
        }
    }

    public static Timer modifyInternalTimerForTesting(Timer newTimer) {
        Timer previousTimer = timer;
        timer = newTimer;
        return previousTimer;
    }
}

