/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pdc.core.ehcache;

import com.ibm.cognos.pdc.core.ehcache.CacheManagerDelegate;
import com.ibm.cognos.pdc.core.ehcache.DefaultCacheManagerDelegate;
import com.ibm.cognos.pdc.core.ehcache.config.ConfigLifeCycleManager;
import com.ibm.cognos.pdc.core.ehcache.config.bean.PDCCacheBean;
import com.ibm.cognos.pdc.core.ehcache.pogo.LogKitFactory;
import com.ibm.cognos.pdc.core.ehcache.rmi.DefaultRMINamingDelegate;
import com.ibm.cognos.pdc.core.ehcache.rmi.RMIEndpoint;
import com.ibm.cognos.pdc.core.ehcache.rmi.RMINamingDelegate;
import com.ibm.cognos.pdc.core.ehcache.rmi.RMIPeerListener;
import com.ibm.cognos.pdc.core.ehcache.rmi.RMIPeerListenerProvider;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.distribution.CacheManagerPeerProvider;
import net.sf.ehcache.distribution.CachePeer;
import org.apache.log.Logger;

public class CognosCacheManagerPeerProvider
implements CacheManagerPeerProvider {
    private static final Logger LOGGER = LogKitFactory.getLogger(CognosCacheManagerPeerProvider.class);
    private final CacheManagerDelegate cacheManager;
    private final RMINamingDelegate rmi;
    private final RMIPeerListener peerListener;
    private final ConfigLifeCycleManager configManager;
    private final ConcurrentHashMap<RMIEndpoint, Date> rmiPeers = new ConcurrentHashMap();

    protected CognosCacheManagerPeerProvider(CacheManagerDelegate cacheManager, RMINamingDelegate rmi, RMIPeerListenerProvider peerListenerProvider, ConfigLifeCycleManager configManager) {
        this.cacheManager = cacheManager;
        this.rmi = rmi;
        this.peerListener = peerListenerProvider.getPeerListener(this);
        this.configManager = configManager;
    }

    protected CognosCacheManagerPeerProvider(CacheManagerDelegate cacheManager) {
        this(cacheManager, new DefaultRMINamingDelegate(), RMIPeerListenerProvider.getInstance(), ConfigLifeCycleManager.getInstance());
    }

    protected CognosCacheManagerPeerProvider(CacheManager cacheManager) {
        this(new DefaultCacheManagerDelegate(cacheManager), new DefaultRMINamingDelegate(), RMIPeerListenerProvider.getInstance(), ConfigLifeCycleManager.getInstance());
    }

    public long getTimeForClusterToForm() {
        return 0L;
    }

    public void init() {
        LOGGER.debug("initializing CognosCacheManagerPeerProvider: " + this.cacheManager.getName());
        this.peerListener.initialize();
    }

    public Set<RMIEndpoint> getRMIPeers() {
        return new HashSet<RMIEndpoint>(this.rmiPeers.keySet());
    }

    public List<CachePeer> listRemoteCachePeers(Ehcache cache) throws CacheException {
        String ehCacheName = cache.getName();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(this + " listRemoteCachePeers(" + ehCacheName + ")...");
        }
        PDCCacheBean cacheConfig = this.configManager.getPDCCacheConfig(ehCacheName);
        ArrayList<CachePeer> peersList = new ArrayList<CachePeer>();
        for (RMIEndpoint rmiPeer : this.rmiPeers.keySet()) {
            String rmiUri;
            CachePeer cachePeer;
            if (!this.isValidPeer(rmiPeer, cacheConfig) || (cachePeer = this.getCachePeer(rmiUri = rmiPeer.getRmiBaseUri() + "/" + ehCacheName)) == null) continue;
            peersList.add(cachePeer);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("listRemoteCachePeers returning " + peersList);
        }
        return peersList;
    }

    private CachePeer getCachePeer(String remoteCacheUrl) {
        CachePeer peer;
        try {
            peer = (CachePeer)this.rmi.lookup(remoteCacheUrl);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("getCachePeer(" + remoteCacheUrl + "): " + peer);
            }
        }
        catch (Exception e) {
            this.logPeerException(remoteCacheUrl, e);
            peer = null;
        }
        return peer;
    }

    private void logPeerException(String url, Exception e) {
        if (LOGGER.isWarnEnabled()) {
            LOGGER.warn("Cannot communicate with peer '" + url + "': " + e.getMessage());
        }
        LOGGER.debug(url, (Throwable)e);
    }

    private boolean isValidPeer(RMIEndpoint rmiPeer, PDCCacheBean cacheConfig) {
        String dependsOnService = null;
        if (cacheConfig != null) {
            dependsOnService = cacheConfig.getAttribute("dependsOnService");
        }
        boolean valid = true;
        if (dependsOnService != null && !rmiPeer.hasService(dependsOnService)) {
            valid = false;
            if (LOGGER.isDebugEnabled()) {
                String msg = String.format("%s missing required service %s", rmiPeer, dependsOnService);
                LOGGER.debug(msg);
            }
        }
        return valid;
    }

    public void registerPeer(String rmiPeerBase) {
        RMIEndpoint rmiPeer = RMIEndpoint.fromURI(rmiPeerBase);
        this.registerPeer(rmiPeer);
    }

    protected boolean stale(Date arg0) {
        return false;
    }

    public void dispose() throws CacheException {
    }

    public String getScheme() {
        return "RMI";
    }

    public void unregisterPeer(String rmiPeerBase) {
        RMIEndpoint rmiPeer = RMIEndpoint.fromURI(rmiPeerBase);
        this.unregisterPeer(rmiPeer);
    }

    public void registerPeer(RMIEndpoint rmiPeer) {
        this.rmiPeers.put(rmiPeer, new Date());
        LOGGER.info("register: " + rmiPeer);
    }

    public void unregisterPeer(RMIEndpoint rmiPeer) {
        this.rmiPeers.remove(rmiPeer);
        LOGGER.info("unregister: " + rmiPeer);
    }

    public boolean hasPeer(RMIEndpoint rmiPeer) {
        return this.rmiPeers.containsKey(rmiPeer);
    }
}

