/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pdc.core.ehcache;

import com.ibm.cognos.pdc.PDCGrid;
import com.ibm.cognos.pdc.core.PDCGridBuilder;
import com.ibm.cognos.pdc.core.PDCGridBuilderFinder;
import com.ibm.cognos.pdc.core.ehcache.CacheManagerDelegate;
import com.ibm.cognos.pdc.core.ehcache.CacheManagerProvider;
import com.ibm.cognos.pdc.core.ehcache.EhPDCGrid;
import com.ibm.cognos.pdc.core.ehcache.config.ConfigFileLoader;
import com.ibm.cognos.pdc.core.ehcache.config.DOM4JConfigFileLoader;
import com.ibm.cognos.pdc.core.ehcache.pogo.LogKitFactory;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log.Logger;

public class EhPDCGridBuilder
implements PDCGridBuilder {
    private static final Logger LOGGER = LogKitFactory.getLogger(EhPDCGridBuilder.class);
    private static final String LEGACY_GRID_BUILDER = "com.ibm.cognos.pdc.cm.client.CMPDCGridBuilder";
    private final ConcurrentHashMap<String, PDCGrid> grids = new ConcurrentHashMap();
    private final CacheManagerProvider cacheManagerProvider;
    private final ConfigFileLoader configFileLoader;
    private final ConcurrentHashMap<String, PDCGridBuilder> legacyBuilders;

    public EhPDCGridBuilder() {
        this(CacheManagerProvider.getInstance(), DOM4JConfigFileLoader.getInstance());
    }

    protected EhPDCGridBuilder(CacheManagerProvider cacheManagerProvider, ConfigFileLoader configFileLoader) {
        this.cacheManagerProvider = cacheManagerProvider;
        this.configFileLoader = configFileLoader;
        this.legacyBuilders = new ConcurrentHashMap();
    }

    public PDCGrid buildPDCGrid(String componentId) {
        PDCGrid grid = this.grids.get(componentId);
        if (grid == null) {
            if (!this.legacyBuilders.contains(componentId) && this.configFileLoader.hasPDCGrid(componentId)) {
                grid = this.buildEhCacheGrid(componentId);
                grid = this.registerGrid(componentId, grid);
            } else {
                grid = this.buildLegacyPDCGrid(componentId);
            }
            LOGGER.info("buildPDCGrid(" + componentId + ") returning: " + grid);
        }
        return grid;
    }

    private PDCGrid buildLegacyPDCGrid(String componentId) {
        PDCGridBuilder builder = this.legacyBuilders.get(componentId);
        if (builder == null) {
            builder = new PDCGridBuilderFinder().loadPDCGridBuilder(LEGACY_GRID_BUILDER);
            this.legacyBuilders.put(componentId, builder);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Using legacy PDC Grid builder for component " + componentId);
            }
        }
        return builder.buildPDCGrid(componentId);
    }

    private PDCGrid registerGrid(String componentId, PDCGrid grid) {
        PDCGrid registeredGrid = grid;
        PDCGrid existingGrid = this.grids.putIfAbsent(componentId, grid);
        if (existingGrid != null) {
            registeredGrid = existingGrid;
        }
        return registeredGrid;
    }

    private PDCGrid buildEhCacheGrid(String componentId) {
        CacheManagerDelegate cacheManager = this.cacheManagerProvider.getCacheManager();
        return new EhPDCGrid(cacheManager, componentId);
    }
}

