/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pdc.core.ehcache;

import com.ibm.cognos.pdc.CacheException;
import com.ibm.cognos.pdc.CacheMap;
import com.ibm.cognos.pdc.PDCGrid;
import com.ibm.cognos.pdc.SessionContext;
import com.ibm.cognos.pdc.core.AbstractCountersSession;
import com.ibm.cognos.pdc.core.TransactionAlreadyActiveException;
import com.ibm.cognos.pdc.core.TransactionException;
import com.ibm.cognos.pdc.core.ehcache.CacheManagerDelegate;
import com.ibm.cognos.pdc.core.ehcache.EhCacheMap;
import com.ibm.cognos.pdc.core.ehcache.EhPDCGrid;
import com.ibm.cognos.pdc.core.ehcache.TransactionControllerDelegate;
import java.util.Arrays;
import java.util.List;
import net.sf.ehcache.Cache;
import net.sf.ehcache.transaction.local.LocalTransactionContext;

public class EhSession
extends AbstractCountersSession {
    private final EhPDCGrid grid;
    private final SessionContext context;
    private final CacheManagerDelegate cacheManager;
    private TransactionControllerDelegate txnController;

    public EhSession(EhPDCGrid grid, SessionContext context, CacheManagerDelegate cacheManager) {
        this.grid = grid;
        this.context = context;
        this.cacheManager = cacheManager;
    }

    public void beginImpl() throws TransactionAlreadyActiveException, TransactionException {
        this.txnController = this.cacheManager.getTransactionController();
        this.txnController.begin();
    }

    public void commitImpl() throws CacheException {
        this.txnController.commit();
    }

    public CacheMap getMap(String mapName) throws CacheException {
        String cacheName = this.grid.getGridId() + "." + mapName;
        Cache cache = this.cacheManager.getCache(cacheName);
        if (cache == null) {
            this.cacheManager.addCacheIfAbsent(cacheName);
            cache = this.cacheManager.getCache(cacheName);
        }
        return new EhCacheMap(cache, this);
    }

    public boolean isTransactionActive() {
        LocalTransactionContext txnCtx = this.txnController.getCurrentTransactionContext();
        boolean isActive = txnCtx != null && txnCtx.getTransactionId() != null;
        return isActive;
    }

    public void rollbackImpl() throws CacheException {
        this.txnController.rollback();
    }

    public List<String> getMapNames() {
        String[] mapNamesArray = this.cacheManager.getCacheNames();
        return Arrays.asList(mapNamesArray);
    }

    public PDCGrid getPDCGrid() {
        return this.grid;
    }

    public SessionContext getSessionContext() {
        return this.context;
    }
}

